/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;

public class UnasignedCourseRequests
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public UnasignedCourseRequests(StudentSectioningModel model) {
        super(model);
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        for (StudentGroup aac : student.getGroups()) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + aac.getReference();
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        HashSet<String> types = new HashSet<String>();
        for (String type : properties.getProperty("type", "").split("\\,")) {
            if (type.isEmpty()) continue;
            types.add(type);
        }
        boolean skipFull = properties.getPropertyBoolean("skipFull", false);
        CSVFile csv = new CSVFile();
        if (types.size() != 1) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportUnassignedCourse()), new CSVFile.CSVField((Object)MSG.reportCourseRequestPriority()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict()), new CSVFile.CSVField((Object)MSG.reportConflictingCourseRequestPriority())});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportUnassignedCourse()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict()), new CSVFile.CSVField((Object)MSG.reportConflictingCourseRequestPriority())});
        }
        for (Student student : this.getModel().getStudents()) {
            for (Request request : student.getRequests()) {
                Enrollment enrollment;
                if (request instanceof FreeTimeRequest || (enrollment = (Enrollment)assignment.getValue((Variable)request)) != null || !student.canAssign(assignment, request) || !this.matches(request, enrollment)) continue;
                CourseRequest courseRequest = (CourseRequest)request;
                if (!types.isEmpty() && (courseRequest.getRequestPriority() == null || !types.contains(courseRequest.getRequestPriority().name()))) continue;
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(student.getId()));
                line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                line.add(new CSVFile.CSVField((Object)student.getName()));
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (dbStudent != null) {
                    line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                } else {
                    line.add(new CSVFile.CSVField((Object)""));
                }
                line.add(new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())));
                line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                line.add(new CSVFile.CSVField((Object)this.group(student)));
                line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                line.add(new CSVFile.CSVField((Object)((Course)courseRequest.getCourses().get(0)).getName()));
                if (types.size() != 1) {
                    line.add(new CSVFile.CSVField((Object)(courseRequest.getRequestPriority() == null ? "" : courseRequest.getRequestPriority().name())));
                }
                TreeSet<Enrollment> overlaps = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                    @Override
                    public int compare(Enrollment o1, Enrollment o2) {
                        return o1.getRequest().compareTo(o2.getRequest());
                    }
                });
                TreeSet<CallSite> other = new TreeSet<CallSite>();
                Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                List av = courseRequest.getAvaiableEnrollmentsSkipSameTime(assignment);
                Request.RequestPriority conflictPriority = null;
                if (av.isEmpty() || av.size() == 1 && ((Enrollment)av.get(0)).equals((Object)courseRequest.getInitialAssignment()) && this.getModel().inConflict(assignment, (Value)((Enrollment)av.get(0)))) {
                    if (skipFull) continue;
                    if (((Course)courseRequest.getCourses().get(0)).getLimit() >= 0) {
                        line.add(new CSVFile.CSVField((Object)MSG.courseIsFull()));
                    } else if (SectioningRequest.hasInconsistentRequirements(courseRequest, null)) {
                        line.add(new CSVFile.CSVField((Object)MSG.classNotAvailableDueToStudentPrefs()));
                    } else {
                        line.add(new CSVFile.CSVField((Object)MSG.classNotAvailable()));
                    }
                } else {
                    Object x;
                    for (Enrollment enrl : av) {
                        for (Request q : enrl.getStudent().getRequests()) {
                            if (q.equals((Object)request) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                            for (SctAssignment a : x.getAssignments()) {
                                if (!a.isOverlapping(enrl.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)this.getModel().getStudentQuality(), (SctAssignment)a, (Enrollment)enrl)) continue;
                                overlaps.add((Enrollment)x);
                                if (!(x.getRequest() instanceof CourseRequest)) continue;
                                CourseRequest cr = (CourseRequest)x.getRequest();
                                TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                if (ss == null) {
                                    ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                    overlapingSections.put(cr, ss);
                                }
                                ss.add((Section)a);
                            }
                        }
                        block6: for (Unavailability unavailability : student.getUnavailabilities()) {
                            x = enrl.getAssignments().iterator();
                            while (x.hasNext()) {
                                SctAssignment section = (SctAssignment)x.next();
                                if (!HardDistanceConflicts.inConflict((StudentQuality)this.getModel().getStudentQuality(), (Section)((Section)section), (Unavailability)unavailability)) continue;
                                other.add((CallSite)((Object)(unavailability.getCourseName() + " " + unavailability.getSectionName())));
                                continue block6;
                            }
                        }
                    }
                    block8: for (Object unavailability : student.getUnavailabilities()) {
                        for (Course course : courseRequest.getCourses()) {
                            x = course.getOffering().getConfigs().iterator();
                            while (x.hasNext()) {
                                SctAssignment a;
                                Config config = (Config)x.next();
                                a = config.getSubparts().iterator();
                                while (a.hasNext()) {
                                    Subpart subpart = (Subpart)a.next();
                                    for (Section section : subpart.getSections()) {
                                        if (section.getLimit() <= 0 || !unavailability.isOverlapping((SctAssignment)section)) continue;
                                        other.add((CallSite)((Object)(unavailability.getCourseName() + " " + unavailability.getSectionName())));
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                    if (!overlaps.isEmpty() || !other.isEmpty()) {
                        Object unavailability;
                        TreeSet<String> ts = new TreeSet<String>((SortedSet<String>)other);
                        unavailability = overlaps.iterator();
                        while (unavailability.hasNext()) {
                            Enrollment q = (Enrollment)unavailability.next();
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                ts.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            Object ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = (String)ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = (String)ov + ",";
                                }
                            }
                            ts.add((String)ov);
                            if (cr.getRequestPriority() == null || conflictPriority != null && conflictPriority.ordinal() <= cr.getRequestPriority().ordinal()) continue;
                            conflictPriority = cr.getRequestPriority();
                        }
                        Object message = "";
                        Iterator i = ts.iterator();
                        while (i.hasNext()) {
                            String x2 = (String)i.next();
                            if (((String)message).isEmpty()) {
                                message = (String)message + MSG.conflictWithFirst(x2);
                                continue;
                            }
                            if (!i.hasNext()) {
                                message = (String)message + MSG.conflictWithLast(x2);
                                continue;
                            }
                            message = (String)message + MSG.conflictWithMiddle(x2);
                        }
                        line.add(new CSVFile.CSVField(message));
                    } else {
                        if (skipFull) continue;
                        line.add(new CSVFile.CSVField((Object)MSG.courseNotAssigned()));
                    }
                }
                line.add(new CSVFile.CSVField((Object)(conflictPriority == null ? "" : conflictPriority.name())));
                csv.addLine(line);
            }
        }
        return csv;
    }
}

