/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

public class ClassAssignmentChanged
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iClassIds = null;

    public ClassAssignmentChanged forClasses(Long ... classIds) {
        this.iClassIds = new ArrayList<Long>();
        for (Long classId : classIds) {
            this.iClassIds.add(classId);
        }
        return this;
    }

    public ClassAssignmentChanged forClasses(Collection<Long> classIds) {
        this.iClassIds = classIds;
        return this;
    }

    public Collection<Long> getClassIds() {
        return this.iClassIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.info(this.getClassIds().size() + " class assignments changed.");
        OnlineSectioningLog.Enrollment.Builder previous = OnlineSectioningLog.Enrollment.newBuilder().setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
        OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder().setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
        for (Long classId : this.getClassIds()) {
            Class_ clazz = (Class_)Class_DAO.getInstance().get(classId, helper.getHibSession());
            if (clazz == null) {
                helper.warn("Class " + classId + " wos deleted -- unsupported operation (use reload offering instead).");
                continue;
            }
            OnlineSectioningServer.Lock lock = server.lockOffering(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId(), helper.getHibSession().createQuery("select e.student.uniqueId from StudentClassEnrollment e where e.clazz.uniqueId = :classId", Long.class).setParameter("classId", (Object)classId).list(), this.name());
            try {
                XSection oldSection;
                XOffering offering;
                block10: {
                    helper.beginTransaction();
                    try {
                        offering = server.getOffering(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                        XSection xSection = oldSection = offering == null ? null : offering.getSection(clazz.getUniqueId());
                        if (oldSection != null) break block10;
                        helper.warn("Class " + clazz.getClassLabel() + " was added -- unsupported operation (use reload offering instead).");
                        continue;
                    }
                    catch (Exception e) {
                        helper.rollbackTransaction();
                        if (e instanceof SectioningException) {
                            throw (SectioningException)e;
                        }
                        throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                    }
                }
                previous.addSection(OnlineSectioningHelper.toProto(oldSection));
                helper.info("Reloading " + clazz.getClassLabel());
                XSection newSection = new XSection(clazz, helper);
                XSubpart subpart = offering.getSubpart(newSection.getSubpartId());
                subpart.getSections().remove(oldSection);
                subpart.getSections().add(newSection);
                Collections.sort(subpart.getSections());
                server.update(offering);
                stored.addSection(OnlineSectioningHelper.toProto(newSection));
                helper.commitTransaction();
            }
            finally {
                lock.release();
            }
        }
        helper.getAction().addEnrollment(previous);
        helper.getAction().addEnrollment(stored);
        return true;
    }

    @Override
    public String name() {
        return "class-reassigned";
    }
}

