/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.AnyStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;

public class CheckEnrollmentConsistencyAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        ArrayList<CallSite> problems = new ArrayList<CallSite>();
        try {
            for (XCourseId xCourseId : server.findCourses(new AnyCourseMatcher())) {
                Collection<XCourseRequest> requests = server.getRequests(xCourseId.getOfferingId());
                if (requests == null) continue;
                for (XCourseRequest xCourseRequest : requests) {
                    XStudent student = server.getStudent(xCourseRequest.getStudentId());
                    if (student.getRequests().contains(xCourseRequest)) continue;
                    helper.error("Student " + student + " is missing request " + xCourseRequest);
                    problems.add((CallSite)((Object)("Student " + student + " is missing request " + xCourseRequest)));
                }
            }
            for (XStudentId xStudentId : server.findStudents(new AnyStudentMatcher())) {
                XStudent student = server.getStudent(xStudentId.getStudentId());
                for (XRequest xRequest : student.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest)) continue;
                    XCourseRequest cr = (XCourseRequest)xRequest;
                    for (XCourseId course : cr.getCourseIds()) {
                        Collection<XCourseRequest> requests = server.getRequests(course.getOfferingId());
                        if (requests != null && requests.contains(cr)) continue;
                        helper.error("Offering " + course + " is missing request " + xRequest + " from " + student);
                        problems.add((CallSite)((Object)("Offering " + course + " is missing request " + xRequest + " from " + student)));
                    }
                }
            }
        }
        finally {
            lock.release();
        }
        if (!problems.isEmpty()) {
            throw new SectioningException("Consistency check failed: " + ToolBox.col2string(problems, (int)2));
        }
        return true;
    }

    @Override
    public String name() {
        return "check-consistency";
    }
}

