/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.query.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindOnlineSectioningLogAction;
import org.unitime.timetable.util.Constants;

public class DbFindOnlineSectioningLogAction
extends FindOnlineSectioningLogAction {
    private static final long serialVersionUID = 1L;

    @Override
    public List<ClassAssignmentInterface.SectioningAction> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.beginTransaction();
        try {
            ArrayList<ClassAssignmentInterface.SectioningAction> ret = new ArrayList<ClassAssignmentInterface.SectioningAction>();
            AcademicSessionInfo session = server.getAcademicSession();
            FindOnlineSectioningLogAction.SectioningLogQueryFormatter formatter = new FindOnlineSectioningLogAction.SectioningLogQueryFormatter(session, helper);
            Object join = "";
            for (String t : formatter.getGroupTypes()) {
                if (!this.getQuery().hasAttribute(t)) continue;
                join = (String)join + "left outer join s.groups G_" + t + " ";
            }
            Query q = helper.getHibSession().createQuery("select l, s from OnlineSectioningLog l, Student s " + (this.getQuery().hasAttribute("area", "clasf", "classification", "major", "concentration", "campus", "program") ? "left outer join s.areaClasfMajors m " : "") + (this.getQuery().hasAttribute("minor") ? "left outer join s.areaClasfMinors n " : "") + (this.getQuery().hasAttribute("group") ? "left outer join s.groups g " : "") + (this.getQuery().hasAttribute("accommodation") ? "left outer join s.accomodations a " : "") + (this.getQuery().hasAttribute("course") || this.getQuery().hasAttribute("lookup") || this.getQuery().hasAttribute("im") ? "left outer join s.courseDemands cd left outer join cd.courseRequests cr " : "") + (this.getQuery().hasAttribute("im") ? "left outer join cr.courseOffering.instructionalOffering.instrOfferingConfigs cfg left outer join cfg.instructionalMethod im " : "") + (String)join + "where l.session.uniqueId = :sessionId and l.session = s.session and l.student = s.externalUniqueId and (" + this.getQuery().toString(formatter) + ") " + (this.getQuery().hasAttribute("operation") ? "" : "and (l.result is not null or l.operation not in ('reload-offering', 'check-offering', 'reload-student')) and (l.result != 3 or l.operation not in ('validate-overrides', 'critical-courses', 'banner-update')) ") + "order by l.uniqueId desc", Object[].class);
            q.setParameter("sessionId", (Object)session.getUniqueId());
            if (this.getLimit() != null) {
                q.setMaxResults(this.getLimit().intValue());
            }
            HashSet<Long> processedLogIds = new HashSet<Long>();
            for (Object[] o : q.list()) {
                OnlineSectioningLog.Action.ResultType resultType;
                OnlineSectioningLog log = (OnlineSectioningLog)o[0];
                Student student = (Student)o[1];
                if (student == null || !processedLogIds.add(log.getUniqueId())) continue;
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                st.setId(student.getUniqueId());
                st.setSessionId(session.getUniqueId());
                st.setExternalId(student.getExternalUniqueId());
                st.setCanShowExternalId(this.iCanShowExtIds);
                st.setName(helper.getStudentNameFormat().format(student));
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                    st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicArea().getTitle());
                    st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getAcademicClassification().getName());
                    st.addMajor(studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getMajor().getName());
                    st.addConcentration(studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getName());
                    st.addDegree(studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getLabel());
                    st.addProgram(studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getLabel());
                    st.addCampus(studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getReference(), studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getLabel());
                }
                st.setDefaultCampus(server.getAcademicSession().getCampus());
                for (StudentAreaClassificationMinor studentAreaClassificationMinor : new TreeSet<StudentAreaClassificationMinor>(student.getAreaClasfMinors())) {
                    st.addMinor(studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor.getMinor().getName());
                }
                for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
                    st.addAccommodation(studentAccomodation.getAbbreviation(), studentAccomodation.getName());
                }
                for (StudentGroup studentGroup : student.getGroups()) {
                    if (studentGroup.getType() == null) {
                        st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                        continue;
                    }
                    st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                }
                for (Advisor advisor : student.getAdvisors()) {
                    if (advisor.getLastName() == null) continue;
                    st.addAdvisor(helper.getInstructorNameFormat().format(advisor));
                }
                ClassAssignmentInterface.SectioningAction a = new ClassAssignmentInterface.SectioningAction();
                a.setLogId(log.getUniqueId());
                a.setStudent(st);
                a.setStudent(st);
                a.setTimeStamp(log.getTimeStamp());
                a.setOperation(Constants.toInitialCase(log.getOperation().replace('-', ' ')));
                if (log.getUser() != null && log.getUser().equals(st.getExternalId())) {
                    a.setUser(helper.getStudentNameFormat().format(student));
                } else if (log.getUser() != null) {
                    Advisor advisor = Advisor.findByExternalId(log.getUser(), server.getAcademicSession().getUniqueId());
                    if (advisor != null) {
                        a.setUser(helper.getInstructorNameFormat().format(advisor));
                    } else {
                        TimetableManager mgr = TimetableManager.findByExternalId(log.getUser());
                        if (mgr != null) {
                            a.setUser(helper.getInstructorNameFormat().format(mgr));
                        } else {
                            a.setUser(log.getUser());
                        }
                    }
                }
                if (log.getResult() != null && (resultType = OnlineSectioningLog.Action.ResultType.forNumber(log.getResult())) != null) {
                    a.setResult(Constants.toInitialCase(resultType.name()));
                }
                a.setMessage(log.getMessage());
                a.setCpuTime(log.getCpuTime());
                a.setWallTime(log.getWallTime());
                ret.add(a);
            }
            helper.commitTransaction();
            Collections.sort(ret);
            return ret;
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }
}

