/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.UniversalOverrideReservation;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseStudentEnrollmentMessage;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;

public class DbFindEnrollmentAction
extends FindEnrollmentAction {
    private static final long serialVersionUID = 1L;

    public boolean isMyStudent(Student student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
    }

    public boolean isCanSelect(Student student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor ? this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student) : this.iCanSelect;
    }

    @Override
    public List<ClassAssignmentInterface.Enrollment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter == null) {
            return super.execute(server, helper);
        }
        ArrayList<ClassAssignmentInterface.Enrollment> ret = new ArrayList<ClassAssignmentInterface.Enrollment>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(this.courseId(), helper.getHibSession());
        if (course == null) {
            return ret;
        }
        InstructionalOffering offering = course.getInstructionalOffering();
        if (offering == null) {
            return ret;
        }
        ExternalClassNameHelperInterface.HasGradableSubpart gs = null;
        if (ApplicationProperty.OnlineSchedulingGradableIType.isTrue() && Class_.getExternalClassNameHelper() != null && Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasGradableSubpart) {
            gs = (ExternalClassNameHelperInterface.HasGradableSubpart)((Object)Class_.getExternalClassNameHelper());
        }
        for (CourseRequest request : helper.getHibSession().createQuery("from CourseRequest where courseOffering.uniqueId = :courseId", CourseRequest.class).setParameter("courseId", (Object)course.getUniqueId()).setCacheable(true).list()) {
            DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, request, this.isConsentToDoCourse(), this.isMyStudent(request.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup);
            if (this.classId() != null) {
                boolean match = false;
                for (StudentClassEnrollment e : crm.enrollment()) {
                    if (!e.getClazz().getUniqueId().equals(this.classId())) continue;
                    match = true;
                    break;
                }
                if (!match && !crm.enrollment().isEmpty()) continue;
            }
            if (!this.query().match(crm) || crm.enrollment().isEmpty() && !crm.canAssign()) continue;
            Student student = request.getCourseDemand().getStudent();
            ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
            st.setId(student.getUniqueId());
            st.setSessionId(session.getUniqueId());
            st.setExternalId(student.getExternalUniqueId());
            st.setCanShowExternalId(this.iCanShowExtIds);
            StudentSectioningStatus status = student.getEffectiveStatus();
            if (status == null || status.hasOption(StudentSectioningStatus.Option.waitlist)) {
                st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
            } else if (status != null && status.hasOption(StudentSectioningStatus.Option.nosubs)) {
                st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
            } else {
                st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
            }
            st.setCanRegister(this.iCanRegister && (status == null || status.hasOption(StudentSectioningStatus.Option.regenabled) || this.iIsAdmin && status.hasOption(StudentSectioningStatus.Option.regadmin) || this.iIsAdvisor && status.hasOption(StudentSectioningStatus.Option.regadvisor)));
            st.setCanUseAssistant(this.iCanUseAssistant && (status == null || status.hasOption(StudentSectioningStatus.Option.enabled) || this.iIsAdmin && status.hasOption(StudentSectioningStatus.Option.admin) || this.iIsAdvisor && status.hasOption(StudentSectioningStatus.Option.advisor)));
            st.setCanSelect(this.isCanSelect(student));
            st.setName(helper.getStudentNameFormat().format(student));
            for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicArea().getTitle());
                st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getAcademicClassification().getName());
                st.addMajor(studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getMajor().getName());
                st.addConcentration(studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getName());
                st.addDegree(studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getLabel());
                st.addProgram(studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getLabel());
                st.addCampus(studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getReference(), studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getLabel());
            }
            st.setDefaultCampus(server.getAcademicSession().getCampus());
            for (StudentAreaClassificationMinor studentAreaClassificationMinor : new TreeSet<StudentAreaClassificationMinor>(student.getAreaClasfMinors())) {
                st.addMinor(studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor.getMinor().getName());
            }
            for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
                st.addAccommodation(studentAccomodation.getAbbreviation(), studentAccomodation.getName());
            }
            for (StudentGroup studentGroup : student.getGroups()) {
                if (studentGroup.getType() == null) {
                    st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                    continue;
                }
                st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
            }
            for (Advisor advisor : student.getAdvisors()) {
                if (advisor.getLastName() == null) continue;
                st.addAdvisor(helper.getInstructorNameFormat().format(advisor));
            }
            ClassAssignmentInterface.Enrollment e = new ClassAssignmentInterface.Enrollment();
            e.setStudent(st);
            e.setPriority(1 + request.getCourseDemand().getPriority());
            ClassAssignmentInterface.CourseAssignment courseAssignment = new ClassAssignmentInterface.CourseAssignment();
            courseAssignment.setCourseId(course.getUniqueId());
            courseAssignment.setSubject(course.getSubjectAreaAbbv());
            courseAssignment.setCourseNbr(course.getCourseNbr());
            courseAssignment.setTitle(course.getTitle());
            courseAssignment.setHasCrossList(course.getInstructionalOffering().hasCrossList());
            courseAssignment.setCanWaitList(course.getInstructionalOffering().effectiveWaitList());
            e.setCourse(courseAssignment);
            e.setWaitList(request.getCourseDemand().effectiveWaitList());
            e.setNoSub(request.getCourseDemand().effectiveNoSub());
            if (crm.enrollment().isEmpty()) {
                if (request.getCourseDemand().getEnrollmentMessages() != null) {
                    BaseStudentEnrollmentMessage message = null;
                    for (StudentEnrollmentMessage m : request.getCourseDemand().getEnrollmentMessages()) {
                        if (message != null && message.getOrder() >= m.getOrder() && (message.getOrder() != m.getOrder() || !message.getTimestamp().before(m.getTimestamp()))) continue;
                        message = m;
                    }
                    if (message != null) {
                        e.setEnrollmentMessage(message.getMessage());
                    }
                }
                if (request.getOverrideStatus() != null) {
                    switch (request.getCourseRequestOverrideStatus()) {
                        case PENDING: {
                            e.addEnrollmentMessage(MSG.overridePendingShort(course.getCourseName()));
                            break;
                        }
                        case REJECTED: {
                            e.addEnrollmentMessage(MSG.overrideRejectedWaitList(course.getCourseName()));
                            break;
                        }
                        case CANCELLED: {
                            e.addEnrollmentMessage(MSG.overrideCancelledWaitList(course.getCourseName()));
                            break;
                        }
                        case NOT_CHECKED: {
                            e.addEnrollmentMessage(MSG.overrideNotRequested());
                            break;
                        }
                        case NOT_NEEDED: {
                            e.addEnrollmentMessage(MSG.overrideNotNeeded(course.getCourseName()));
                        }
                    }
                }
                if (student.getOverrideStatus() != null && student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST) {
                    switch (student.getMaxCreditOverrideStatus()) {
                        case PENDING: {
                            e.addEnrollmentMessage(MSG.creditStatusPendingShort());
                            break;
                        }
                        case REJECTED: {
                            e.addEnrollmentMessage(MSG.creditStatusDenied());
                            break;
                        }
                        case CANCELLED: {
                            e.addEnrollmentMessage(MSG.creditStatusCancelledWaitList());
                            break;
                        }
                        case NOT_CHECKED: {
                            e.addEnrollmentMessage(MSG.overrideNotRequested());
                        }
                    }
                }
            }
            BaseCourseRequest alt = null;
            for (CourseRequest r : request.getCourseDemand().getCourseRequests()) {
                if (alt != null && alt.getOrder() >= r.getOrder()) continue;
                alt = r;
            }
            if (alt != null && alt.getOrder() < request.getOrder()) {
                e.setAlternative(alt.getCourseOffering().getCourseName());
            }
            if (request.getCourseDemand().isAlternative().booleanValue()) {
                alt = null;
                block22: for (CourseDemand demand : student.getCourseDemands()) {
                    if (demand.getCourseRequests().isEmpty() || demand.isAlternative().booleanValue() || demand.effectiveWaitList() || demand.effectiveNoSub()) continue;
                    for (CourseRequest r : demand.getCourseRequests()) {
                        if (r.getClassEnrollments().isEmpty()) continue;
                        continue block22;
                    }
                    for (CourseRequest r : demand.getCourseRequests()) {
                        if (alt != null && demand.getPriority() >= alt.getCourseDemand().getPriority() && (demand.getPriority() != alt.getCourseDemand().getPriority() || r.getOrder() >= alt.getOrder())) continue;
                        alt = r;
                    }
                }
                if (alt != null) {
                    e.setAlternative(alt.getCourseOffering().getCourseName());
                }
            }
            if (request.getCourseDemand().getTimestamp() != null) {
                e.setRequestedDate(request.getCourseDemand().getTimestamp());
            }
            if (request.getCourseDemand().getWaitlistedTimeStamp() != null && e.isWaitList()) {
                e.setWaitListedDate(request.getCourseDemand().getWaitlistedTimeStamp());
            }
            if (student.isEnrolled(request.getCourseDemand().getWaitListSwapWithCourseOffering())) {
                e.setWaitListedReplacement(request.getCourseDemand().getWaitListSwapWithCourseOffering().getCourseName());
            }
            e.setCritical(request.getCourseDemand().getEffectiveCritical().ordinal());
            if (!crm.enrollment().isEmpty()) {
                if (crm.reservation() != null) {
                    if (crm.reservation() instanceof IndividualReservation) {
                        e.setReservation(MSG.reservationIndividual());
                    } else if (crm.reservation() instanceof LearningCommunityReservation) {
                        e.setReservation(MSG.reservationLearningCommunity());
                    } else if (crm.reservation() instanceof StudentGroupReservation) {
                        e.setReservation(MSG.reservationGroup());
                    } else if (crm.reservation() instanceof CourseReservation) {
                        e.setReservation(MSG.reservationCourse());
                    } else if (crm.reservation() instanceof CurriculumReservation) {
                        e.setReservation(MSG.reservationCurriculum());
                    } else if (crm.reservation() instanceof UniversalOverrideReservation) {
                        e.setReservation(MSG.reservationUniversal());
                    }
                }
                for (StudentClassEnrollment x : crm.enrollment()) {
                    if (x.getTimestamp() == null) continue;
                    if (e.getEnrolledDate() == null) {
                        e.setEnrolledDate(x.getTimestamp());
                        continue;
                    }
                    if (!x.getTimestamp().after(e.getEnrolledDate())) continue;
                    e.setEnrolledDate(x.getTimestamp());
                }
                if (crm.approval() != null) {
                    for (StudentClassEnrollment x : crm.enrollment()) {
                        if (x.getApprovedDate() == null) continue;
                        if (x.getApprovedDate() == null) {
                            e.setApprovedDate(x.getApprovedDate());
                            e.setApprovedBy(x.getApprovedBy());
                            continue;
                        }
                        if (!x.getApprovedDate().after(e.getApprovedDate())) continue;
                        e.setApprovedDate(x.getApprovedDate());
                        e.setApprovedBy(x.getApprovedBy());
                    }
                }
                for (StudentClassEnrollment enrollment : crm.enrollment()) {
                    Class_ section = enrollment.getClazz();
                    SchedulingSubpart subpart = section.getSchedulingSubpart();
                    ClassAssignmentInterface.ClassAssignment a = e.getCourse().addClassAssignment();
                    a.setAlternative(request.getCourseDemand().isAlternative());
                    a.setClassId(section.getUniqueId());
                    a.setSubpart(subpart.getItype().getAbbv().trim());
                    if (subpart.getInstrOfferingConfig().getInstructionalMethod() != null) {
                        a.setSubpart(a.getSubpart() + " (" + subpart.getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                    }
                    a.setClassNumber(section.getSectionNumberString());
                    a.setSection(section.getClassSuffix(course));
                    a.setExternalId(section.getExternalId(course));
                    a.setCancelled(section.isCancelled());
                    a.setLimit(new int[]{section.getEnrollment(), section.getSectioningLimit()});
                    Assignment assignment = section.getCommittedAssignment();
                    if (assignment != null) {
                        for (DayCode d : DayCode.toDayCodes(assignment.getDays())) {
                            a.addDay(d.getIndex());
                        }
                        a.setStart(assignment.getStartSlot());
                        a.setLength(assignment.getSlotPerMtg());
                        a.setBreakTime(assignment.getBreakTime());
                        a.setDatePattern(assignment.getDatePattern().getName());
                    }
                    if (assignment != null && !assignment.getRooms().isEmpty()) {
                        for (Location rm : assignment.getRooms()) {
                            a.addRoom(rm.getUniqueId(), rm.getLabelWithDisplayName());
                        }
                    }
                    if (section.isDisplayInstructor().booleanValue() && !section.getClassInstructors().isEmpty()) {
                        for (ClassInstructor instructor : section.getClassInstructors()) {
                            a.addInstructor(helper.getInstructorNameFormat().format(instructor.getInstructor()));
                            a.addInstructoEmail(instructor.getInstructor().getEmail());
                        }
                    }
                    if (section.getParentClass() != null) {
                        a.setParentSection(section.getParentClass().getClassSuffix(course));
                    }
                    a.setSubpartId(section.getSchedulingSubpart().getUniqueId());
                    a.addNote(course.getScheduleBookNote());
                    a.addNote(section.getSchedulePrintNote());
                    if (section.getSchedulingSubpart().getCredit() != null) {
                        a.setCredit(section.getSchedulingSubpart().getCredit().creditAbbv() + "|" + section.getSchedulingSubpart().getCredit().creditText());
                        a.setCreditRange(Float.valueOf(section.getSchedulingSubpart().getCredit().getMinCredit()), Float.valueOf(section.getSchedulingSubpart().getCredit().getMaxCredit()));
                    } else if (gs != null && gs.isGradableSubpart(section.getSchedulingSubpart(), enrollment.getCourseOffering(), helper.getHibSession()) && course.getCredit() != null) {
                        a.setCredit(course.getCredit().creditAbbv() + "|" + course.getCredit().creditText());
                        a.setCreditRange(Float.valueOf(course.getCredit().getMinCredit()), Float.valueOf(course.getCredit().getMaxCredit()));
                    } else if (gs == null && section.getParentClass() != null && course.getCredit() != null) {
                        a.setCredit(course.getCredit().creditAbbv() + "|" + course.getCredit().creditText());
                        a.setCreditRange(Float.valueOf(course.getCredit().getMinCredit()), Float.valueOf(course.getCredit().getMaxCredit()));
                    }
                    Float creditOverride = section.getCredit(course);
                    if (creditOverride != null) {
                        a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                    }
                    if (a.getParentSection() == null) {
                        String consent;
                        String string = consent = course.getConsentType() == null ? null : course.getConsentType().getLabel();
                        if (consent != null) {
                            a.setParentSection(consent);
                        }
                    }
                    a.setExpected(overExp.getExpected(section.getSectioningLimit(), section.getSectioningInfo() == null ? 0.0 : section.getSectioningInfo().getNbrExpectedStudents()));
                }
            }
            ret.add(e);
        }
        return ret;
    }
}

