/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.query.Query;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentGroupTypeDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.Constants;

public class SectioningStatusFilterAction
implements OnlineSectioningAction<EventInterface.FilterRpcResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    private EventInterface.FilterRpcRequest iRequest = null;

    public SectioningStatusFilterAction forRequest(EventInterface.FilterRpcRequest request) {
        this.iRequest = request;
        return this;
    }

    @Override
    public EventInterface.FilterRpcResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        switch (this.iRequest.getCommand()) {
            case LOAD: {
                return this.load(server, helper);
            }
            case SUGGESTIONS: {
                return this.suggestions(server, helper);
            }
            case ENUMERATE: {
                return this.enumarate(server, helper);
            }
        }
        return null;
    }

    public EventInterface.FilterRpcResponse load(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        int n;
        String visitingStudentsFilter;
        boolean bl;
        EventInterface.FilterRpcResponse.Entity m;
        Object area;
        StudentQuery q;
        EventInterface.FilterRpcResponse.Entity a;
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        StudentQuery query = SectioningStatusFilterAction.getQuery(this.iRequest, server, helper);
        CourseQuery courseQuery = SectioningStatusFilterAction.getCourseQuery(this.iRequest, server, helper);
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> areas = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        for (Object[] o : query.select("aac.academicArea.uniqueId, aac.academicArea.academicAreaAbbreviation, aac.academicArea.title, count(distinct s.uniqueId)").order("aac.academicArea.academicAreaAbbreviation, aac.academicArea.title").group("aac.academicArea.uniqueId, aac.academicArea.academicAreaAbbreviation, aac.academicArea.title").exclude("area").exclude("major").exclude("concentration").exclude("minor").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            a = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            a.setCount(((Number)o[3]).intValue());
            areas.put(a.getUniqueId(), a);
        }
        for (Object[] o : query.select("aam.academicArea.uniqueId, aam.academicArea.academicAreaAbbreviation, aam.academicArea.title, count(distinct s.uniqueId)").from("StudentAreaClassificationMinor aam").where("aam.student = s").order("aam.academicArea.academicAreaAbbreviation, aam.academicArea.title").group("aam.academicArea.uniqueId, aam.academicArea.academicAreaAbbreviation, aam.academicArea.title").exclude("area").exclude("major").exclude("concentration").exclude("minor").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            a = (EventInterface.FilterRpcResponse.Entity)areas.get((Long)o[0]);
            if (a == null) {
                a = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
                a.setCount(((Number)o[3]).intValue());
                areas.put(a.getUniqueId(), a);
            } else {
                a.setCount(a.getCount() + ((Number)o[3]).intValue());
            }
            areas.put(a.getUniqueId(), a);
        }
        response.add("area", new TreeSet<EventInterface.FilterRpcResponse.Entity>(areas.values()));
        if (this.iRequest.hasOptions("area")) {
            q = new StudentQuery(query);
            int id = 0;
            area = "";
            for (String string : this.iRequest.getOptions("area")) {
                area = (String)area + (((String)area).isEmpty() ? "" : ",") + ":Xar" + id;
                q.addParameter("area", "Xar" + id, string);
                ++id;
            }
            q.addWhere("xxx", "aac.academicArea.academicAreaAbbreviation in (" + (String)area + ")");
            ArrayList majors = new ArrayList();
            for (Object[] objectArray : q.select("aac.major.uniqueId, aac.major.code, aac.major.name, count(distinct s)").order("aac.major.code, aac.major.name").group("aac.major.uniqueId, aac.major.code, aac.major.name").exclude("major").exclude("concentration").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
                m = new EventInterface.FilterRpcResponse.Entity((Long)objectArray[0], (String)objectArray[1], (String)objectArray[2], new String[0]);
                m.setCount(((Number)objectArray[3]).intValue());
                majors.add(m);
            }
            response.add("major", majors);
        }
        if (this.iRequest.hasOptions("major")) {
            q = new StudentQuery(query);
            int id = 0;
            area = "";
            if (this.iRequest.hasOptions("area")) {
                for (String string : this.iRequest.getOptions("area")) {
                    area = (String)area + (((String)area).isEmpty() ? "" : ",") + ":Xar" + id;
                    q.addParameter("area", "Xar" + id, string);
                    ++id;
                }
            }
            Object major = "";
            id = 0;
            for (String string : this.iRequest.getOptions("major")) {
                major = (String)major + (((String)major).isEmpty() ? "" : ",") + ":Xmj" + id;
                q.addParameter("major", "Xmj" + id, string);
                ++id;
            }
            q.addWhere("xxx", (String)(((String)area).isEmpty() ? "" : "aac.academicArea.academicAreaAbbreviation in (" + (String)area + ") and ") + "aac.major.code in (" + (String)major + ")");
            ArrayList<EventInterface.FilterRpcResponse.Entity> arrayList = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (Object o : q.select("aac.concentration.uniqueId, aac.concentration.code, aac.concentration.name, count(distinct s)").order("aac.concentration.code, aac.concentration.name").group("aac.concentration.uniqueId, aac.concentration.code, aac.concentration.name").exclude("concentration").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
                EventInterface.FilterRpcResponse.Entity m2 = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
                m2.setCount(((Number)o[3]).intValue());
                arrayList.add(m2);
            }
            response.add("concentration", arrayList);
        }
        if (this.iRequest.hasOptions("area")) {
            q = new StudentQuery(query);
            int id = 0;
            area = "";
            for (String string : this.iRequest.getOptions("area")) {
                area = (String)area + (((String)area).isEmpty() ? "" : ",") + ":Xar" + id;
                q.addParameter("area", "Xar" + id, string);
                ++id;
            }
            q.addFrom("area", "StudentAreaClassificationMinor aam");
            q.addWhere("area", "aam.student = s and aam.academicArea.academicAreaAbbreviation in (" + (String)area + ")");
            ArrayList<EventInterface.FilterRpcResponse.Entity> minors = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (Object[] objectArray : q.select("aam.minor.uniqueId, aam.minor.code, aam.minor.name, count(distinct s)").order("aam.minor.code, aam.minor.name").group("aam.minor.uniqueId, aam.minor.code, aam.minor.name").exclude("minor").exclude("classification").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
                m = new EventInterface.FilterRpcResponse.Entity((Long)objectArray[0], (String)objectArray[1], (String)objectArray[2], new String[0]);
                m.setCount(((Number)objectArray[3]).intValue());
                minors.add(m);
            }
            response.add("minor", minors);
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> classifications = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object o : query.select("aac.academicClassification.uniqueId, aac.academicClassification.code, aac.academicClassification.name, count(distinct s)").order("aac.academicClassification.code, aac.academicClassification.name").group("aac.academicClassification.uniqueId, aac.academicClassification.code, aac.academicClassification.name").exclude("classification").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            classifications.add(c);
        }
        response.add("classification", classifications);
        ArrayList<EventInterface.FilterRpcResponse.Entity> degrees = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object o : query.select("aac.degree.uniqueId, aac.degree.reference, aac.degree.label, count(distinct s)").order("aac.degree.reference, aac.degree.label").group("aac.degree.uniqueId, aac.degree.reference, aac.degree.label").exclude("degree").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            entity.setCount(((Number)o[3]).intValue());
            degrees.add(entity);
        }
        response.add("degree", degrees);
        ArrayList<EventInterface.FilterRpcResponse.Entity> programs = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object[] objectArray : query.select("aac.program.uniqueId, aac.program.reference, aac.program.label, count(distinct s)").order("aac.program.reference, aac.program.label").group("aac.program.uniqueId, aac.program.reference, aac.program.label").exclude("program").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity((Long)objectArray[0], (String)objectArray[1], (String)objectArray[2], new String[0]);
            entity.setCount(((Number)objectArray[3]).intValue());
            programs.add(entity);
        }
        response.add("program", programs);
        ArrayList<EventInterface.FilterRpcResponse.Entity> campuses = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        boolean bl2 = false;
        for (Object o : query.select("aac.campus.uniqueId, aac.campus.reference, aac.campus.label, count(distinct s)").order("aac.campus.reference, aac.campus.label").group("aac.campus.uniqueId, aac.campus.reference, aac.campus.label").exclude("campus").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            if (server.getAcademicSession().getCampus().equals(o[1])) {
                bl = true;
            }
            campuses.add(c);
        }
        if (campuses.size() == 1 && bl) {
            campuses.clear();
        }
        response.add("campus", campuses);
        ArrayList<EventInterface.FilterRpcResponse.Entity> arrayList = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object[] o : query.select("g.uniqueId, g.groupAbbreviation, g.groupName, count(distinct s)").from("inner join s.groups g").where("g.type is null").order("g.groupAbbreviation, g.groupName").group("g.uniqueId, g.groupAbbreviation, g.groupName").exclude("group").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            arrayList.add(c);
        }
        response.add("group", arrayList);
        for (Object type : StudentGroupTypeDAO.getInstance().findAll(helper.getHibSession())) {
            ArrayList<EventInterface.FilterRpcResponse.Entity> groupsOfThisType = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (Object o : query.select("gt.uniqueId, gt.groupAbbreviation, gt.groupName, count(distinct s)").from("inner join s.groups gt").where("gt.type.uniqueId = :groupTypeId").set("groupTypeId", ((BaseRefTableEntry)type).getUniqueId()).order("gt.groupAbbreviation, gt.groupName").group("gt.uniqueId, gt.groupAbbreviation, gt.groupName").exclude(((BaseRefTableEntry)type).getReference().replace(' ', '_')).exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
                EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
                c.setCount(((Number)o[3]).intValue());
                groupsOfThisType.add(c);
            }
            response.add(((BaseRefTableEntry)type).getReference().replace(' ', '_'), groupsOfThisType);
            if (((BaseRefTableEntry)type).getLabel() == null) continue;
            response.setTypeLabel(((BaseRefTableEntry)type).getReference().replace(' ', '_'), ((BaseRefTableEntry)type).getLabel());
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> acc = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (Object[] o : query.select("a.uniqueId, a.abbreviation, a.name, count(distinct s)").from("inner join s.accomodations a").order("a.abbreviation, a.name").group("a.uniqueId, a.abbreviation, a.name").exclude("accommodation").exclude("course").exclude("lookup").exclude("prefer").exclude("require").exclude("im").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity c = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[2], new String[0]);
            c.setCount(((Number)o[3]).intValue());
            acc.add(c);
        }
        response.add("accommodation", acc);
        ArrayList<EventInterface.FilterRpcResponse.Entity> states = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        int defaultStatus = ((Number)query.select("count(distinct s)").where("s.sectioningStatus is null").exclude("status").exclude("credit").query(helper.getHibSession()).uniqueResult()).intValue();
        if (defaultStatus > 0) {
            Session session = (Session)SessionDAO.getInstance().get(server.getAcademicSession().getUniqueId(), helper.getHibSession());
            EventInterface.FilterRpcResponse.Entity s = session.getDefaultSectioningStatus() == null ? new EventInterface.FilterRpcResponse.Entity(0L, "Not Set", "No Restrictions (Default)", new String[0]) : new EventInterface.FilterRpcResponse.Entity(session.getDefaultSectioningStatus().getUniqueId(), "Not Set", session.getDefaultSectioningStatus().getReference() + " (Default)", "hint", session.getDefaultSectioningStatus().getLabel());
            s.setCount(defaultStatus);
            states.add(s);
        }
        for (Object o : query.select("s.sectioningStatus.uniqueId, s.sectioningStatus.reference, s.sectioningStatus.label, count(distinct s)").order("s.sectioningStatus.reference, s.sectioningStatus.label").group("s.sectioningStatus.uniqueId, s.sectioningStatus.reference, s.sectioningStatus.label").exclude("status").exclude("credit").query(helper.getHibSession()).list()) {
            EventInterface.FilterRpcResponse.Entity s = new EventInterface.FilterRpcResponse.Entity((Long)o[0], (String)o[1], (String)o[1], "hint", (String)o[2]);
            s.setCount(((Number)o[3]).intValue());
            states.add(s);
        }
        if (states.size() > 1) {
            response.add("status", states);
        }
        HashMap<Integer, Integer> crit2count = new HashMap<Integer, Integer>();
        for (Object[] o : courseQuery.select("cd.critical, count(distinct cd)").where("cd.critical is not null and cd.criticalOverride is null").order("cd.critical").group("cd.critical").exclude("assignment").query(helper.getHibSession()).list()) {
            crit2count.put((Integer)o[0], ((Number)o[1]).intValue());
        }
        for (Object[] o : courseQuery.select("cd.criticalOverride, count(distinct cd)").where("cd.criticalOverride is not null").order("cd.criticalOverride").group("cd.criticalOverride").exclude("assignment").query(helper.getHibSession()).list()) {
            Integer pref = (Integer)crit2count.get((Integer)o[0]);
            crit2count.put((Integer)o[0], ((Number)o[1]).intValue() + (pref == null ? 0 : pref));
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> assignment = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        assignment.add(new EventInterface.FilterRpcResponse.Entity(0L, "Assigned", CONSTANTS.assignmentType()[0], "translated-value", CONSTANTS.assignmentType()[0]));
        assignment.add(new EventInterface.FilterRpcResponse.Entity(1L, "Reserved", CONSTANTS.assignmentType()[1], "translated-value", CONSTANTS.assignmentType()[1]));
        assignment.add(new EventInterface.FilterRpcResponse.Entity(2L, "Not Assigned", CONSTANTS.assignmentType()[2], "translated-value", CONSTANTS.assignmentType()[2]));
        if (crit2count.containsKey(CourseDemand.Critical.CRITICAL.ordinal())) {
            if (CONSTANTS.assignmentType().length > 4) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(4L, "Critical", CONSTANTS.assignmentType()[4], "translated-value", CONSTANTS.assignmentType()[4]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(4L, "Critical", "Critical", new String[0]));
            }
            ((EventInterface.FilterRpcResponse.Entity)assignment.get(assignment.size() - 1)).setCount((Integer)crit2count.get(CourseDemand.Critical.CRITICAL.ordinal()));
            if (CONSTANTS.assignmentType().length > 5) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(5L, "Assigned Critical", CONSTANTS.assignmentType()[5], "translated-value", CONSTANTS.assignmentType()[5]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(5L, "Assigned Critical", "Assigned Critical", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 6) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(6L, "Not Assigned Critical", CONSTANTS.assignmentType()[6], "translated-value", CONSTANTS.assignmentType()[6]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(6L, "Not Assigned Critical", "Not Assigned Critical", new String[0]));
            }
        }
        if (crit2count.containsKey(CourseDemand.Critical.VITAL.ordinal())) {
            if (CONSTANTS.assignmentType().length > 13) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(13L, "Vital", CONSTANTS.assignmentType()[13], "translated-value", CONSTANTS.assignmentType()[13]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(13L, "Vital", "Vital", new String[0]));
            }
            ((EventInterface.FilterRpcResponse.Entity)assignment.get(assignment.size() - 1)).setCount((Integer)crit2count.get(CourseDemand.Critical.VITAL.ordinal()));
            if (CONSTANTS.assignmentType().length > 14) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(14L, "Assigned Vital", CONSTANTS.assignmentType()[14], "translated-value", CONSTANTS.assignmentType()[14]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(14L, "Assigned Vital", "Assigned Vital", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 15) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(15L, "Not Assigned Vital", CONSTANTS.assignmentType()[15], "translated-value", CONSTANTS.assignmentType()[15]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(15L, "Not Assigned Vital", "Not Assigned Vital", new String[0]));
            }
        }
        if (crit2count.containsKey(CourseDemand.Critical.IMPORTANT.ordinal())) {
            if (CONSTANTS.assignmentType().length > 7) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(7L, "Important", CONSTANTS.assignmentType()[7], "translated-value", CONSTANTS.assignmentType()[7]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(7L, "Important", "Important", new String[0]));
            }
            ((EventInterface.FilterRpcResponse.Entity)assignment.get(assignment.size() - 1)).setCount((Integer)crit2count.get(CourseDemand.Critical.IMPORTANT.ordinal()));
            if (CONSTANTS.assignmentType().length > 8) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(8L, "Assigned Important", CONSTANTS.assignmentType()[8], "translated-value", CONSTANTS.assignmentType()[8]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(8L, "Assigned Important", "Assigned Important", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 9) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(9L, "Not Assigned Important", CONSTANTS.assignmentType()[9], "translated-value", CONSTANTS.assignmentType()[9]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(9L, "Not Assigned Important", "Not Assigned Important", new String[0]));
            }
        }
        if (CONSTANTS.assignmentType().length > 10) {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(10L, "No-Substitutes", CONSTANTS.assignmentType()[10], "translated-value", CONSTANTS.assignmentType()[10]));
        } else {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(10L, "No-Substitutes", "No-Substitutes", new String[0]));
        }
        if (CONSTANTS.assignmentType().length > 11) {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(11L, "Assigned No-Subs", CONSTANTS.assignmentType()[11], "translated-value", CONSTANTS.assignmentType()[11]));
        } else {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(11L, "Assigned No-Subs", "Assigned No-Subs", new String[0]));
        }
        if (CONSTANTS.assignmentType().length > 12) {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(12L, "Not Assigned No-Subs", CONSTANTS.assignmentType()[12], "translated-value", CONSTANTS.assignmentType()[12]));
        } else {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(12L, "Not Assigned No-Subs", "Not Assigned No-Subs", new String[0]));
        }
        if (server instanceof StudentSolver && "LC".equals(server.getConfig().getProperty("Load.LCRequestPriority"))) {
            if (CONSTANTS.assignmentType().length > 16) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(16L, "LC", CONSTANTS.assignmentType()[16], "translated-value", CONSTANTS.assignmentType()[16]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(16L, "LC", "LC", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 17) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(17L, "Assigned LC", CONSTANTS.assignmentType()[17], "translated-value", CONSTANTS.assignmentType()[17]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(17L, "Assigned LC", "Assigned LC", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 18) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(18L, "Not Assigned LC", CONSTANTS.assignmentType()[18], "translated-value", CONSTANTS.assignmentType()[18]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(18L, "Not Assigned LC", "Not Assigned LC", new String[0]));
            }
        } else if (crit2count.containsKey(CourseDemand.Critical.LC.ordinal())) {
            if (CONSTANTS.assignmentType().length > 16) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(16L, "LC", CONSTANTS.assignmentType()[16], "translated-value", CONSTANTS.assignmentType()[16]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(16L, "LC", "LC", new String[0]));
            }
            ((EventInterface.FilterRpcResponse.Entity)assignment.get(assignment.size() - 1)).setCount((Integer)crit2count.get(CourseDemand.Critical.LC.ordinal()));
            if (CONSTANTS.assignmentType().length > 17) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(17L, "Assigned LC", CONSTANTS.assignmentType()[17], "translated-value", CONSTANTS.assignmentType()[17]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(17L, "Assigned LC", "Assigned LC", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 18) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(18L, "Not Assigned LC", CONSTANTS.assignmentType()[18], "translated-value", CONSTANTS.assignmentType()[18]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(18L, "Not Assigned LC", "Not Assigned LC", new String[0]));
            }
        }
        if (server instanceof StudentSolver && (visitingStudentsFilter = server.getConfig().getProperty("Load.VisitingStudentFilter")) != null && !visitingStudentsFilter.isEmpty()) {
            if (CONSTANTS.assignmentType().length > 19) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(19L, "Visiting F2F", CONSTANTS.assignmentType()[19], "translated-value", CONSTANTS.assignmentType()[19]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(19L, "Visiting F2F", "Visiting F2F", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 20) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(20L, "Assigned Visiting F2F", CONSTANTS.assignmentType()[20], "translated-value", CONSTANTS.assignmentType()[20]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(20L, "Assigned Visiting F2F", "Assigned Visiting F2F", new String[0]));
            }
            if (CONSTANTS.assignmentType().length > 21) {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(21L, "Not Assigned Visiting F2F", CONSTANTS.assignmentType()[21], "translated-value", CONSTANTS.assignmentType()[21]));
            } else {
                assignment.add(new EventInterface.FilterRpcResponse.Entity(21L, "Not Assigned Visiting F2F", "Not Assigned Visiting F2F", new String[0]));
            }
        }
        if (!(server instanceof StudentSolver)) {
            assignment.add(new EventInterface.FilterRpcResponse.Entity(3L, "Wait-Listed", CONSTANTS.assignmentType()[3], "translated-value", CONSTANTS.assignmentType()[3]));
        }
        response.add("assignment", assignment);
        ArrayList<EventInterface.FilterRpcResponse.Entity> consent = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        consent.add(new EventInterface.FilterRpcResponse.Entity(-1L, "Consent", CONSTANTS.consentTypeAbbv()[0], "translated-value", CONSTANTS.consentTypeAbbv()[0]));
        for (OfferingConsentType offeringConsentType : OfferingConsentType.getConsentTypeList()) {
            consent.add(new EventInterface.FilterRpcResponse.Entity(offeringConsentType.getUniqueId(), offeringConsentType.getAbbv(), offeringConsentType.getLabel(), new String[0]));
        }
        consent.add(new EventInterface.FilterRpcResponse.Entity(-2L, "No Consent", CONSTANTS.consentTypeAbbv()[1], "translated-value", CONSTANTS.consentTypeAbbv()[1]));
        consent.add(new EventInterface.FilterRpcResponse.Entity(-3L, "Waiting", CONSTANTS.consentTypeAbbv()[2], "translated-value", CONSTANTS.consentTypeAbbv()[2]));
        consent.add(new EventInterface.FilterRpcResponse.Entity(-4L, "Approved", CONSTANTS.consentTypeAbbv()[3], "translated-value", CONSTANTS.consentTypeAbbv()[3]));
        consent.add(new EventInterface.FilterRpcResponse.Entity(-5L, "To Do", CONSTANTS.consentTypeAbbv()[4], "translated-value", CONSTANTS.consentTypeAbbv()[4]));
        response.add("consent", consent);
        if ("true".equals(this.iRequest.getOption("online"))) {
            ArrayList<EventInterface.FilterRpcResponse.Entity> overrides = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (CourseRequest.CourseRequestOverrideStatus status : CourseRequest.CourseRequestOverrideStatus.values()) {
                try {
                    overrides.add(new EventInterface.FilterRpcResponse.Entity(Long.valueOf(-1 - status.ordinal()), Constants.toInitialCase(status.name()), CONSTANTS.overrideType()[status.ordinal()], "translated-value", CONSTANTS.overrideType()[status.ordinal()]));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (!this.iRequest.hasOptions("assignment")) {
                for (Object[] o : query.select("s.overrideStatus, count(distinct s)").where("s.overrideStatus is not null").order("s.overrideStatus").group("s.overrideStatus").exclude("credit").exclude("override").query(helper.getHibSession()).list()) {
                    EventInterface.FilterRpcResponse.Entity e = (EventInterface.FilterRpcResponse.Entity)overrides.get((Integer)o[0]);
                    e.setCount(((Number)o[1]).intValue());
                }
            }
            for (Object[] o : courseQuery.select("cr.overrideStatus, count(distinct cr)").where("cr.overrideStatus is not null").order("cr.overrideStatus").group("cr.overrideStatus").exclude("credit").exclude("override").query(helper.getHibSession()).list()) {
                EventInterface.FilterRpcResponse.Entity e = (EventInterface.FilterRpcResponse.Entity)overrides.get((Integer)o[0]);
                e.setCount(e.getCount() + ((Number)o[1]).intValue());
            }
            Iterator iterator = overrides.iterator();
            while (iterator.hasNext()) {
                if (((EventInterface.FilterRpcResponse.Entity)iterator.next()).getCount() != 0) continue;
                iterator.remove();
            }
            if (!overrides.isEmpty()) {
                EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(-100L, "none", CONSTANTS.noOverride(), "translated-value", CONSTANTS.noOverride());
                overrides.add(entity);
                response.add("override", overrides);
            }
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> modes = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        if (this.iRequest.hasOption("role") && (n = ((Number)query.select("count(distinct s)").where("s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = :Xuser and adv.role.reference = :Xrole and adv.session.uniqueId = s.session.uniqueId)").set("Xuser", this.iRequest.getOption("user")).set("Xrole", this.iRequest.getOption("role")).exclude("mode").exclude("credit").query(helper.getHibSession()).uniqueResult()).intValue()) > 0) {
            EventInterface.FilterRpcResponse.Entity myE = new EventInterface.FilterRpcResponse.Entity(-1L, "My Students", MESSAGES.modeMyStudents(), "translated-value", MESSAGES.modeMyStudents());
            myE.setCount(n);
            modes.add(myE);
            if (ApplicationProperty.StudentSchedulingFilterSkipAdvisedCounts.isTrue()) {
                modes.add(new EventInterface.FilterRpcResponse.Entity(-1L, "My Advised", MESSAGES.modeMyStudentsAdvised(), "translated-value", MESSAGES.modeMyStudentsAdvised()));
                modes.add(new EventInterface.FilterRpcResponse.Entity(-1L, "My Not Advised", MESSAGES.modeMyStudentsNotAdvised(), "translated-value", MESSAGES.modeMyStudentsNotAdvised()));
            } else {
                EventInterface.FilterRpcResponse.Entity myA;
                int myAdvised = ((Number)query.select("count(distinct s)").where("s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = :Xuser and adv.role.reference = :Xrole and adv.session.uniqueId = s.session.uniqueId) and s.advisorCourseRequests is not empty").set("Xuser", this.iRequest.getOption("user")).set("Xrole", this.iRequest.getOption("role")).exclude("mode").exclude("credit").query(helper.getHibSession()).uniqueResult()).intValue();
                if (myAdvised > 0) {
                    myA = new EventInterface.FilterRpcResponse.Entity(-1L, "My Advised", MESSAGES.modeMyStudentsAdvised(), "translated-value", MESSAGES.modeMyStudentsAdvised());
                    myA.setCount(myAdvised);
                    modes.add(myA);
                }
                if (myAdvised < n) {
                    myA = new EventInterface.FilterRpcResponse.Entity(-1L, "My Not Advised", MESSAGES.modeMyStudentsNotAdvised(), "translated-value", MESSAGES.modeMyStudentsNotAdvised());
                    myA.setCount(n - myAdvised);
                    modes.add(myA);
                }
            }
        }
        if (ApplicationProperty.StudentSchedulingFilterSkipAdvisedCounts.isTrue()) {
            modes.add(new EventInterface.FilterRpcResponse.Entity(-1L, "Advised", MESSAGES.modeAdvised(), "translated-value", MESSAGES.modeAdvised()));
            modes.add(new EventInterface.FilterRpcResponse.Entity(-1L, "Not Advised", MESSAGES.modeNotAdvised(), "translated-value", MESSAGES.modeNotAdvised()));
        } else {
            int n2 = ((Number)query.select("count(distinct s)").where("s.advisorCourseRequests is not empty").exclude("mode").exclude("credit").query(helper.getHibSession()).uniqueResult()).intValue();
            if (n2 > 0) {
                EventInterface.FilterRpcResponse.Entity adv = new EventInterface.FilterRpcResponse.Entity(-1L, "Advised", MESSAGES.modeAdvised(), "translated-value", MESSAGES.modeAdvised());
                adv.setCount(n2);
                modes.add(adv);
                int notAdvised = ((Number)query.select("count(distinct s)").where("s.advisorCourseRequests is empty").exclude("mode").exclude("credit").query(helper.getHibSession()).uniqueResult()).intValue();
                if (notAdvised > 0) {
                    EventInterface.FilterRpcResponse.Entity notAdv = new EventInterface.FilterRpcResponse.Entity(-1L, "Not Advised", MESSAGES.modeNotAdvised(), "translated-value", MESSAGES.modeNotAdvised());
                    notAdv.setCount(notAdvised);
                    modes.add(notAdv);
                }
            }
        }
        if (!modes.isEmpty()) {
            response.add("mode", modes);
        }
        ArrayList<EventInterface.FilterRpcResponse.Entity> arrayList2 = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        arrayList2.add(new EventInterface.FilterRpcResponse.Entity(0L, "Any Preference", MESSAGES.termAnyPreference(), "translated-value", MESSAGES.termAnyPreference()));
        arrayList2.add(new EventInterface.FilterRpcResponse.Entity(1L, "Met Preference", MESSAGES.termMetPreference(), "translated-value", MESSAGES.termMetPreference()));
        arrayList2.add(new EventInterface.FilterRpcResponse.Entity(2L, "Unmet Preference", MESSAGES.termUnmetPreference(), "translated-value", MESSAGES.termUnmetPreference()));
        response.add("prefer", arrayList2);
        ArrayList<EventInterface.FilterRpcResponse.Entity> requires = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        requires.add(new EventInterface.FilterRpcResponse.Entity(0L, "Any Requirement", MESSAGES.termAnyRequirement(), "translated-value", MESSAGES.termAnyRequirement()));
        requires.add(new EventInterface.FilterRpcResponse.Entity(1L, "Met Requirement", MESSAGES.termMetRequirement(), "translated-value", MESSAGES.termMetRequirement()));
        requires.add(new EventInterface.FilterRpcResponse.Entity(2L, "Unmet Requirement", MESSAGES.termUnmetRequirement(), "translated-value", MESSAGES.termUnmetRequirement()));
        response.add("require", requires);
        ArrayList<EventInterface.FilterRpcResponse.Entity> instructionalMethods = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        for (InstructionalMethod im : InstructionalMethod.findAll()) {
            instructionalMethods.add(new EventInterface.FilterRpcResponse.Entity(im.getUniqueId(), im.getReference(), im.getLabel(), new String[0]));
        }
        response.add("im", instructionalMethods);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public EventInterface.FilterRpcResponse suggestions(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        EventInterface.FilterRpcResponse response;
        block49: {
            void var8_34;
            String token;
            Object s;
            Object where;
            StudentQuery query;
            block50: {
                CourseOffering co;
                Class_ c;
                String studentIdPattern;
                boolean studentIdMatch;
                response = new EventInterface.FilterRpcResponse();
                if (CustomCourseLookupHolder.hasProvider() && !this.iRequest.getText().isEmpty() && (response.getSuggestions() == null || response.getSuggestions().size() < 20)) {
                    try {
                        CustomCourseLookupHolder.getProvider().addSuggestions(server, helper, this.iRequest.getText(), response);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                boolean bl = studentIdMatch = (studentIdPattern = ApplicationProperty.OnlineSchedulingStudentIdPattern.value()) != null && !studentIdPattern.isEmpty() && this.iRequest.getText().trim().matches(studentIdPattern);
                if (!(this.iRequest.getText().isEmpty() || response.getSuggestions() != null && response.getSuggestions().size() >= 20 || studentIdMatch)) {
                    List subjects = helper.getHibSession().createQuery("select s from SubjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation) like :name or lower(' ' || s.title) like :title) order by s.subjectAreaAbbreviation", SubjectArea.class).setParameter("name", (Object)(this.iRequest.getText().toLowerCase() + "%")).setParameter("title", (Object)("% " + this.iRequest.getText().toLowerCase() + "%")).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setMaxResults(20).list();
                    for (SubjectArea subjectArea : subjects) {
                        response.addSuggestion(subjectArea.getSubjectAreaAbbreviation() + " - " + subjectArea.getTitle(), subjectArea.getSubjectAreaAbbreviation(), "Subject Area", "course", true);
                    }
                    if (subjects.size() == 1) {
                        for (CourseOffering courseOffering : new TreeSet<CourseOffering>(((SubjectArea)subjects.get(0)).getCourseOfferings())) {
                            if (courseOffering.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                            response.addSuggestion(courseOffering.getCourseName() + (String)(courseOffering.getTitle() == null ? "" : " - " + courseOffering.getTitle()), courseOffering.getCourseName(), "Course Offering", "course");
                        }
                    } else if (subjects.isEmpty()) {
                        List courses = helper.getHibSession().createQuery("select c from CourseOffering c inner join c.subjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation || ' ' || c.courseNbr) like :name or lower(' ' || c.title) like :title) and c.instructionalOffering.notOffered = false order by s.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("name", (Object)(this.iRequest.getText().toLowerCase() + "%")).setParameter("title", (Object)("% " + this.iRequest.getText().toLowerCase() + "%")).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setMaxResults(20).list();
                        for (CourseOffering course : courses) {
                            response.addSuggestion(course.getCourseName() + (String)(course.getTitle() == null ? "" : " - " + course.getTitle()), course.getCourseName(), "Course Offering", "course", true);
                        }
                    }
                }
                query = SectioningStatusFilterAction.getQuery(this.iRequest, server, helper);
                if (!(this.iRequest.getText().isEmpty() || response.getSuggestions() != null && response.getSuggestions().size() >= 20)) {
                    if (studentIdMatch) {
                        instance = query.select("distinct s").exclude("student").order("s.lastName, s.firstName, s.middleName");
                        ((StudentQuery.QueryInstance)((Object)instance)).where("s.externalUniqueId = :id");
                        if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                            ((StudentQuery.QueryInstance)((Object)instance)).set("id", this.iRequest.getText().trim().replaceFirst("^0+(?!$)", ""));
                        } else {
                            ((StudentQuery.QueryInstance)((Object)instance)).set("id", this.iRequest.getText().trim());
                        }
                        for (Student student : ((StudentQuery.QueryInstance)((Object)instance)).limit(20).query(helper.getHibSession()).list()) {
                            response.addSuggestion(helper.getStudentNameFormat().format(student), student.getExternalUniqueId(), "Student", "student");
                        }
                    } else {
                        void var8_23;
                        instance = query.select("distinct s").exclude("student").order("s.lastName, s.firstName, s.middleName");
                        boolean bl2 = false;
                        where = "";
                        s = new StringTokenizer(this.iRequest.getText().trim(), ", ");
                        while (((StringTokenizer)s).hasMoreTokens()) {
                            token = ((StringTokenizer)s).nextToken().toUpperCase();
                            if (!((String)where).isEmpty()) {
                                where = (String)where + " and ";
                            }
                            where = (String)where + "(upper(s.firstName) like :cn" + (int)var8_23 + " || '%' or upper(s.middleName) like :cn" + (int)var8_23 + " || '%' or upper(s.lastName) like :cn" + (int)var8_23 + " || '%' or upper(s.email) like :cn" + (int)var8_23 + ")";
                            ((StudentQuery.QueryInstance)((Object)instance)).set("cn" + (int)var8_23, token);
                            ++var8_23;
                        }
                        if (var8_23 > 0) {
                            ((StudentQuery.QueryInstance)((Object)instance)).where("(" + (String)where + ") or upper(trim(trailing ' ' from s.lastName || ', ' || s.firstName || ' ' || s.middleName)) = :name or s.externalUniqueId = :id");
                            ((StudentQuery.QueryInstance)((Object)instance)).set("name", this.iRequest.getText().trim().toUpperCase());
                            if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                                ((StudentQuery.QueryInstance)((Object)instance)).set("id", this.iRequest.getText().trim().replaceFirst("^0+(?!$)", ""));
                            } else {
                                ((StudentQuery.QueryInstance)((Object)instance)).set("id", this.iRequest.getText().trim());
                            }
                            for (Student student : ((StudentQuery.QueryInstance)((Object)instance)).limit(20).query(helper.getHibSession()).list()) {
                                response.addSuggestion(helper.getStudentNameFormat().format(student), student.getExternalUniqueId(), "Student", "student");
                            }
                        }
                    }
                }
                if (!this.iRequest.getText().isEmpty() && (response.getSuggestions() == null || response.getSuggestions().size() < 20) && "true".equals(this.iRequest.getOption("approval"))) {
                    for (TimetableManager timetableManager : helper.getHibSession().createQuery("select distinct m from TimetableManager m inner join m.managerRoles r inner join m.departments d where  (lower(m.externalUniqueId) like :q || '%' or lower(m.emailAddress) like :q || '%' or lower(m.lastName) || ' ' || lower(m.firstName) like :q || '%') and 'ConsentApproval' in elements(r.role.rights) and d.session.uniqueId = :sessionId order by m.lastName, m.firstName, m.middleName", TimetableManager.class).setParameter("q", (Object)this.iRequest.getText().toLowerCase()).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setMaxResults(20).list()) {
                        response.addSuggestion(timetableManager.getName(), timetableManager.getName(), "Approved by", "approver");
                    }
                    for (DepartmentalInstructor departmentalInstructor : helper.getHibSession().createQuery("select distinct i from CourseOffering c inner join c.instructionalOffering.offeringCoordinators oc inner join oc.instructor i where c.subjectArea.session.uniqueId = :sessionId and c.consentType.reference != :reference and (lower(i.externalUniqueId) like :q || '%' or lower(i.email) like :q || '%' or lower(i.lastName) || ' ' || lower(i.firstName) like :q || '%') order by i.lastName, i.firstName, i.middleName", DepartmentalInstructor.class).setParameter("q", (Object)this.iRequest.getText().toLowerCase()).setParameter("reference", (Object)"IN").setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setMaxResults(20).list()) {
                        response.addSuggestion(departmentalInstructor.getNameLastFirst(), departmentalInstructor.getNameLastFirst(), "Approved by", "approver");
                    }
                }
                if (this.iRequest.getText().length() > 1 && (response.getSuggestions() == null || response.getSuggestions().size() < 20) && this.iRequest.getText().matches(ApplicationProperty.OnlineSchedulingDashboardSuggestionsOperationPattern.value())) {
                    int days = ApplicationProperty.OnlineSchedulingDashboardSuggestionsLogDays.intValue();
                    if (days > 0) {
                        StudentQuery.QueryInstance queryInstance = query.select("distinct l.operation").exclude("operation").order("l.operation").from("OnlineSectioningLog l").where("l.session.uniqueId = :sessionId").where("l.student = s.externalUniqueId").where("l.timeStamp > " + HibernateUtil.addDate("current_date()", ":days")).set("days", -days);
                        q = this.iRequest.getText();
                        if (!"operation".startsWith(q.toLowerCase())) {
                            queryInstance.set("q", q);
                            queryInstance.where("l.operation like :q || '%'");
                        }
                        for (String op : queryInstance.limit(20).query(helper.getHibSession()).list()) {
                            response.addSuggestion(Constants.toInitialCase(op.replace('-', ' ')), op, "Operation", "operation");
                        }
                    } else if (days < 0) {
                        StudentQuery.QueryInstance queryInstance = query.select("distinct l.operation").exclude("operation").order("l.operation").from("OnlineSectioningLog l").where("l.session.uniqueId = :sessionId").where("l.student = s.externalUniqueId");
                        q = this.iRequest.getText();
                        if (!"operation".startsWith(q.toLowerCase())) {
                            queryInstance.set("q", q);
                            queryInstance.where("l.operation like :q || '%'");
                        }
                        for (String op : queryInstance.limit(20).query(helper.getHibSession()).list()) {
                            response.addSuggestion(Constants.toInitialCase(op.replace('-', ' ')), op, "Operation", "operation");
                        }
                    }
                }
                if (this.iRequest.getText().length() > 1 && (response.getSuggestions() == null || response.getSuggestions().size() < 20)) {
                    StudentQuery.QueryInstance instance = query.select("distinct im.label").exclude("prefer").exclude("require").from("inner join s.courseDemands pcd inner join pcd.courseRequests pcr inner join pcr.preferences pp inner join pp.instructionalMethod im").where("lower(im.reference) like :q || '%' or lower(im.label) like :q || '%'").set("q", this.iRequest.getText().toLowerCase());
                    for (String im : instance.limit(20).query(helper.getHibSession()).list()) {
                        response.addSuggestion(im, im, "Prefer", "prefer", true);
                    }
                }
                if (this.iRequest.getText().length() > 1 && (response.getSuggestions() == null || response.getSuggestions().size() < 20)) {
                    StudentQuery.QueryInstance instance = query.select("distinct im.label").exclude("prefer").exclude("require").from("inner join s.courseDemands pcd inner join pcd.courseRequests pcr inner join pcr.preferences pp inner join pp.instructionalMethod im").where("lower(im.reference) like :q || '%' or lower(im.label) like :q || '%'").where("pp.required = true").set("q", this.iRequest.getText().toLowerCase());
                    for (String im : instance.limit(20).query(helper.getHibSession()).list()) {
                        response.addSuggestion(im, im, "Require", "require", true);
                    }
                }
                if (this.iRequest.getText().length() > 1 && (response.getSuggestions() == null || response.getSuggestions().size() < 20)) {
                    StudentQuery.QueryInstance instance = query.select("distinct c, pcr.courseOffering").exclude("prefer").exclude("require").from("inner join s.courseDemands pcd inner join pcd.courseRequests pcr inner join pcr.preferences pp inner join pp.clazz c").where("lower(pp.label) like :q || '%'").set("q", this.iRequest.getText().toLowerCase());
                    for (Object[] o : instance.limit(20).query(helper.getHibSession()).list()) {
                        c = (Class_)o[0];
                        co = (CourseOffering)o[1];
                        response.addSuggestion(c.getClassLabel(co, true), c.getClassPrefLabel(co), "Prefer", "prefer", true);
                    }
                }
                if (this.iRequest.getText().length() > 1 && (response.getSuggestions() == null || response.getSuggestions().size() < 20)) {
                    StudentQuery.QueryInstance instance = query.select("distinct c, pcr.courseOffering").exclude("prefer").exclude("require").from("inner join s.courseDemands pcd inner join pcd.courseRequests pcr inner join pcr.preferences pp inner join pp.clazz c").where("lower(pp.label) like :q || '%'").where("pp.required = true").set("q", this.iRequest.getText().toLowerCase());
                    for (Object[] o : instance.limit(20).query(helper.getHibSession()).list()) {
                        c = (Class_)o[0];
                        co = (CourseOffering)o[1];
                        response.addSuggestion(c.getClassLabel(co, true), c.getClassPrefLabel(co), "Require", "require", true);
                    }
                }
                if (this.iRequest.getText().isEmpty() || response.getSuggestions() != null && response.getSuggestions().size() >= 20) break block49;
                if (!studentIdMatch) break block50;
                StudentQuery.QueryInstance instance = query.select("distinct ax").exclude("advisor").from("inner join s.advisors ax").where("ax.lastName is not null").order("ax.lastName, ax.firstName, ax.middleName");
                instance.where("ax.externalUniqueId = :id");
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                    instance.set("id", this.iRequest.getText().trim().replaceFirst("^0+(?!$)", ""));
                } else {
                    instance.set("id", this.iRequest.getText().trim());
                }
                for (Advisor advisor : instance.limit(20).query(helper.getHibSession()).list()) {
                    response.addSuggestion(helper.getStudentNameFormat().format(advisor), advisor.getExternalUniqueId(), "Advisor", "advisor");
                }
                break block49;
            }
            StudentQuery.QueryInstance instance = query.select("distinct ax").exclude("advisor").from("inner join s.advisors ax").where("ax.lastName is not null").order("ax.lastName, ax.firstName, ax.middleName");
            boolean bl = false;
            where = "";
            s = new StringTokenizer(this.iRequest.getText().trim(), ", ");
            while (((StringTokenizer)s).hasMoreTokens()) {
                token = ((StringTokenizer)s).nextToken().toUpperCase();
                if (!((String)where).isEmpty()) {
                    where = (String)where + " and ";
                }
                where = (String)where + "(upper(ax.firstName) like :cn" + (int)var8_34 + " || '%' or upper(ax.middleName) like :cn" + (int)var8_34 + " || '%' or upper(ax.lastName) like :cn" + (int)var8_34 + " || '%' or upper(ax.email) like :cn" + (int)var8_34 + ")";
                instance.set("cn" + (int)var8_34, token);
                ++var8_34;
            }
            if (var8_34 <= 0) break block49;
            instance.where("(" + (String)where + ") or upper(trim(trailing ' ' from ax.lastName || ', ' || ax.firstName || ' ' || ax.middleName)) = :name or ax.externalUniqueId = :id");
            instance.set("name", this.iRequest.getText().trim().toUpperCase());
            if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                instance.set("id", this.iRequest.getText().trim().replaceFirst("^0+(?!$)", ""));
            } else {
                instance.set("id", this.iRequest.getText().trim());
            }
            for (Advisor advisor : instance.limit(20).query(helper.getHibSession()).list()) {
                response.addSuggestion(helper.getStudentNameFormat().format(advisor), advisor.getExternalUniqueId(), "Advisor", "advisor");
            }
        }
        return response;
    }

    public EventInterface.FilterRpcResponse enumarate(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        return response;
    }

    @Override
    public String name() {
        return "filter-" + this.iRequest.getCommand().name().toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    public static StudentQuery getQuery(EventInterface.FilterRpcRequest request, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        int id;
        HashSet<String> groupTypes = new HashSet<String>();
        for (StudentGroupType type : StudentGroupTypeDAO.getInstance().findAll(helper.getHibSession())) {
            groupTypes.add(type.getReference().replace(' ', '_'));
        }
        StudentQuery query = new StudentQuery(server.getAcademicSession().getUniqueId());
        if (request.getText() == null || !request.getText().isEmpty()) {
            // empty if block
        }
        if (request.hasOption("lookup") && CustomCourseLookupHolder.hasProvider()) {
            try {
                Set<Long> courseIds = CustomCourseLookupHolder.getProvider().getCourseIds(server.getAcademicSession(), helper.getHibSession(), request.getOption("lookup"), true);
                if (courseIds != null && !courseIds.isEmpty()) {
                    String where = null;
                    Object course = "";
                    id = 0;
                    for (Long l : courseIds) {
                        course = (String)course + (((String)course).isEmpty() ? "" : ",") + ":Xcx" + id;
                        query.addParameter("lookup", "Xcx" + id, l);
                        if (++id % 1000 != 0) continue;
                        where = (String)(where == null ? "" : (String)where + " or ") + "co.uniqueId in (" + (String)course + ")";
                        course = "";
                    }
                    if (!((String)course).isEmpty()) {
                        where = (String)(where == null ? "" : where + " or ") + "co.uniqueId in (" + (String)course + ")";
                    }
                    query.addWhere("lookup", where);
                    query.addFrom("lookup", "inner join s.courseDemands cd inner join cd.courseRequests cr inner join cr.courseOffering co");
                }
            }
            catch (Exception courseIds) {}
        } else if (request.hasOptions("lookup") && CustomCourseLookupHolder.hasProvider()) {
            try {
                Object course = "";
                int id2 = 0;
                for (String lookup : request.getOptions("lookup")) {
                    Set<Long> set = CustomCourseLookupHolder.getProvider().getCourseIds(server.getAcademicSession(), helper.getHibSession(), lookup, true);
                    if (set == null || set.isEmpty()) continue;
                    for (Long l : set) {
                        course = (String)course + (((String)course).isEmpty() ? "" : ",") + ":Xcx" + id2;
                        query.addParameter("lookup", "Xcx" + id2, l);
                        ++id2;
                    }
                }
                if (id2 > 0) {
                    query.addWhere("lookup", "co.uniqueId in (" + (String)course + ")");
                    query.addFrom("lookup", "inner join s.courseDemands cd inner join cd.courseRequests cr inner join cr.courseOffering co");
                }
            }
            catch (Exception course) {
                // empty catch block
            }
        }
        Object area = "";
        if (request.hasOptions("area")) {
            boolean like = false;
            for (String d : request.getOptions("area")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                id = 0;
                for (String string : request.getOptions("area")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.academicArea.academicAreaAbbreviation like :Xar" + id;
                    query.addParameter("area", "Xar" + id, string);
                    ++id;
                }
                query.addWhere("area", (String)q);
            } else {
                int id3 = 0;
                for (String string : request.getOptions("area")) {
                    area = (String)area + (((String)area).isEmpty() ? "" : ",") + ":Xar" + id3;
                    query.addParameter("area", "Xar" + id3, string);
                    ++id3;
                }
                query.addWhere("area", "aac.academicArea.academicAreaAbbreviation in (" + (String)area + ")");
            }
        }
        if (request.hasOptions("classification")) {
            boolean like = false;
            for (String d : request.getOptions("classification")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id4 = 0;
                for (String string : request.getOptions("classification")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.academicClassification.code like :Xcf" + id4;
                    query.addParameter("classification", "Xcf" + id4, string);
                    ++id4;
                }
                query.addWhere("classification", (String)q);
            } else {
                Object classf = "";
                int id5 = 0;
                for (String string : request.getOptions("classification")) {
                    classf = (String)classf + (((String)classf).isEmpty() ? "" : ",") + ":Xcf" + id5;
                    query.addParameter("classification", "Xcf" + id5, string);
                    ++id5;
                }
                query.addWhere("classification", "aac.academicClassification.code in (" + (String)classf + ")");
            }
        }
        if (request.hasOptions("degree")) {
            boolean like = false;
            for (String d : request.getOptions("degree")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id6 = 0;
                for (String string : request.getOptions("degree")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.degree.reference like :Xdg" + id6;
                    query.addParameter("degree", "Xdg" + id6, string);
                    ++id6;
                }
                query.addWhere("degree", (String)q);
            } else {
                Object degr = "";
                int id7 = 0;
                for (String string : request.getOptions("degree")) {
                    degr = (String)degr + (((String)degr).isEmpty() ? "" : ",") + ":Xdg" + id7;
                    query.addParameter("degree", "Xdg" + id7, string);
                    ++id7;
                }
                query.addWhere("degree", "aac.degree.reference in (" + (String)degr + ")");
            }
        }
        if (request.hasOptions("program")) {
            boolean like = false;
            for (String d : request.getOptions("program")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id8 = 0;
                for (String string : request.getOptions("program")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.program.reference like :Xpr" + id8;
                    query.addParameter("program", "Xpr" + id8, string);
                    ++id8;
                }
                query.addWhere("program", (String)q);
            } else {
                Object prog = "";
                int id9 = 0;
                for (String string : request.getOptions("program")) {
                    prog = (String)prog + (((String)prog).isEmpty() ? "" : ",") + ":Xpr" + id9;
                    query.addParameter("program", "Xpr" + id9, string);
                    ++id9;
                }
                query.addWhere("program", "aac.program.reference in (" + (String)prog + ")");
            }
        }
        if (request.hasOptions("campus")) {
            boolean like = false;
            for (String d : request.getOptions("campus")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id10 = 0;
                for (String string : request.getOptions("campus")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.campus.reference like :Xcp" + id10;
                    query.addParameter("campus", "Xcp" + id10, string);
                    ++id10;
                }
                query.addWhere("campus", (String)q);
            } else {
                Object prog = "";
                int id11 = 0;
                for (String string : request.getOptions("campus")) {
                    prog = (String)prog + (((String)prog).isEmpty() ? "" : ",") + ":Xcp" + id11;
                    query.addParameter("campus", "Xcp" + id11, string);
                    ++id11;
                }
                query.addWhere("campus", "aac.campus.reference in (" + (String)prog + ")");
            }
        }
        if (request.hasOptions("major")) {
            boolean like = false;
            for (String d : request.getOptions("major")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id12 = 0;
                for (String string : request.getOptions("major")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.major.code like :Xmj" + id12;
                    query.addParameter("major", "Xmj" + id12, string);
                    ++id12;
                }
                query.addWhere("major", (String)q);
            } else {
                Object major = "";
                int id13 = 0;
                for (String string : request.getOptions("major")) {
                    major = (String)major + (((String)major).isEmpty() ? "" : ",") + ":Xmj" + id13;
                    query.addParameter("major", "Xmj" + id13, string);
                    ++id13;
                }
                query.addWhere("major", "aac.major.code in (" + (String)major + ")");
            }
        }
        if (request.hasOptions("concentration")) {
            boolean like = false;
            for (String d : request.getOptions("concentration")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id14 = 0;
                for (String string : request.getOptions("concentration")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aac.concentration.code like :Xcn" + id14;
                    query.addParameter("concentration", "Xcn" + id14, string);
                    ++id14;
                }
                query.addWhere("concentration", (String)q);
            } else {
                Object conc = "";
                int id15 = 0;
                for (String string : request.getOptions("concentration")) {
                    conc = (String)conc + (((String)conc).isEmpty() ? "" : ",") + ":Xcn" + id15;
                    query.addParameter("concentration", "Xcn" + id15, string);
                    ++id15;
                }
                query.addWhere("concentration", "aac.concentration.code in (" + (String)conc + ")");
            }
        }
        if (request.hasOptions("minor")) {
            boolean like = false;
            for (String d : request.getOptions("minor")) {
                if (d.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                Object q = "";
                int id16 = 0;
                for (String string : request.getOptions("minor")) {
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "aam.minor.code like :Xmn" + id16;
                    query.addParameter("minor", "Xmn" + id16, string);
                    ++id16;
                }
                query.addFrom("minor", "StudentAreaClassificationMinor aam");
                query.addWhere("minor", "aam.student = s and (" + (String)q + ")");
            } else {
                Object minor = "";
                int id17 = 0;
                for (String string : request.getOptions("minor")) {
                    minor = (String)minor + (((String)minor).isEmpty() ? "" : ",") + ":Xmn" + id17;
                    query.addParameter("minor", "Xmn" + id17, string);
                    ++id17;
                }
                if (!((String)area).isEmpty()) {
                    query.addFrom("area", "StudentAreaClassificationMinor aam");
                    query.addWhere("area", "aam.student = s and (aac.academicArea.academicAreaAbbreviation in (" + (String)area + ") or aam.academicArea.academicAreaAbbreviation in (" + (String)area + "))");
                    query.addWhere("minor", "aam.minor.code in (" + (String)minor + ")");
                } else {
                    query.addFrom("minor", "StudentAreaClassificationMinor aam");
                    query.addWhere("minor", "aam.student = s and aam.minor.code in (" + (String)minor + ")");
                }
            }
        }
        int gid = 0;
        if (request.hasOptions("group")) {
            boolean like = false;
            for (String string : request.getOptions("group")) {
                if (string.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            query.addFrom("group", "StudentGroup g");
            if (like) {
                Object q = "";
                boolean bl = false;
                for (String string : request.getOptions("group")) {
                    void var9_106;
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "g.groupAbbreviation like :Xgr" + (int)var9_106;
                    query.addParameter("group", "Xgr" + gid, string);
                    ++var9_106;
                }
                query.addWhere("group", "g in elements(s.groups) and (" + (String)q + ")");
            } else {
                Object group = "";
                for (String string : request.getOptions("group")) {
                    group = (String)group + (((String)group).isEmpty() ? "" : ",") + ":Xgr" + gid;
                    query.addParameter("group", "Xgr" + gid, string);
                    ++gid;
                }
                query.addWhere("group", "g in elements(s.groups) and g.groupAbbreviation in (" + (String)group + ")");
            }
        }
        for (String type : groupTypes) {
            void var10_179;
            boolean bl;
            if (!request.hasOptions(type)) continue;
            boolean bl2 = false;
            for (String string : request.getOptions(type)) {
                if (string.indexOf(37) < 0) continue;
                bl = true;
                break;
            }
            query.addFrom(type, "StudentGroup g_" + type);
            if (bl) {
                void var10_176;
                String string = "";
                for (String g : request.getOptions(type)) {
                    String string2 = (String)var10_176 + (var10_176.isEmpty() ? "" : " or ") + "g_" + type + ".groupAbbreviation like :Xgr" + gid;
                    query.addParameter(type, "Xgr" + gid, g);
                    ++gid;
                }
                query.addWhere(type, "g_" + type + " in elements(s.groups) and lower(g_" + type + ".type.reference) = :Xgr" + gid + " and (" + (String)var10_176 + ")");
                query.addParameter(type, "Xgr" + gid, type.toLowerCase());
                ++gid;
                continue;
            }
            String string = "";
            for (String g : request.getOptions(type)) {
                String string3 = (String)var10_179 + (var10_179.isEmpty() ? "" : ",") + ":Xgr" + gid;
                query.addParameter(type, "Xgr" + gid, g);
                ++gid;
            }
            query.addWhere(type, "g_" + type + " in elements(s.groups) and g_" + type + ".groupAbbreviation in (" + (String)var10_179 + ")");
        }
        if (request.hasOptions("accommodation")) {
            boolean like = false;
            for (String string : request.getOptions("accommodation")) {
                if (string.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            query.addFrom("accommodation", "StudentAccomodation a");
            if (like) {
                Object q = "";
                boolean bl = false;
                for (String string : request.getOptions("accommodation")) {
                    void var9_112;
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "a.abbreviation like :Xacc" + (int)var9_112;
                    query.addParameter("accommodation", "Xacc" + (int)var9_112, string);
                    ++var9_112;
                }
                query.addWhere("accommodation", "a in elements(s.accomodations) and (" + (String)q + ")");
            } else {
                Object acc = "";
                boolean bl = false;
                for (String string : request.getOptions("accommodation")) {
                    void var9_114;
                    acc = (String)acc + (((String)acc).isEmpty() ? "" : ",") + ":Xacc" + (int)var9_114;
                    query.addParameter("accommodation", "Xacc" + (int)var9_114, string);
                    ++var9_114;
                }
                query.addWhere("accommodation", "a in elements(s.accomodations) and a.abbreviation in (" + (String)acc + ")");
            }
        }
        if (request.hasOptions("status")) {
            boolean like = false;
            for (String string : request.getOptions("status")) {
                if (string.indexOf(37) < 0) continue;
                like = true;
                break;
            }
            if (like) {
                void var9_117;
                boolean bl;
                Object q = "";
                boolean bl3 = false;
                boolean bl4 = false;
                for (String s : request.getOptions("status")) {
                    if ("Not Set".equals(s)) {
                        bl = true;
                        continue;
                    }
                    q = (String)q + (((String)q).isEmpty() ? "" : " or ") + "s.sectioningStatus.reference like :Xst" + (int)var9_117;
                    query.addParameter("status", "Xst" + (int)var9_117, s);
                    ++var9_117;
                }
                if (var9_117 > 0) {
                    if (bl) {
                        query.addWhere("status", "s.sectioningStatus is null or " + (String)q);
                    } else {
                        query.addWhere("status", (String)q);
                    }
                } else if (bl) {
                    query.addWhere("status", "s.sectioningStatus is null");
                }
            } else {
                void var9_119;
                boolean bl;
                Object status = "";
                boolean bl5 = false;
                boolean bl6 = false;
                for (String s : request.getOptions("status")) {
                    if ("Not Set".equals(s)) {
                        bl = true;
                        continue;
                    }
                    status = (String)status + (((String)status).isEmpty() ? "" : ",") + ":Xst" + (int)var9_119;
                    query.addParameter("status", "Xst" + (int)var9_119, s);
                    ++var9_119;
                }
                if (var9_119 > 0) {
                    if (bl) {
                        query.addWhere("status", "s.sectioningStatus is null or s.sectioningStatus.reference in (" + (String)status + ")");
                    } else {
                        query.addWhere("status", "s.sectioningStatus.reference in (" + (String)status + ")");
                    }
                } else if (bl) {
                    query.addWhere("status", "s.sectioningStatus is null");
                }
            }
        }
        if (request.hasOptions("student")) {
            Object student = "";
            int id23 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(request.getOption("student").trim(), ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().toUpperCase();
                student = (String)student + (((String)student).isEmpty() ? "" : " and ") + "(upper(s.firstName) like :Xstd" + id23 + " || '%' or upper(s.middleName) like :Xstd" + id23 + " || '%' or upper(s.lastName) like :Xstd" + id23 + " || '%' or upper(s.email) like :Xstd" + id23 + " || '%')";
                query.addParameter("student", "Xstd" + id23, string);
                ++id23;
            }
            if (id23 > 0) {
                student = "(" + (String)student + ") or (upper(trim(trailing ' ' from s.lastName || ', ' || s.firstName || ' ' || s.middleName)) = :Xstd) or (s.externalUniqueId = :Xsid)";
                query.addParameter("student", "Xstd", request.getOption("student").trim().toUpperCase());
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                    query.addParameter("student", "Xsid", request.getOption("student").trim().replaceFirst("^0+(?!$)", ""));
                } else {
                    query.addParameter("student", "Xsid", request.getOption("student").trim());
                }
                query.addWhere("student", (String)student);
            }
        }
        if (request.hasOption("advisor")) {
            query.addParameter("advisor", "Xadv", request.getOption("advisor"));
            query.addWhere("advisor", "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = :Xadv and adv.session.uniqueId = s.session.uniqueId)");
        }
        if (request.hasOption("course")) {
            query.addParameter("course", "Xco", request.getOption("course"));
            query.addWhere("course", "co.subjectAreaAbbv = :Xco or co.subjectAreaAbbv || ' ' || co.courseNbr = :Xco");
            query.addFrom("course", "inner join s.courseDemands cd inner join cd.courseRequests cr inner join cr.courseOffering co");
        } else if (request.hasOptions("course")) {
            Object course = "";
            int id24 = 0;
            for (String string : request.getOptions("course")) {
                course = (String)course + (((String)course).isEmpty() ? "" : ",") + ":Xco" + id24;
                query.addParameter("course", "Xco" + id24, string);
                ++id24;
            }
            query.addWhere("course", "co.subjectAreaAbbv in (" + (String)course + ") or co.subjectAreaAbbv || ' ' || co.courseNbr in (" + (String)course + ")");
            query.addFrom("course", "inner join s.courseDemands cd inner join cd.courseRequests cr inner join cr.courseOffering co");
        }
        if (request.hasOption("credit") && !(server instanceof StudentSolver) && (server instanceof DatabaseServer || ApplicationProperty.OnlineSchedulingDashboardCreditFilterUseDatabase.isTrue())) {
            String im;
            float f;
            float min;
            block179: {
                Matcher m;
                String term;
                block178: {
                    void var10_196;
                    void var11_223;
                    term = request.getOption("credit");
                    min = 0.0f;
                    f = Float.MAX_VALUE;
                    Credit credit = Credit.eq;
                    String string = term;
                    if (string.startsWith("<=")) {
                        Credit credit2 = Credit.le;
                        String string4 = string.substring(2);
                    } else if (string.startsWith(">=")) {
                        Credit credit3 = Credit.ge;
                        String string5 = string.substring(2);
                    } else if (string.startsWith("<")) {
                        Credit credit4 = Credit.lt;
                        String string6 = string.substring(1);
                    } else if (string.startsWith(">")) {
                        Credit credit5 = Credit.gt;
                        String string7 = string.substring(1);
                    } else if (string.startsWith("=")) {
                        Credit credit6 = Credit.eq;
                        String string8 = string.substring(1);
                    }
                    im = null;
                    try {
                        float a = Float.parseFloat((String)var11_223);
                        switch (1.$SwitchMap$org$unitime$timetable$onlinesectioning$status$SectioningStatusFilterAction$Credit[var10_196.ordinal()]) {
                            case 1: {
                                min = f = a;
                                break;
                            }
                            case 2: {
                                f = a;
                                break;
                            }
                            case 3: {
                                min = a;
                                break;
                            }
                            case 4: {
                                f = a - 1.0f;
                                break;
                            }
                            case 5: {
                                min = a + 1.0f;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher((CharSequence)var11_223);
                        if (!m.matches()) break block178;
                        float a = Float.parseFloat(m.group(1));
                        im = m.group(2).trim();
                        switch (1.$SwitchMap$org$unitime$timetable$onlinesectioning$status$SectioningStatusFilterAction$Credit[var10_196.ordinal()]) {
                            case 1: {
                                min = f = a;
                                break;
                            }
                            case 2: {
                                f = a;
                                break;
                            }
                            case 3: {
                                min = a;
                                break;
                            }
                            case 4: {
                                f = a - 1.0f;
                                break;
                            }
                            case 5: {
                                min = a + 1.0f;
                            }
                        }
                    }
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Float.parseFloat(a);
                        f = Float.parseFloat(b);
                    }
                    catch (NumberFormatException e) {
                        m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                        if (!m.matches()) break block179;
                        min = Float.parseFloat(m.group(1));
                        f = Float.parseFloat(m.group(2));
                        im = m.group(3).trim();
                    }
                }
            }
            String creditTerm = "(select coalesce(sum(fixedUnits),0) + coalesce(sum(minUnits),0) from CourseCreditUnitConfig where courseOwner.uniqueId in (select courseOffering.uniqueId from StudentClassEnrollment where student = s))";
            if ("!".equals(im)) {
                creditTerm = "(select coalesce(sum(fixedUnits),0) + coalesce(sum(minUnits),0) from CourseCreditUnitConfig where courseOwner.uniqueId in (select courseOffering.uniqueId from StudentClassEnrollment where student = s and clazz.schedulingSubpart.instrOfferingConfig.instructionalMethod is null))";
            } else if (im != null && im.equals(server.getAcademicSession().getDefaultInstructionalMethod())) {
                query.addParameter("credit", "Xim", im.toLowerCase());
                creditTerm = "(select coalesce(sum(fixedUnits),0) + coalesce(sum(minUnits),0) from CourseCreditUnitConfig where courseOwner.uniqueId in (select sce.courseOffering.uniqueId from StudentClassEnrollment sce left outer join sce.clazz.schedulingSubpart.instrOfferingConfig.instructionalMethod im where sce.student = s and (im is null or lower(im.reference) = :Xim)))";
            } else if (im != null) {
                creditTerm = "(select coalesce(sum(fixedUnits),0) + coalesce(sum(minUnits),0) from CourseCreditUnitConfig where courseOwner.uniqueId in (select courseOffering.uniqueId from StudentClassEnrollment where student = s and lower(clazz.schedulingSubpart.instrOfferingConfig.instructionalMethod.reference) = :Xim))";
                query.addParameter("credit", "Xim", im.toLowerCase());
            }
            if (min > 0.0f) {
                if (f < 2.1474836E9f) {
                    query.addWhere("credit", creditTerm + " between :Xmin and :Xmax");
                    query.addParameter("credit", "Xmin", Float.valueOf(min));
                    query.addParameter("credit", "Xmax", Float.valueOf(f));
                } else {
                    query.addWhere("credit", creditTerm + " >= :Xmin");
                    query.addParameter("credit", "Xmin", Float.valueOf(min));
                }
            } else if (f < 2.1474836E9f) {
                query.addWhere("credit", creditTerm + " <= :Xmax");
                query.addParameter("credit", "Xmax", Float.valueOf(f));
            }
        }
        if (request.hasOption("mode") && "My Students".equals(request.getOption("mode")) && request.hasOption("role")) {
            query.addWhere("mode", "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = :Xuser and adv.role.reference = :Xrole and adv.session.uniqueId = s.session.uniqueId)");
            query.addParameter("mode", "Xuser", request.getOption("user"));
            query.addParameter("mode", "Xrole", request.getOption("role"));
        }
        if (request.hasOption("mode") && "My Advised".equals(request.getOption("mode")) && request.hasOption("role")) {
            query.addWhere("mode", "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = :Xuser and adv.role.reference = :Xrole and adv.session.uniqueId = s.session.uniqueId) and s.advisorCourseRequests is not empty");
            query.addParameter("mode", "Xuser", request.getOption("user"));
            query.addParameter("mode", "Xrole", request.getOption("role"));
        }
        if (request.hasOption("mode") && "My Not Advised".equals(request.getOption("mode")) && request.hasOption("role")) {
            query.addWhere("mode", "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = :Xuser and adv.role.reference = :Xrole and adv.session.uniqueId = s.session.uniqueId) and s.advisorCourseRequests is empty");
            query.addParameter("mode", "Xuser", request.getOption("user"));
            query.addParameter("mode", "Xrole", request.getOption("role"));
        }
        if (request.hasOption("mode") && "Advised".equals(request.getOption("mode"))) {
            query.addWhere("mode", "s.advisorCourseRequests is not empty");
        }
        if (request.hasOption("mode") && "Not Advised".equals(request.getOption("mode"))) {
            query.addWhere("mode", "s.advisorCourseRequests is empty");
        }
        if (request.hasOptions("override")) {
            boolean bl;
            Object where = "";
            int id25 = 0;
            boolean bl7 = false;
            for (String string : request.getOptions("override")) {
                if ("none".equalsIgnoreCase(string) || "null".equalsIgnoreCase(string)) {
                    bl = true;
                    continue;
                }
                CourseRequest.CourseRequestOverrideStatus status = null;
                for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                    if (!s.name().equalsIgnoreCase(string)) continue;
                    status = s;
                    break;
                }
                if (status == null) continue;
                where = (String)where + (((String)where).isEmpty() ? "" : ",") + ":Xstatus" + id25;
                query.addParameter("override", "Xstatus" + id25, status.ordinal());
                ++id25;
            }
            if (id25 > 0) {
                if (bl) {
                    query.addFrom("override", "CourseRequest xcr");
                    query.addWhere("override", "xcr.courseDemand.student = s and (xcr.overrideStatus is null or s.overrideStatus in (" + (String)where + ") or xcr.overrideStatus in (" + (String)where + "))");
                } else {
                    query.addFrom("override", "CourseRequest xcr");
                    query.addWhere("override", "xcr.courseDemand.student = s and (s.overrideStatus in (" + (String)where + ") or xcr.overrideStatus in (" + (String)where + "))");
                }
            } else if (bl) {
                query.addFrom("override", "CourseRequest xcr");
                query.addWhere("override", "xcr.courseDemand.student = s and xcr.overrideStatus is null");
            }
        }
        if (request.hasOptions("prefer")) {
            Object where = "";
            int id26 = 0;
            for (String string : request.getOptions("prefer")) {
                if ("Any Preference".equalsIgnoreCase(string) || "Met Preference".equalsIgnoreCase(string) || "Unmet Preference".equalsIgnoreCase(string)) continue;
                where = (String)where + (((String)where).isEmpty() ? "" : ",") + ":Xprf" + id26;
                query.addParameter("prefer", "Xprf" + id26, string);
                ++id26;
            }
            query.addFrom("prefer", "inner join s.courseDemands pcd inner join pcd.courseRequests pcr inner join pcr.preferences pp");
            if (id26 > 0) {
                query.addWhere("prefer", "pp.label in (" + (String)where + ")");
            }
        }
        if (request.hasOptions("require")) {
            Object where = "";
            int id27 = 0;
            for (String string : request.getOptions("require")) {
                if ("Any Requirement".equalsIgnoreCase(string) || "Met Requirement".equalsIgnoreCase(string) || "Unmet Requirement".equalsIgnoreCase(string)) continue;
                where = (String)where + (((String)where).isEmpty() ? "" : ",") + ":Xprf" + id27;
                query.addParameter("require", "Xprf" + id27, string);
                ++id27;
            }
            query.addFrom("require", "inner join s.courseDemands rcd inner join rcd.courseRequests rcr inner join rcr.preferences rp");
            if (id27 > 0) {
                query.addWhere("require", "rp.label in (" + (String)where + ") and rp.required = true");
            }
        }
        if (request.hasOption("assignment") && "Wait-Listed".equalsIgnoreCase(request.getOption("assignment"))) {
            query.addFrom("assignment", "CourseRequest wcr");
            if (InstructionalOffering.getDefaultWaitListMode().isWaitlist()) {
                query.addWhere("assignment", "wcr.courseDemand.waitlist = true and wcr.courseDemand.student = s and (wcr.courseOffering.instructionalOffering.waitlistMode is null or wcr.courseOffering.instructionalOffering.waitlistMode = 1)");
            } else {
                query.addWhere("assignment", "wcr.courseDemand.waitlist = true and wcr.courseDemand.student = s and wcr.courseOffering.instructionalOffering.waitlistMode = 1");
            }
        }
        if (request.hasOptions("im")) {
            Object ims = "";
            boolean hasDefault = false;
            boolean bl = false;
            for (String string : request.getOptions("im")) {
                void var9_128;
                if (string.equals(server.getAcademicSession().getDefaultInstructionalMethod())) {
                    hasDefault = true;
                }
                ims = (String)ims + (((String)ims).isEmpty() ? "" : ",") + ":Xim" + (int)var9_128;
                query.addParameter("im", "Xim" + (int)var9_128, string);
                ++var9_128;
            }
            if (hasDefault) {
                query.addWhere("im", "imIm is null or imIm.reference in (" + (String)ims + ")");
                query.addFrom("im", "inner join s.courseDemands imCd inner join imCd.courseRequests imCr inner join imCr.courseOffering imCo inner join imCo.instructionalOffering.instrOfferingConfigs imCfg left outer join imCfg.instructionalMethod imIm");
            } else {
                query.addWhere("im", "imCfg.instructionalMethod.reference in (" + (String)ims + ")");
                query.addFrom("im", "inner join s.courseDemands imCd inner join imCd.courseRequests imCr inner join imCr.courseOffering imCo inner join imCo.instructionalOffering.instrOfferingConfigs imCfg");
            }
        }
        return query;
    }

    public Set<Long> getStudentIds(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        return new HashSet<Long>(SectioningStatusFilterAction.getQuery(this.iRequest, server, helper).select("distinct s.uniqueId").query(helper.getHibSession()).list());
    }

    public Map<Long, List<AdvisorCourseRequest>> getAdvisorCourseRequests(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<Long, List<AdvisorCourseRequest>> ret = new HashMap<Long, List<AdvisorCourseRequest>>();
        for (Object[] o : SectioningStatusFilterAction.getQuery(this.iRequest, server, helper).select("s.uniqueId, acr").from("inner join s.advisorCourseRequests acr").order("s.uniqueId, acr.priority, acr.alternative").query(helper.getHibSession()).list()) {
            Long studentId = (Long)o[0];
            AdvisorCourseRequest acr = (AdvisorCourseRequest)o[1];
            ArrayList<AdvisorCourseRequest> acrs = (ArrayList<AdvisorCourseRequest>)ret.get(studentId);
            if (acrs == null) {
                acrs = new ArrayList<AdvisorCourseRequest>();
                ret.put(studentId, acrs);
            }
            acrs.add(acr);
        }
        return ret;
    }

    public List<XStudent> getStudens(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<XStudent> students = new ArrayList<XStudent>();
        for (Student student : SectioningStatusFilterAction.getQuery(this.iRequest, server, helper).select("distinct s").query(helper.getHibSession()).list()) {
            students.add(new XStudent(student, helper, server.getAcademicSession().getFreeTimePattern(), server.getAcademicSession().getDatePatternFirstDate()));
        }
        return students;
    }

    public static CourseQuery getCourseQuery(EventInterface.FilterRpcRequest request, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        int id;
        CourseQuery query = new CourseQuery(SectioningStatusFilterAction.getQuery(request, server, helper));
        if (request.hasOptions("lookup") && CustomCourseLookupHolder.hasProvider()) {
            query.addFrom("lookup", null);
        }
        if (request.hasOption("course")) {
            query.addParameter("course", "Xco", request.getOption("course"));
            query.addWhere("course", "co.subjectAreaAbbv = :Xco or co.subjectAreaAbbv || ' ' || co.courseNbr = :Xco");
            query.addFrom("course", null);
        } else if (request.hasOptions("course")) {
            Object course = "";
            id = 0;
            for (String c : request.getOptions("course")) {
                course = (String)course + (((String)course).isEmpty() ? "" : ",") + ":Xco" + id;
                query.addParameter("course", "Xco" + id, c);
                ++id;
            }
            query.addWhere("course", "co.subjectAreaAbbv in (" + (String)course + ") or co.subjectAreaAbbv || ' ' || co.courseNbr in (" + (String)course + ")");
            query.addFrom("course", null);
        }
        if (request.hasOptions("prefer")) {
            query.addFrom("prefer", "inner join cr.preferences pp");
        }
        if (request.hasOptions("require")) {
            query.addFrom("require", "inner join cr.preferences rp");
        }
        if (request.hasOptions("im")) {
            Object ims = "";
            boolean hasDefault = false;
            int id2 = 0;
            for (String im : request.getOptions("im")) {
                if (im.equals(server.getAcademicSession().getDefaultInstructionalMethod())) {
                    hasDefault = true;
                }
                ims = (String)ims + (((String)ims).isEmpty() ? "" : ",") + ":Xim" + id2;
                query.addParameter("im", "Xim" + id2, im);
                ++id2;
            }
            if (hasDefault) {
                query.addWhere("im", "im is null or im.reference in (" + (String)ims + ")");
                query.addFrom("im", "inner join co.instructionalOffering.instrOfferingConfigs cfg left outer join cfg.instructionalMethod im");
            } else {
                query.addWhere("im", "cfg.instructionalMethod.reference in (" + (String)ims + ")");
                query.addFrom("im", "inner join co.instructionalOffering.instrOfferingConfigs cfg");
            }
        }
        if (request.hasOption("assignment") && "Wait-Listed".equalsIgnoreCase(request.getOption("assignment"))) {
            query.addFrom("assignment", null);
            if (InstructionalOffering.getDefaultWaitListMode().isWaitlist()) {
                query.addWhere("assignment", "(co.instructionalOffering.waitlistMode is null or co.instructionalOffering.waitlistMode = 1) and cd.waitlist = true");
            } else {
                query.addWhere("assignment", "co.instructionalOffering.waitlistMode = 1 and cd.waitlist = true");
            }
        }
        if (request.hasOptions("override")) {
            Object where = "";
            id = 0;
            boolean none = false;
            for (String o : request.getOptions("override")) {
                if ("none".equalsIgnoreCase(o) || "null".equalsIgnoreCase(o)) {
                    none = true;
                    continue;
                }
                CourseRequest.CourseRequestOverrideStatus status = null;
                for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                    if (!s.name().equalsIgnoreCase(o)) continue;
                    status = s;
                    break;
                }
                if (status == null) continue;
                where = (String)where + (((String)where).isEmpty() ? "" : ",") + ":Xstatus" + id;
                query.addParameter("override", "Xstatus" + id, status.ordinal());
                ++id;
            }
            if (id > 0) {
                if (none) {
                    query.addFrom("override", null);
                    query.addWhere("override", "cr.overrideStatus is null or cr.overrideStatus in (" + (String)where + ")");
                } else {
                    query.addFrom("override", null);
                    query.addWhere("override", "cr.overrideStatus in (" + (String)where + ")");
                }
            } else if (none) {
                query.addFrom("override", null);
                query.addWhere("override", "cr.overrideStatus is null");
            }
        }
        return query;
    }

    public List<XCourseId> getCourseIds(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<XCourseId> ids = new ArrayList<XCourseId>();
        for (Object[] line : SectioningStatusFilterAction.getCourseQuery(this.iRequest, server, helper).select("distinct co.instructionalOffering.uniqueId, co.uniqueId, co.subjectAreaAbbv, co.courseNbr").query(helper.getHibSession()).list()) {
            ids.add(new XCourseId(((Number)line[0]).longValue(), ((Number)line[1]).longValue(), (String)line[2], (String)line[3]));
        }
        return ids;
    }

    public List<XCourse> getCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<XCourse> courses = new ArrayList<XCourse>();
        for (CourseOffering co : SectioningStatusFilterAction.getCourseQuery(this.iRequest, server, helper).select("distinct co").query(helper.getHibSession()).list()) {
            courses.add(new XCourse(co));
        }
        return courses;
    }

    public static boolean hasNoMatchCourses(EventInterface.FilterRpcRequest request, OnlineSectioningHelper helper) {
        if (request.hasOptions("prefer") || request.hasOptions("require")) {
            return false;
        }
        if (request.hasOptions("area") || request.hasOptions("classification") || request.hasOptions("degree") || request.hasOptions("program") || request.hasOptions("campus") || request.hasOptions("major") || request.hasOptions("concentration") || request.hasOptions("minor")) {
            return false;
        }
        if (request.hasOptions("group") || request.hasOptions("accommodation")) {
            return false;
        }
        boolean matchType = false;
        for (StudentGroupType type : StudentGroupTypeDAO.getInstance().findAll(helper.getHibSession())) {
            if (!request.hasOptions(type.getReference().replace(' ', '_'))) continue;
            matchType = true;
            break;
        }
        if (matchType) {
            return false;
        }
        if (request.hasOptions("student") || request.hasOption("advisor") || request.hasOption("credit")) {
            return false;
        }
        if (request.hasOption("mode") || request.hasOptions("override") || request.hasOptions("prefer") || request.hasOptions("require")) {
            return false;
        }
        if (request.hasOption("assignment") && !"Wait-Listed".equalsIgnoreCase(request.getOption("assignment"))) {
            return false;
        }
        if (request.hasText()) {
            return false;
        }
        if (request.hasOptions("consent")) {
            return false;
        }
        return !request.hasOptions("approver") && !request.hasOptions("accommodation") && !request.hasOptions("operation") && !request.hasOptions("overlap");
    }

    public static class StudentQuery {
        protected Long iSessionId;
        protected Map<String, String> iFrom = new HashMap<String, String>();
        protected Map<String, String> iWhere = new HashMap<String, String>();
        protected Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public StudentQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public StudentQuery(StudentQuery q) {
            this.iSessionId = q.iSessionId;
            this.iFrom.putAll(q.iFrom);
            this.iWhere.putAll(q.iWhere);
            this.iParams.putAll(q.iParams);
        }

        public void addFrom(String option, String from) {
            if (from == null) {
                this.iFrom.remove(option);
            } else {
                this.iFrom.put(option, from);
            }
        }

        public void addWhere(String option, String where) {
            if (where == null) {
                this.iWhere.remove(option);
            } else {
                this.iWhere.put(option, where);
            }
        }

        public void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            if (value == null) {
                params.remove(name);
            } else {
                params.put(name, value);
            }
        }

        public String getFrom(Collection<String> excludeOption) {
            Object from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = (String)from + (entry.getValue().startsWith("inner join") ? " " : ", ") + entry.getValue();
            }
            return from;
        }

        public String getWhere(Collection<String> excludeOption) {
            Object where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = (String)where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public Query setParams(Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setParameter(param.getKey(), (Object)((Integer)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setParameter(param.getKey(), (Object)((Long)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Float) {
                        query.setParameter(param.getKey(), (Object)((Float)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Double) {
                        query.setParameter(param.getKey(), (Object)((Double)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Number) {
                        query.setParameter(param.getKey(), (Object)((Number)param.getValue()).doubleValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setParameter(param.getKey(), (Object)((String)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setParameter(param.getKey(), (Object)((Boolean)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setParameter(param.getKey(), (Object)((Date)param.getValue()));
                        continue;
                    }
                    query.setParameter(param.getKey(), (Object)param.getValue().toString());
                }
            }
            return query;
        }

        public QueryInstance select(String select) {
            return new QueryInstance(select);
        }

        public class QueryInstance {
            protected String iSelect = null;
            protected String iFrom = null;
            protected String iWhere = null;
            protected String iOrderBy = null;
            protected String iGroupBy = null;
            protected String iType = "Student";
            protected Integer iLimit = null;
            protected Set<String> iExclude = new HashSet<String>();
            protected Map<String, Object> iParams = new HashMap<String, Object>();

            private QueryInstance(String select) {
                this.iSelect = select;
            }

            public QueryInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public QueryInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public QueryInstance type(String type) {
                this.iType = type;
                return this;
            }

            public QueryInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public QueryInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public QueryInstance exclude(String excludeOption) {
                this.iExclude.add(excludeOption);
                return this;
            }

            public QueryInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public QueryInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct s" : this.iSelect) + " from " + this.iType + " s left outer join s.areaClasfMajors aac " + (String)(this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + StudentQuery.this.getFrom(this.iExclude) + " where s.session.uniqueId = :sessionId" + StudentQuery.this.getWhere(this.iExclude) + (String)(this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (String)(this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (String)(this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public Query query(org.hibernate.Session hibSession) {
                Query query = StudentQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude);
                query.setParameter("sessionId", (Object)StudentQuery.this.iSessionId);
                query.setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setParameter(param.getKey(), (Object)((Integer)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setParameter(param.getKey(), (Object)((Long)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Float) {
                        query.setParameter(param.getKey(), (Object)((Float)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Double) {
                        query.setParameter(param.getKey(), (Object)((Double)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Number) {
                        query.setParameter(param.getKey(), (Object)((Number)param.getValue()).doubleValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setParameter(param.getKey(), (Object)((String)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setParameter(param.getKey(), (Object)((Boolean)param.getValue()));
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setParameter(param.getKey(), (Object)((Date)param.getValue()));
                        continue;
                    }
                    query.setParameter(param.getKey(), (Object)param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }

    public static class CourseQuery
    extends StudentQuery {
        public CourseQuery(Long sessionId) {
            super(sessionId);
        }

        public CourseQuery(StudentQuery q) {
            super(q);
        }

        @Override
        public StudentQuery.QueryInstance select(String select) {
            return new StudentQuery.QueryInstance(select){

                @Override
                public String query() {
                    return "select " + (this.iSelect == null ? "distinct co" : this.iSelect) + " from CourseRequest cr inner join cr.courseOffering co inner join cr.courseDemand cd inner join cd.student s left outer join s.areaClasfMajors aac " + (String)(this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + this.getFrom(this.iExclude) + " where s.session.uniqueId = :sessionId" + this.getWhere(this.iExclude) + (String)(this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (String)(this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (String)(this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
                }
            };
        }

        public StudentQuery.QueryInstance selectCourses(String select, EventInterface.FilterRpcRequest request) {
            if (request.hasOption("assignment") && "Wait-Listed".equalsIgnoreCase(request.getOption("assignment"))) {
                if (InstructionalOffering.getDefaultWaitListMode().isWaitlist()) {
                    this.addWhere("assignment", "(co.instructionalOffering.waitlistMode is null or co.instructionalOffering.waitlistMode = 1)");
                } else {
                    this.addWhere("assignment", "co.instructionalOffering.waitlistMode = 1");
                }
            }
            return new StudentQuery.QueryInstance(select){

                @Override
                public String query() {
                    return "select " + (this.iSelect == null ? "distinct co" : this.iSelect) + " from CourseOffering co " + (String)(this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + this.getFrom(this.iExclude) + " where co.instructionalOffering.session.uniqueId = :sessionId and co.instructionalOffering.notOffered = false" + this.getWhere(this.iExclude) + (String)(this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (String)(this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (String)(this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
                }
            };
        }
    }

    public static enum Credit {
        eq,
        lt,
        gt,
        le,
        ge;

    }
}

