/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationUpdate
implements OnlineSectioningAction<SpecialRegistrationInterface.UpdateSpecialRegistrationResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.UpdateSpecialRegistrationRequest iRequest;

    public SpecialRegistrationUpdate withRequest(SpecialRegistrationInterface.UpdateSpecialRegistrationRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.UpdateSpecialRegistrationRequest getRequest() {
        return this.iRequest;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.UpdateSpecialRegistrationResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            SpecialRegistrationInterface.UpdateSpecialRegistrationResponse response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (this.getRequest().getStudentId() != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            }
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            SpecialRegistrationInterface.UpdateSpecialRegistrationResponse updateSpecialRegistrationResponse = response = CustomSpecialRegistrationHolder.getProvider().updateRegistration(server, helper, student, this.getRequest());
            return updateSpecialRegistrationResponse;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "specreg-update";
    }
}

