/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.Comparator;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;

public class SectioningRequestComparator
implements Comparator<SectioningRequest> {
    protected int compareBothAssignedOrNotAssigned(SectioningRequest s, SectioningRequest r) {
        if (s.getRequestPriority() != r.getRequestPriority()) {
            return s.getRequestPriority().ordinal() < r.getRequestPriority().ordinal() ? -1 : 1;
        }
        if (s.getStudentPriority() != r.getStudentPriority()) {
            return s.getStudentPriority().ordinal() < r.getStudentPriority().ordinal() ? -1 : 1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int compareBothNotAssigned(SectioningRequest s, SectioningRequest r) {
        if (s.getAlternativity() != r.getAlternativity()) {
            if (s.getAlternativity() >= r.getAlternativity()) return 1;
            return -1;
        }
        if (s.getRequest().getWaitListedTimeStamp() != null) {
            if (r.getRequest().getWaitListedTimeStamp() == null) return 1;
            int cmp = s.getRequest().getWaitListedTimeStamp().compareTo(r.getRequest().getWaitListedTimeStamp());
            if (cmp == 0) return 0;
            return cmp;
        }
        if (r.getRequest().getWaitListedTimeStamp() == null) return 0;
        return -1;
    }

    protected int compareBothAssigned(SectioningRequest s, SectioningRequest r) {
        if (s.hasIndividualReservation() && !r.hasIndividualReservation()) {
            return -1;
        }
        if (!s.hasIndividualReservation() && r.hasIndividualReservation()) {
            return 1;
        }
        if (s.getRequest().isAlternative() && !r.getRequest().isAlternative()) {
            return 1;
        }
        if (!s.getRequest().isAlternative() && r.getRequest().isAlternative()) {
            return -1;
        }
        int cmp = Integer.compare(s.getRequest().getPriority(), r.getRequest().getPriority());
        if (cmp != 0) {
            return cmp;
        }
        if (s.getAlternativity() != r.getAlternativity()) {
            return s.getAlternativity() < r.getAlternativity() ? -1 : 1;
        }
        if (s.getLastEnrollment().getTimeStamp() != null) {
            if (r.getLastEnrollment().getTimeStamp() != null) {
                return s.getLastEnrollment().getTimeStamp().compareTo(r.getLastEnrollment().getTimeStamp());
            }
            return 1;
        }
        if (r.getLastEnrollment().getTimeStamp() != null) {
            return -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int compareFallBack(SectioningRequest s, SectioningRequest r) {
        if (s.getRequest().getTimeStamp() != null) {
            if (r.getRequest().getTimeStamp() == null) return 1;
            int cmp = s.getRequest().getTimeStamp().compareTo(r.getRequest().getTimeStamp());
            if (cmp == 0) return Long.compare(s.getRequest().getRequestId(), r.getRequest().getRequestId());
            return cmp;
        }
        if (r.getRequest().getTimeStamp() == null) return Long.compare(s.getRequest().getRequestId(), r.getRequest().getRequestId());
        return -1;
    }

    @Override
    public int compare(SectioningRequest s, SectioningRequest r) {
        if (!s.hasLastEnrollment() && r.hasLastEnrollment()) {
            return 1;
        }
        if (s.hasLastEnrollment() && !r.hasLastEnrollment()) {
            return -1;
        }
        int cmp = this.compareBothAssignedOrNotAssigned(s, r);
        if (cmp != 0) {
            return cmp;
        }
        cmp = !s.hasLastEnrollment() ? this.compareBothNotAssigned(s, r) : this.compareBothAssigned(s, r);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareFallBack(s, r);
    }
}

