/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.reports;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.reports.OnlineSectioningReport;

public class FindAssignmentsReport
implements OnlineSectioningReport.Report {
    @Override
    public String getYear() {
        return System.getProperty("year", "2012");
    }

    @Override
    public String getTerm() {
        return System.getProperty("term", "Fall");
    }

    @Override
    public String getCampus() {
        return System.getProperty("campus", "PWL");
    }

    @Override
    public File getReportFolder() {
        return new File(System.getProperty("user.home", "~"));
    }

    @Override
    public String[] getOperations() {
        return new String[]{"section"};
    }

    @Override
    public String[] getExcludeUsers() {
        return System.getProperty("exclude", "TEST").split(",");
    }

    @Override
    public String getLastTimeStamp() {
        return System.getProperty("before", null);
    }

    @Override
    public void process(OnlineSectioningReport report, String student, List<OnlineSectioningLog.Action> actions) {
        TreeSet<String> courses = new TreeSet<String>();
        int idx = 0;
        OnlineSectioningReport.Counter cpu = new OnlineSectioningReport.Counter();
        OnlineSectioningReport.Counter err = new OnlineSectioningReport.Counter();
        OnlineSectioningReport.Counter req = new OnlineSectioningReport.Counter();
        OnlineSectioningReport.Counter rft = new OnlineSectioningReport.Counter();
        OnlineSectioningReport.Counter asgn = new OnlineSectioningReport.Counter();
        OnlineSectioningReport.Counter asft = new OnlineSectioningReport.Counter();
        OnlineSectioningReport.Counter val = new OnlineSectioningReport.Counter();
        boolean useft = false;
        boolean usealt = false;
        for (OnlineSectioningLog.Action action : actions) {
            cpu.inc((double)action.getCpuTime() / 1000000.0);
            report.inc("CPU Time", (double)action.getCpuTime() / 1.0E9);
            for (OnlineSectioningLog.Message message : action.getMessageList()) {
                if (message.getLevel() != OnlineSectioningLog.Message.Level.ERROR && message.getLevel() != OnlineSectioningLog.Message.Level.FATAL) continue;
                report.inc("Error " + message.getText(), 1.0);
                err.inc(1.0);
            }
            OnlineSectioningLog.Enrollment computed = null;
            for (OnlineSectioningLog.Enrollment enrollment : action.getEnrollmentList()) {
                if (enrollment.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED) continue;
                computed = enrollment;
                break;
            }
            HashSet<String> hashSet = new HashSet<String>();
            int ac = 0;
            int aft = 0;
            if (computed != null) {
                if (computed.hasValue()) {
                    report.inc("Value", computed.getValue());
                    val.inc(computed.getValue());
                }
                for (OnlineSectioningLog.Section section : computed.getSectionList()) {
                    if (section.hasCourse() && section.getCourse().hasName()) {
                        if (!hashSet.add(section.getCourse().getName())) continue;
                        report.inc("Courses", section.getCourse().getName(), "Assigned", 1.0);
                        ++ac;
                        int priority = 0;
                        boolean alt = false;
                        block4: for (OnlineSectioningLog.Request request : action.getRequestList()) {
                            for (OnlineSectioningLog.Entity course : request.getCourseList()) {
                                if (course.getUniqueId() != section.getCourse().getUniqueId()) continue;
                                priority = request.getPriority();
                                alt = request.getAlternative();
                                break block4;
                            }
                        }
                        report.inc("Courses", section.getCourse().getName(), "Priority", priority);
                        report.inc("Courses", section.getCourse().getName(), "Alternative", alt ? 1.0 : 0.0);
                        continue;
                    }
                    ++aft;
                }
                asgn.inc(ac);
                asft.inc(aft);
            }
            int rc = 0;
            int ft = 0;
            for (OnlineSectioningLog.Request request : action.getRequestList()) {
                if (!request.getAlternative() && request.getCourseCount() > 0) {
                    ++rc;
                }
                if (request.getAlternative() || request.getCourseCount() > 1) {
                    usealt = true;
                }
                for (OnlineSectioningLog.Entity course : request.getCourseList()) {
                    if (!course.hasName()) continue;
                    courses.add(course.getName());
                    report.inc("Courses", course.getName(), "Requested", 1.0);
                    if (idx == 0) {
                        report.inc("Courses", course.getName(), "First", 1.0);
                    }
                    if (idx != actions.size() - 1) continue;
                    report.inc("Courses", course.getName(), "Last", 1.0);
                }
                if (request.getFreeTimeCount() <= 0) continue;
                ++ft;
            }
            req.inc(rc);
            rft.inc(ft);
            ++idx;
            report.inc("[1] Courses", rc);
            report.inc("[1] Assigned Courses", ac);
            report.inc("[1] Free Times", ft);
            report.inc("[1] Assigned Free Times", aft);
            report.inc("[1] Complete Schedule", rc == ac ? 1 : 0);
            report.inc("[1] Complete Schedule Including Free Times", rc == ac && ft == aft ? 1 : 0);
            report.inc("[1] Has Free Times", ft > 0 ? 1 : 0);
            if (ft <= 0) continue;
            useft = true;
        }
        for (String course : courses) {
            report.inc("Courses", course, "Student", 1.0);
        }
        report.inc("Students", student, "Avg. CPU", cpu.avg());
        report.inc("Students", student, "Calls", cpu.count());
        report.inc("Students", student, "Errors", err.count());
        report.inc("Students", student, "Requests [Course]", req.avg());
        report.inc("Students", student, "Requests [Free Time]", rft.avg());
        report.inc("Students", student, "Assigned [Course]", asgn.avg());
        report.inc("Students", student, "Assigned [Free Time]", asft.avg());
        report.inc("Students", student, "Value", val.avg());
        report.inc("Courses", req.avg());
        report.inc("Free Times", rft.avg());
        report.inc("Assigned Course", asgn.avg());
        report.inc("Assigned Free Time", asft.avg());
        report.inc("Students Using Free Times", useft ? 1 : 0);
        report.inc("Students Using Alternatives", usealt ? 1 : 0);
        long done = Math.round(report.inc("Students", 1.0));
        if (done % 100L == 0L) {
            OnlineSectioningReport.sLog.info((Object)("---- after " + done + " students"));
            for (String string : new TreeSet<String>(report.iCounters.keySet())) {
                OnlineSectioningReport.sLog.info((Object)(string + ": " + report.iCounters.get(string)));
            }
        }
    }

    public static void main(String[] args) {
        try {
            new OnlineSectioningReport(new FindAssignmentsReport()).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

