/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

public class XSchedulingRules
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private List<XSchedulingRule> iRules = new ArrayList<XSchedulingRule>();

    public XSchedulingRules(AcademicSessionInfo session, Session hibSession) {
        for (StudentSchedulingRule rule : hibSession.createQuery("from StudentSchedulingRule order by ord", StudentSchedulingRule.class).setCacheable(true).list()) {
            if (!rule.matchSession(session)) continue;
            this.iRules.add(new XSchedulingRule(rule));
        }
    }

    public List<XSchedulingRule> getRules() {
        return this.iRules;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.iRules.size());
        for (XSchedulingRule rule : this.iRules) {
            rule.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iRules.clear();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            this.iRules.add(new XSchedulingRule(in));
        }
    }

    public XSchedulingRule getRule(Query.TermMatcher studentMatcher, boolean isAdvisor, boolean isAdmin, StudentSchedulingRule.Mode mode) {
        for (XSchedulingRule rule : this.iRules) {
            if (rule.isAdvisorOverride().booleanValue() && isAdvisor || rule.isAdminOverride().booleanValue() && isAdmin || mode == StudentSchedulingRule.Mode.Filter && !rule.isAppliesToFilter().booleanValue() || mode == StudentSchedulingRule.Mode.Online && !rule.isAppliesToOnline().booleanValue() || mode == StudentSchedulingRule.Mode.Batch && !rule.isAppliesToBatch().booleanValue() || rule.getStudentFilter() != null && !rule.getStudentFilter().isEmpty() && !rule.getStudentQuery().match(studentMatcher)) continue;
            return rule;
        }
        return null;
    }

    public XSchedulingRule getRule(XStudent student, StudentSchedulingRule.Mode mode, OnlineSectioningServer server, boolean isAdvisor, boolean isAdmin) {
        return this.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false), isAdvisor, isAdmin, mode);
    }
}

