/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.LearningCommunityReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.unitime.timetable.onlinesectioning.model.XReservationType;

public class XReservationId
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    protected XReservationType iType;
    private Long iOfferingId;
    private Long iReservationId;

    public XReservationId() {
    }

    public XReservationId(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XReservationId(XReservationType type, Long offeringId, Long reservationId) {
        this.iType = type;
        this.iOfferingId = offeringId;
        this.iReservationId = reservationId;
    }

    public XReservationId(XReservationId reservation) {
        this.iType = reservation.getType();
        this.iOfferingId = reservation.getOfferingId();
        this.iReservationId = reservation.getReservationId();
    }

    public XReservationId(Reservation reservation) {
        this.iOfferingId = reservation.getOffering().getId();
        this.iReservationId = reservation.getId();
        this.iType = reservation instanceof OnlineReservation ? XReservationType.values()[((OnlineReservation)reservation).getType()] : (reservation instanceof ReservationOverride ? XReservationType.IndividualOverride : (reservation instanceof LearningCommunityReservation ? XReservationType.LearningCommunity : (reservation instanceof GroupReservation ? XReservationType.Group : (reservation instanceof IndividualReservation ? XReservationType.Individual : (reservation instanceof CurriculumReservation ? XReservationType.Curriculum : (reservation instanceof CourseReservation ? XReservationType.Course : (reservation instanceof UniversalOverride ? XReservationType.Universal : XReservationType.Dummy)))))));
    }

    public XReservationType getType() {
        return this.iType;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Long getReservationId() {
        return this.iReservationId;
    }

    public boolean isOverride() {
        return false;
    }

    public boolean canBreakLinkedSections() {
        return false;
    }

    public int hashCode() {
        return (int)(this.getReservationId() ^ this.getReservationId() >>> 32);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XReservationId)) {
            return false;
        }
        return this.getReservationId() == ((XReservationId)o).getReservationId() && this.getOfferingId().equals(((XReservationId)o).getOfferingId());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iType = XReservationType.values()[in.readInt()];
        this.iOfferingId = in.readLong();
        this.iReservationId = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.iType.ordinal());
        out.writeLong(this.iOfferingId);
        out.writeLong(this.iReservationId);
    }
}

