/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class XGroupReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private int iLimit;
    private XStudent.XGroup iGroup;
    private Boolean iExpired;
    private boolean iOverride = false;

    public XGroupReservation() {
    }

    public XGroupReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XGroupReservation(XOffering offering, StudentGroupReservation reservation) {
        super(XReservationType.Group, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        this.iGroup = new XStudent.XGroup(reservation.getGroup());
        this.iOverride = false;
        if (reservation.getGroup().getType() != null && reservation.getGroup().getType().getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
            this.setAllowDisabled(true);
        }
    }

    public XGroupReservation(XOffering offering, GroupOverrideReservation reservation) {
        super(XReservationType.GroupOverride, offering, reservation);
        this.iLimit = reservation.getLimit() == null ? -1 : reservation.getLimit();
        this.iGroup = new XStudent.XGroup(reservation.getGroup());
        this.iOverride = reservation.isAlwaysExpired();
        if (reservation.getGroup().getType() != null && reservation.getGroup().getType().getAllowDisabledSection() == StudentGroupType.AllowDisabledSection.WithGroupReservation) {
            this.setAllowDisabled(true);
        }
        this.setMustBeUsed(reservation.isMustBeUsed());
        this.setAllowOverlap(reservation.isAllowOverlap());
        this.setCanAssignOverLimit(reservation.isCanAssignOverLimit());
        if (reservation.isAlwaysExpired()) {
            this.iExpired = true;
        } else {
            this.iType = XReservationType.Group;
        }
    }

    public XStudent.XGroup getGroup() {
        return this.iGroup;
    }

    @Override
    public boolean isOverride() {
        return this.iOverride;
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit;
    }

    @Override
    public boolean isExpired() {
        return this.getType() == XReservationType.GroupOverride && this.iExpired != null ? this.iExpired.booleanValue() : super.isExpired();
    }

    @Override
    public boolean isAlwaysExpired() {
        return this.getType() == XReservationType.GroupOverride && this.iExpired != null && this.iExpired != false;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        return student.getGroups().contains(this.iGroup);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iGroup = new XStudent.XGroup(in);
        this.iLimit = in.readInt();
        if (this.getType() == XReservationType.GroupOverride) {
            switch (in.readByte()) {
                case 0: {
                    this.iExpired = false;
                    break;
                }
                case 1: {
                    this.iExpired = true;
                    break;
                }
                default: {
                    this.iExpired = null;
                }
            }
            this.iOverride = in.readBoolean();
        } else {
            this.iExpired = null;
            this.iOverride = false;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.iGroup.writeExternal(out);
        out.writeInt(this.iLimit);
        if (this.getType() == XReservationType.GroupOverride) {
            out.writeByte(this.iExpired == null ? 2 : (this.iExpired != false ? 1 : 0));
            out.writeBoolean(this.iOverride);
        }
    }
}

