/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class XDistribution
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iDistributionId = null;
    private int iVariant = 0;
    private XDistributionType iType = null;
    private Set<Long> iOfferingIds = new HashSet<Long>();
    private Set<Long> iSectionIds = new HashSet<Long>();

    public XDistribution() {
    }

    public XDistribution(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XDistribution(XDistributionType type, Long id, int variant, Collection<Class_> sections) {
        this.iType = type;
        this.iDistributionId = id;
        this.iVariant = variant;
        for (Class_ clazz : sections) {
            this.iOfferingIds.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
            this.iSectionIds.add(clazz.getUniqueId());
        }
    }

    public XDistribution(XDistributionType type, Long id, Long offeringId, Collection<Long> sectionIds) {
        this.iType = type;
        this.iDistributionId = id;
        this.iVariant = 0;
        this.iOfferingIds.add(offeringId);
        this.iSectionIds.addAll(sectionIds);
    }

    public XDistribution(LinkedSections link, long id) {
        this.iType = XDistributionType.LinkedSections;
        this.iDistributionId = -id;
        this.iVariant = 0;
        for (Offering offering : link.getOfferings()) {
            this.iOfferingIds.add(offering.getId());
            for (Subpart subpart : link.getSubparts(offering)) {
                for (Section section : link.getSections(subpart)) {
                    this.iSectionIds.add(section.getId());
                }
            }
        }
    }

    public XDistributionType getDistributionType() {
        return this.iType;
    }

    public Long getDistributionId() {
        return this.iDistributionId;
    }

    public int getVariant() {
        return this.iVariant;
    }

    public Set<Long> getOfferingIds() {
        return this.iOfferingIds;
    }

    public Set<Long> getSectionIds() {
        return this.iSectionIds;
    }

    public boolean hasSection(Long sectionId) {
        return this.iSectionIds.contains(sectionId);
    }

    public boolean isViolated(XStudent student, OnlineSectioningServer server) {
        if (student == null) {
            return false;
        }
        int nrMatch = 0;
        int nrMismatch = 0;
        for (Long offeringId : this.getOfferingIds()) {
            XOffering offering = server.getOffering(offeringId);
            for (XRequest req : student.getRequests()) {
                XSection section;
                XCourseRequest cr;
                XEnrollment enrl;
                if (!(req instanceof XCourseRequest) || (enrl = (cr = (XCourseRequest)req).getEnrollment()) == null || !enrl.getOfferingId().equals(offeringId)) continue;
                boolean match = true;
                HashSet<Long> matchingSubparts = new HashSet<Long>();
                for (Long sectionId : this.getSectionIds()) {
                    section = offering.getSection(sectionId);
                    if (section == null || !enrl.getSectionIds().contains(sectionId)) continue;
                    matchingSubparts.add(section.getSubpartId());
                }
                for (Long sectionId : this.getSectionIds()) {
                    section = offering.getSection(sectionId);
                    if (section == null || enrl.getSectionIds().contains(sectionId) || matchingSubparts.contains(section.getSubpartId())) continue;
                    match = false;
                    break;
                }
                if (match) {
                    ++nrMatch;
                    continue;
                }
                ++nrMismatch;
            }
        }
        return nrMatch > 0 && nrMismatch > 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XDistribution)) {
            return false;
        }
        return this.getDistributionId().equals(((XDistribution)o).getDistributionId());
    }

    public int hashCode() {
        return (int)(this.getDistributionId() ^ this.getDistributionId() >>> 32 ^ (long)this.getVariant());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iDistributionId = in.readLong();
        this.iVariant = in.readInt();
        this.iType = XDistributionType.values()[in.readInt()];
        int nrOfferings = in.readInt();
        this.iOfferingIds.clear();
        for (int i = 0; i < nrOfferings; ++i) {
            this.iOfferingIds.add(in.readLong());
        }
        int nrSections = in.readInt();
        this.iSectionIds.clear();
        for (int i = 0; i < nrSections; ++i) {
            this.iSectionIds.add(in.readLong());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iDistributionId);
        out.writeInt(this.iVariant);
        out.writeInt(this.iType.ordinal());
        out.writeInt(this.iOfferingIds.size());
        for (Long offeringId : this.iOfferingIds) {
            out.writeLong(offeringId);
        }
        out.writeInt(this.iSectionIds.size());
        for (Long sectionId : this.iSectionIds) {
            out.writeLong(sectionId);
        }
    }
}

