/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.match;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseMatcherProvider;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.security.SessionContext;

public class SkipDisabledCourseMatcher
extends AbstractCourseMatcher
implements CourseMatcherProvider {
    private static final long serialVersionUID = 3185616799094748160L;
    protected boolean iShowDisabledWhenNotLoaded = "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.ShowDisabledWhenNotLoaded", "true"));

    protected boolean isEnabledForStudentScheduling(XConfig config) {
        if (config.getSubparts().isEmpty()) {
            return false;
        }
        for (XSubpart subpart : config.getSubparts()) {
            if (this.isEnabledForStudentScheduling(subpart)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledForStudentScheduling(XSubpart subpart) {
        for (XSection section : subpart.getSections()) {
            if (!section.isEnabledForScheduling()) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnabledForStudentScheduling(XOffering offering) {
        for (XConfig config : offering.getConfigs()) {
            if (!this.isEnabledForStudentScheduling(config)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnabledForStudentScheduling(InstrOfferingConfig config) {
        if (config.getSchedulingSubparts().isEmpty()) {
            return false;
        }
        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
            if (this.isEnabledForStudentScheduling(subpart)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledForStudentScheduling(SchedulingSubpart subpart) {
        for (Class_ section : subpart.getClasses()) {
            if (!Boolean.TRUE.equals(section.isEnabledForStudentScheduling())) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnabledForStudentScheduling(InstructionalOffering offering) {
        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
            if (!this.isEnabledForStudentScheduling(config)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnabledForStudentScheduling(XCourseId course) {
        if (this.getServer() == null || this.getServer() instanceof DatabaseServer) {
            if (this.iShowDisabledWhenNotLoaded) {
                return true;
            }
            return this.isEnabledForStudentScheduling((InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId()));
        }
        return this.isEnabledForStudentScheduling(this.getServer().getOffering(course.getOfferingId()));
    }

    @Override
    public boolean match(XCourseId course) {
        return this.isEnabledForStudentScheduling(course);
    }

    @Override
    public CourseMatcher getCourseMatcher(OnlineSectioningServer server, SessionContext context, Long studentId) {
        return new SkipDisabledCourseMatcher();
    }
}

