/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookup;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;

public class UCCCoursesLookup
implements CustomCourseLookup {
    private static Log sLog = LogFactory.getLog(UCCCoursesLookup.class);
    private ExternalTermProvider iExternalTermProvider;
    private Map<Long, CourseAttributeCache> iCache = new HashMap<Long, CourseAttributeCache>();

    public UCCCoursesLookup() {
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getCourseLookupFullSQL() {
        return ApplicationProperties.getProperty("banner.ucc.lookupSQLfull", "select distinct co.uniqueid from timetable.szv_utm_attr a, timetable.course_offering co, timetable.instructional_offering io, timetable.subject_area sa where a.term_start <= :term and a.term_end >= :term and (lower(a.attribute_description) = concat('uc-', :query) or lower(a.course_attribute) = :query) and co.instr_offr_id = io.uniqueid and co.subject_area_id = sa.uniqueid and io.session_id = :sessionId and io.not_offered = 0 and (sa.subject_area_abbreviation = a.subject or sa.subject_area_abbreviation like concat('% - ', a.subject)) and co.course_nbr like concat(a.course_number, '%')");
    }

    protected String getCourseLookupPartialSQL() {
        return ApplicationProperties.getProperty("banner.ucc.lookupSQLpartial", "select distinct co.uniqueid from timetable.szv_utm_attr a, timetable.course_offering co, timetable.instructional_offering io, timetable.subject_area sa where a.term_start <= :term and a.term_end >= :term and (lower(a.attribute_description) like concat(concat('uc-', :query), '%') or lower(a.attribute_description) like concat(concat('% ', :query), '%')) and co.instr_offr_id = io.uniqueid and co.subject_area_id = sa.uniqueid and io.session_id = :sessionId and io.not_offered = 0 and (sa.subject_area_abbreviation = a.subject or sa.subject_area_abbreviation like concat('% - ', a.subject)) and co.course_nbr like concat(a.course_number, '%')");
    }

    protected String getSuggestionSQL() {
        return ApplicationProperties.getProperty("banner.ucc.suggestionsSQL", "select distinct a.course_attribute, a.attribute_description from timetable.szv_utm_attr a where a.term_start <= :term and a.term_end >= :term and (lower(a.attribute_description) like concat(concat('uc-', :query), '%') or lower(a.attribute_description) like concat(concat('% ', :query), '%') or lower(a.course_attribute) = :query)");
    }

    protected String getPlaceHolderRegExp() {
        return ApplicationProperties.getProperty("banner.ucc.placeholder.regExp", "( ?UCC:? ?)?([^-]*[^- ]+)( ?-.*)?");
    }

    protected String getPlaceHolderRenames() {
        return ApplicationProperties.getProperty("banner.ucc.placeholder.replacements", "(?i:Behavioral/Social Science)|Behavior/Social Science\n(?i:Science,? Tech \\& Society( Selective)?)|Science, Tech & Society\n(?i:Oral Communication)|Oral Communications\n(?i:Written Communications)|Written Communication\n(?i:Oral/Written Communications)|Communication");
    }

    protected String getListAttributesSQL() {
        return ApplicationProperties.getProperty("banner.ucc.cachedSQL", "select distinct a.course_attribute, a.attribute_description, co.uniqueId from timetable.szv_utm_attr a, timetable.course_offering co, timetable.instructional_offering io, timetable.subject_area sa where a.term_start <= :term and a.term_end >= :term and co.instr_offr_id = io.uniqueid and co.subject_area_id = sa.uniqueid and io.session_id = :sessionId and io.not_offered = 0 and sa.subject_area_abbreviation = a.subject and co.course_nbr like concat(a.course_number, '%')");
    }

    protected boolean useCache() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.ucc.useCache", "false"));
    }

    protected long getCourseAttributesTTL() {
        return 1000L * Long.valueOf(ApplicationProperties.getProperty("banner.ucc.ttlSeconds", "900"));
    }

    protected synchronized Collection<CourseAttribute> getCourseAttributes(AcademicSessionInfo session, Session hibSession) {
        CourseAttributeCache cache = this.iCache.get(session.getUniqueId());
        if (cache == null || !cache.isActive(this.getCourseAttributesTTL())) {
            HashMap<String, CourseAttribute> attributes = new HashMap<String, CourseAttribute>();
            String term = this.getBannerTerm(session);
            for (Object[] data : (hibSession == null ? new _RootDAO().getSession() : hibSession).createNativeQuery(this.getListAttributesSQL(), Object[].class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("term", (Object)term).list()) {
                String course_attribute = (String)data[0];
                String attribute_description = (String)data[1];
                Long courseId = ((Number)data[2]).longValue();
                CourseAttribute att = (CourseAttribute)attributes.get(course_attribute);
                if (att == null) {
                    att = new CourseAttribute(course_attribute, attribute_description);
                    attributes.put(course_attribute, att);
                }
                att.addCourse(courseId);
            }
            cache = new CourseAttributeCache(attributes.values());
            this.iCache.put(session.getUniqueId(), cache);
            sLog.info((Object)("UCC Cache [" + session + "]: " + ToolBox.col2string(cache.getAttributes(), (int)2)));
        }
        return cache.getAttributes();
    }

    protected String fixQuery(String query) {
        String replacements;
        Matcher m;
        if ("oc".equalsIgnoreCase(query)) {
            query = "oral communications";
        }
        if ("wc".equalsIgnoreCase(query)) {
            query = "written communication";
        }
        if (query == null || query.length() <= 3) {
            return null;
        }
        String regExp = this.getPlaceHolderRegExp();
        if (regExp != null && !regExp.isEmpty() && (m = Pattern.compile(regExp).matcher(query)).matches()) {
            query = m.group(2);
        }
        if ((replacements = this.getPlaceHolderRenames()) != null && !replacements.isEmpty()) {
            for (String rep : replacements.split("[\r\n]")) {
                int idx = rep.indexOf(124);
                if (idx <= 0 || !query.matches(rep.substring(0, idx))) continue;
                query = rep.substring(idx + 1);
                break;
            }
        }
        return query.toLowerCase();
    }

    @Override
    public List<XCourse> getCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, String query, boolean allowPartialMatch) {
        String q = this.fixQuery(query);
        if (q == null) {
            return null;
        }
        ArrayList<XCourse> ret = new ArrayList<XCourse>();
        if (this.useCache()) {
            boolean fullMatch = false;
            for (CourseAttribute ca : this.getCourseAttributes(server.getAcademicSession(), helper.getHibSession())) {
                XCourse course;
                if (ca.isFullMatch(q)) {
                    if (!fullMatch) {
                        fullMatch = true;
                        ret.clear();
                    }
                    for (Long courseId : ca.getCourseIds()) {
                        course = server.getCourse(courseId);
                        if (course == null) continue;
                        ret.add(course);
                    }
                    continue;
                }
                if (!allowPartialMatch || fullMatch || !ca.isPartialMatch(q)) continue;
                for (Long courseId : ca.getCourseIds()) {
                    course = server.getCourse(courseId);
                    if (course == null) continue;
                    ret.add(course);
                }
            }
        } else {
            XCourse course;
            for (Long courseId : helper.getHibSession().createNativeQuery(this.getCourseLookupFullSQL(), Long.class).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setParameter("term", (Object)this.getBannerTerm(server.getAcademicSession())).setParameter("query", (Object)q).list()) {
                course = server.getCourse(courseId);
                if (course == null) continue;
                ret.add(course);
            }
            if (allowPartialMatch && ret.isEmpty()) {
                for (Long courseId : helper.getHibSession().createNativeQuery(this.getCourseLookupPartialSQL(), Long.class).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setParameter("term", (Object)this.getBannerTerm(server.getAcademicSession())).setParameter("query", (Object)q).list()) {
                    course = server.getCourse(courseId);
                    if (course == null) continue;
                    ret.add(course);
                }
            }
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public void dispose() {
    }

    @Override
    public List<CourseOffering> getCourses(AcademicSessionInfo session, Session hibSession, String query, boolean allowPartialMatch) {
        String q = this.fixQuery(query);
        if (q == null) {
            return null;
        }
        if (this.useCache()) {
            ArrayList<Long> courseIds = new ArrayList<Long>();
            boolean fullMatch = false;
            for (CourseAttribute ca : this.getCourseAttributes(session, hibSession)) {
                if (ca.isFullMatch(q)) {
                    if (!fullMatch) {
                        fullMatch = true;
                        courseIds.clear();
                    }
                    courseIds.addAll(ca.getCourseIds());
                    continue;
                }
                if (!allowPartialMatch || fullMatch || !ca.isPartialMatch(q)) continue;
                courseIds.addAll(ca.getCourseIds());
            }
            if (courseIds == null || courseIds.isEmpty()) {
                return null;
            }
            return hibSession.createQuery("from CourseOffering where uniqueId in :courseIds order by subjectAreaAbbv, courseNbr", CourseOffering.class).setParameterList("courseIds", courseIds, Long.class).setCacheable(true).list();
        }
        List courseIds = hibSession.createNativeQuery(this.getCourseLookupFullSQL(), Long.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("term", (Object)this.getBannerTerm(session)).setParameter("query", (Object)q).list();
        if (allowPartialMatch && (courseIds == null || courseIds.isEmpty())) {
            courseIds = hibSession.createNativeQuery(this.getCourseLookupPartialSQL(), Long.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("term", (Object)this.getBannerTerm(session)).setParameter("query", (Object)q).list();
        }
        if (courseIds == null || courseIds.isEmpty()) {
            return null;
        }
        return hibSession.createQuery("from CourseOffering where uniqueId in :courseIds order by subjectAreaAbbv, courseNbr", CourseOffering.class).setParameterList("courseIds", (Collection)courseIds, Long.class).setCacheable(true).list();
    }

    @Override
    public Set<Long> getCourseIds(AcademicSessionInfo session, Session hibSession, String query, boolean allowPartialMatch) {
        String q = this.fixQuery(query);
        if (q == null) {
            return null;
        }
        if (this.useCache()) {
            HashSet<Long> courseIds = new HashSet<Long>();
            boolean fullMatch = false;
            for (CourseAttribute ca : this.getCourseAttributes(session, hibSession)) {
                if (ca.isFullMatch(q)) {
                    if (!fullMatch) {
                        fullMatch = true;
                        courseIds.clear();
                    }
                    courseIds.addAll(ca.getCourseIds());
                    continue;
                }
                if (!allowPartialMatch || fullMatch || !ca.isPartialMatch(q)) continue;
                courseIds.addAll(ca.getCourseIds());
            }
            return courseIds;
        }
        if (hibSession == null) {
            hibSession = new _RootDAO().getSession();
        }
        List courseIds = hibSession.createNativeQuery(this.getCourseLookupFullSQL(), Long.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("term", (Object)this.getBannerTerm(session)).setParameter("query", (Object)q).list();
        if (allowPartialMatch && (courseIds == null || courseIds.isEmpty())) {
            courseIds = hibSession.createNativeQuery(this.getCourseLookupPartialSQL(), Long.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("term", (Object)this.getBannerTerm(session)).setParameter("query", (Object)q).list();
        }
        if (courseIds == null || courseIds.isEmpty()) {
            return null;
        }
        HashSet<Long> ret = new HashSet<Long>(courseIds);
        return ret;
    }

    @Override
    public void addSuggestions(OnlineSectioningServer server, OnlineSectioningHelper helper, String query, EventInterface.FilterRpcResponse filter) {
        String q = this.fixQuery(query);
        if (q == null) {
            return;
        }
        if (this.useCache()) {
            for (CourseAttribute ca : this.getCourseAttributes(server.getAcademicSession(), helper.getHibSession())) {
                if (!ca.isFullMatch(q) && !ca.isPartialMatch(q)) continue;
                filter.addSuggestion(ca.getAttributeDescription(), ca.getCourseAttribute(), "UCC Attribute", "lookup", true);
            }
        } else {
            for (Object[] data : helper.getHibSession().createNativeQuery(this.getSuggestionSQL(), Object[].class).setParameter("term", (Object)this.getBannerTerm(server.getAcademicSession())).setParameter("query", (Object)q).list()) {
                String course_attribute = (String)data[0];
                String attribute_description = (String)data[1];
                filter.addSuggestion(attribute_description, course_attribute, "UCC Attribute", "lookup", true);
            }
        }
    }

    private static class CourseAttributeCache {
        Set<CourseAttribute> iAttributes;
        long iTimeStamp;

        public CourseAttributeCache(Collection<CourseAttribute> attributes) {
            this.iAttributes = new TreeSet<CourseAttribute>(attributes);
            this.iTimeStamp = System.currentTimeMillis();
        }

        public Collection<CourseAttribute> getAttributes() {
            return this.iAttributes;
        }

        public boolean isActive(long ttl) {
            return System.currentTimeMillis() - this.iTimeStamp <= ttl;
        }
    }

    private static class CourseAttribute
    implements Comparable<CourseAttribute> {
        String iCourseAttribute;
        String iAttributeDescription;
        String iAttributeDescriptionLowCase;
        List<Long> iCourseIds = new ArrayList<Long>();

        private CourseAttribute(String courseAttribute, String attributeDescription) {
            this.iCourseAttribute = courseAttribute;
            this.iAttributeDescription = attributeDescription;
            this.iAttributeDescriptionLowCase = attributeDescription.toLowerCase();
        }

        void addCourse(Long courseId) {
            this.iCourseIds.add(courseId);
        }

        List<Long> getCourseIds() {
            return this.iCourseIds;
        }

        public boolean isFullMatch(String query) {
            return this.iCourseAttribute.equalsIgnoreCase(query) || this.iAttributeDescription.equalsIgnoreCase("uc-" + query);
        }

        public boolean isPartialMatch(String query) {
            return this.iAttributeDescriptionLowCase.startsWith("uc-" + query) || this.iAttributeDescriptionLowCase.contains(" " + query);
        }

        public String getCourseAttribute() {
            return this.iCourseAttribute;
        }

        public String getAttributeDescription() {
            return this.iAttributeDescription;
        }

        public String toString() {
            return this.iCourseAttribute + " - " + this.iAttributeDescription + ": " + this.iCourseIds.size() + " courses";
        }

        @Override
        public int compareTo(CourseAttribute ca) {
            return this.iCourseAttribute.compareTo(ca.iCourseAttribute);
        }

        public int hashCode() {
            return this.iCourseAttribute.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CourseAttribute)) {
                return false;
            }
            return this.iCourseAttribute.equals(((CourseAttribute)o).iCourseAttribute);
        }
    }
}

