/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.SuggestionSelection;
import org.cpsolver.studentsct.reservation.IndividualRestriction;
import org.cpsolver.studentsct.reservation.Restriction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetInfo;
import org.unitime.timetable.onlinesectioning.custom.AdvisorCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationHelper;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.Formats;

public class PurdueCourseRequestsValidationProvider
implements CourseRequestsValidationProvider,
AdvisorCourseRequestsValidationProvider {
    private static Log sLog = LogFactory.getLog(PurdueCourseRequestsValidationProvider.class);
    protected static final StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public PurdueCourseRequestsValidationProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getSpecialRegistrationApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.specreg.readTimeout", "60000");
    }

    protected String getSpecialRegistrationApiValidationSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site.validation", this.getSpecialRegistrationApiSite() + "/checkRestrictions");
    }

    protected String getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiSiteSubmitRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.submitRegistration", this.getSpecialRegistrationApiSite() + "/submitRegistration");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkAllSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkAllSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.validation", "PREREG"));
    }

    protected boolean isIngoreLCRegistrationErrors() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.ignoreLCerrors", "false"));
    }

    protected boolean isCanChangeNote() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.canChangeNote", "true"));
    }

    protected boolean isWaitListNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.waitListNoAlts", "false"));
    }

    protected boolean isAdvisedNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.advisedNoAlts", "true"));
    }

    protected String getOverrideNotNeededReasonRegExp() {
        return ApplicationProperties.getProperty("purdue.specreg.overrideNotNeededRegExp", "Denying as override is not required\\.");
    }

    protected String getBannerId(XStudent student) {
        Object id = student.getExternalId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getBannerId(org.unitime.timetable.model.Student student) {
        Object id = student.getExternalUniqueId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getRequestorId(OnlineSectioningLog.Entity user) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        Object id = user.getExternalId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected SpecialRegistrationInterface.RequestorRole getRequestorType(OnlineSectioningLog.Entity user, XStudent student) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        if (student != null) {
            return user.getExternalId().equals(student.getExternalId()) ? SpecialRegistrationInterface.RequestorRole.STUDENT : SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        if (user.hasType()) {
            switch (user.getType()) {
                case MANAGER: {
                    return SpecialRegistrationInterface.RequestorRole.MANAGER;
                }
                case STUDENT: {
                    return SpecialRegistrationInterface.RequestorRole.STUDENT;
                }
            }
            return SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        return null;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected String getCRN(Section section, Course course) {
        String name = section.getName(course.getId());
        if (name != null && name.indexOf(45) >= 0) {
            return name.substring(0, name.indexOf(45));
        }
        return name;
    }

    protected Enrollment firstEnrollment(CourseRequest request, Assignment<Request, Enrollment> assignment, Course course, Config config, HashSet<Section> sections, int idx) {
        if (config.getSubparts().size() == idx) {
            Enrollment e = new Enrollment((Request)request, request.getCourses().indexOf(course), null, config, new HashSet<Section>(sections), null);
            if (request.isNotAllowed(e)) {
                return null;
            }
            return e;
        }
        Subpart subpart = (Subpart)config.getSubparts().get(idx);
        List sectionsThisSubpart = subpart.getSections();
        ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
        for (Section section : sectionsThisSubpart) {
            if (section.isCancelled() || section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections) || request.isNotAllowed(course, section)) continue;
            matchingSectionsThisSubpart.add(section);
        }
        for (Section section : matchingSectionsThisSubpart) {
            sections.add(section);
            Enrollment e = this.firstEnrollment(request, assignment, course, config, sections, idx + 1);
            if (e != null) {
                return e;
            }
            sections.remove(section);
        }
        return null;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object solverServer;
        Object section;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer CONF_NONE = null;
        Integer CONF_UNITIME = 0;
        Integer CONF_BANNER = 1;
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        Student student = new Student(request.getStudentId().longValue());
        student.setExternalId(original.getExternalId());
        student.setName(original.getName());
        student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        student.setAllowDisabled(original.isAllowDisabled());
        student.setClassFirstDate(original.getClassStartDate());
        student.setClassLastDate(original.getClassEndDate());
        student.setBackToBackPreference(original.getBackToBackPreference());
        student.setModalityPreference(original.getModalityPreference());
        HashMap<Long, Section> classTable = new HashMap<Long, Section>();
        HashSet<XDistribution> distributions = new HashSet<XDistribution>();
        Hashtable preferredSections = new Hashtable();
        boolean hasAssignment = false;
        for (XRequest reqest : original.getRequests()) {
            if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
            hasAssignment = true;
            break;
        }
        for (CourseRequestInterface.Request c : request.getCourses()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, false, classTable, distributions, hasAssignment, true, helper);
        }
        for (CourseRequestInterface.Request c : request.getAlternatives()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, false, classTable, distributions, hasAssignment, true, helper);
        }
        HashSet<XCourseId> lcCourses = new HashSet<XCourseId>();
        HashSet<XCourseId> fixedCourses = new HashSet<XCourseId>();
        boolean ignoreLcCourses = this.isIngoreLCRegistrationErrors();
        for (XRequest r : original.getRequests()) {
            if (!(r instanceof XCourseRequest)) continue;
            XCourseRequest cr = (XCourseRequest)r;
            XEnrollment en = cr.getEnrollment();
            if (en != null) {
                for (Request q : student.getRequests()) {
                    Course course2;
                    if (!(q instanceof CourseRequest) || (course2 = ((CourseRequest)q).getCourse(en.getCourseId().longValue())) == null) continue;
                    HashSet<Section> sections = new HashSet<Section>();
                    for (Long sectionId : en.getSectionIds()) {
                        section = course2.getOffering().getSection(sectionId.longValue());
                        if (section == null) continue;
                        sections.add((Section)section);
                    }
                    if (sections.isEmpty()) continue;
                    preferredSections.put((CourseRequest)q, sections);
                }
            }
            for (XCourseId course3 : cr.getCourseIds()) {
                XOffering offering = server.getOffering(course3.getOfferingId());
                if (offering != null && offering.hasLearningCommunityReservation(original, course3)) {
                    lcCourses.add(course3);
                }
                if (offering == null || !offering.hasIndividualReservation(original, course3) && !offering.hasGroupReservation(original, course3)) continue;
                fixedCourses.add(course3);
            }
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkUnavailabilitiesFromOtherSessions", "false"))) {
            if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                GetInfo.fillInUnavailabilitiesFromOtherSessions(student, server, helper);
            } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(student, server, helper);
            }
        }
        float[] otherCredits = new float[]{0.0f, 0.0f};
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkCreditsFromOtherSessions", "false")) && (solverServer = SolverServerImplementation.getInstance()) != null) {
            otherCredits = solverServer.getCreditRangeFromOtherSessions(server.getAcademicSession(), student.getExternalId());
        }
        model.addStudent(student);
        model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
        for (XDistribution link : distributions) {
            if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
            ArrayList<Section> sections = new ArrayList<Section>();
            for (Long sectionId : link.getSectionIds()) {
                Section x = (Section)classTable.get(sectionId);
                if (x == null) continue;
                sections.add(x);
            }
            if (sections.size() < 2) continue;
            model.addLinkedSections(linkedClassesMustBeUsed, sections);
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                for (Course course : cr.getCourses()) {
                    new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true, true);
                }
            }
        }
        boolean questionTimeConflict = false;
        HashMap<Object, Course> singleSections = new HashMap<Object, Course>();
        for (Request r : student.getRequests()) {
            if (r.isAlternative() || !(r instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)r;
            for (Course course4 : cr.getCourses()) {
                if (course4.getOffering().getConfigs().size() != 1) continue;
                for (Subpart subpart : ((Config)course4.getOffering().getConfigs().get(0)).getSubparts()) {
                    if (subpart.getSections().size() != 1) continue;
                    section = (Section)subpart.getSections().get(0);
                    for (Section other : singleSections.keySet()) {
                        if (!section.isOverlapping((SctAssignment)other)) continue;
                        boolean confirm = (original.getRequestForCourse(course4.getId()) == null || original.getRequestForCourse(((Course)singleSections.get(other)).getId()) == null) && cr.getCourses().size() == 1;
                        response.addMessage(course4.getId(), course4.getName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course4.getName()).replace("{other}", ((Course)singleSections.get(other)).getName()), confirm ? CONF_UNITIME : CONF_NONE);
                        if (!confirm) continue;
                        questionTimeConflict = true;
                    }
                    if (cr.getCourses().size() != 1) continue;
                    singleSections.put(section, course4);
                }
            }
        }
        boolean questionInconStuPref = false;
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)r;
            for (Course course5 : cr.getCourses()) {
                if (!SectioningRequest.hasInconsistentRequirements(cr, course5.getId())) continue;
                boolean confirm = original.getRequestForCourse(course5.getId()) == null;
                response.addMessage(course5.getId(), course5.getName(), "STUD_PREF", ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course5.getName()), confirm ? CONF_UNITIME : CONF_NONE);
                if (!confirm) continue;
                questionInconStuPref = true;
            }
        }
        boolean questionRestrictionsNotMet = false;
        boolean onlineOnly = false;
        XSchedulingRule rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
        if (rule != null) {
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                for (Object course6 : cr.getCourses()) {
                    if (!course6.getOffering().hasRestrictions()) continue;
                    for (Restriction res : course6.getOffering().getRestrictions()) {
                        if (!res.isApplicable(student) || !res.getConfigs().isEmpty()) continue;
                        boolean confirm = original.getRequestForCourse(course6.getId()) == null;
                        response.addMessage(course6.getId(), course6.getName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", course6.getName()), confirm ? CONF_UNITIME : CONF_NONE);
                        if (!confirm) continue;
                        questionRestrictionsNotMet = true;
                    }
                }
            }
        } else {
            String filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (filter != null && !filter.isEmpty() && new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                onlineOnly = true;
            }
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                for (Course course7 : cr.getCourses()) {
                    if (!course7.getOffering().hasRestrictions()) continue;
                    for (Restriction res : course7.getOffering().getRestrictions()) {
                        boolean confirm;
                        if (!res.isApplicable(student) || !res.getConfigs().isEmpty()) continue;
                        boolean bl4 = confirm = original.getRequestForCourse(course7.getId()) == null;
                        if (onlineOnly) {
                            response.addMessage(course7.getId(), course7.getName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course7.getName()), confirm ? CONF_UNITIME : CONF_NONE);
                        } else {
                            response.addMessage(course7.getId(), course7.getName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course7.getName()), confirm ? CONF_UNITIME : CONF_NONE);
                        }
                        if (!confirm) continue;
                        questionRestrictionsNotMet = true;
                    }
                }
            }
        }
        boolean questionFreeTime = false;
        for (int i = 0; i < request.getCourses().size(); ++i) {
            CourseRequestInterface.Request r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse()) continue;
                hasCourse = true;
            }
            Object free = "";
            boolean confirm = false;
            block31: for (CourseRequestInterface.FreeTime ft : r.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                if (confirm) continue;
                XFreeTimeRequest ftr = original.getRequestForFreeTime(ft);
                if (ftr == null) {
                    confirm = true;
                    continue;
                }
                if (!hasCourse) continue;
                for (int j = i + 1; j < request.getCourses().size(); ++j) {
                    XCourseRequest cr;
                    CourseRequestInterface.Request request2 = request.getCourse(j);
                    if (!request2.hasRequestedCourse() || !request2.getRequestedCourse(0).isCourse() || (cr = original.getRequestForCourse(request2.getRequestedCourse(0).getCourseId())) != null && cr.getPriority() >= ftr.getPriority()) continue;
                    confirm = true;
                    continue block31;
                }
            }
            if (hasCourse) {
                response.addMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeHighPriority", "High priority free time"), confirm ? CONF_UNITIME : CONF_NONE);
            }
            if (!confirm) continue;
            questionFreeTime = true;
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
            selection.setPreferredSections(new Hashtable());
            selection.setRequiredSections(preferredSections);
        } else {
            selection.setPreferredSections(preferredSections);
            selection.setRequiredSections(new Hashtable());
        }
        selection.setRequiredFreeTimes(new HashSet());
        selection.setRequiredUnassinged(new HashSet());
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student);
        neighbour.assign((Assignment)assignment, 0L);
        SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        req.studentId = this.getBannerId(original);
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationApiMode();
        HashMap<String, XCourseId> crn2course = new HashMap<String, XCourseId>();
        HashMap<XCourseId, CallSite> course2banner = new HashMap<XCourseId, CallSite>();
        for (Request r : model.variables()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)r;
            Enrollment e = (Enrollment)assignment.getValue((Variable)cr);
            block34: for (Object course8 : cr.getCourses()) {
                XCourseId cid = new XCourseId((Course)course8);
                course2banner.put(cid, (CallSite)((Object)(course8.getSubjectArea() + " " + course8.getCourseNumber())));
                if (e != null && course8.equals((Object)e.getCourse())) {
                    for (Section section2 : e.getSections()) {
                        String string = this.getCRN(section2, (Course)course8);
                        crn2course.put(string, cid);
                        SpecialRegistrationHelper.addCrn(req, string);
                    }
                    continue;
                }
                for (Enrollment x : cr.values((Assignment)assignment)) {
                    if (!course8.equals((Object)x.getCourse())) continue;
                    for (Object section3 : x.getSections()) {
                        String string = this.getCRN((Section)section3, (Course)course8);
                        crn2course.put(string, cid);
                        SpecialRegistrationHelper.addAltCrn(req, string);
                    }
                    continue block34;
                }
                for (Object config : course8.getOffering().getConfigs()) {
                    Enrollment enrollment;
                    Object section3;
                    if (cr.isNotAllowed((Course)course8, (Config)config) || (enrollment = this.firstEnrollment(cr, (Assignment<Request, Enrollment>)assignment, (Course)course8, (Config)config, new HashSet<Section>(), 0)) == null) continue;
                    section3 = enrollment.getSections().iterator();
                    while (section3.hasNext()) {
                        Section section2 = (Section)section3.next();
                        String string = this.getCRN(section2, (Course)course8);
                        crn2course.put(string, cid);
                        SpecialRegistrationHelper.addAltCrn(req, string);
                    }
                    continue block34;
                }
            }
        }
        String creditError = null;
        if (!SpecialRegistrationHelper.isEmpty(req)) {
            String minCreditLimitFilter;
            XCourse c;
            CourseRequestInterface.RequestedCourseStatus status;
            Iterator<CourseRequestInterface.RequestedCourse> problems;
            String bc;
            Object course;
            void var37_82;
            if (req.changes == null) {
                req.changes = new SpecialRegistrationInterface.RestrictionsCheckRequest();
            }
            SpecialRegistrationInterface.CheckRestrictionsResponse resp = null;
            ClientResource resource = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)req));
                long l = System.currentTimeMillis();
                resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
                helper.getAction().setApiPostTime(System.currentTimeMillis() - l);
                resp = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)resp));
                }
                helper.getAction().addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)resp));
                if (SpecialRegistrationInterface.ResponseStatus.success != resp.status) {
                    throw new SectioningException((String)(resp.message == null || resp.message.isEmpty() ? "Failed to check student eligibility (" + resp.status + ")." : resp.message));
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
            Float maxCredit = resp.maxCredit;
            if (maxCredit == null) {
                maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            Object var37_81 = null;
            if (resp.deniedMaxCreditRequests != null) {
                for (SpecialRegistrationInterface.DeniedMaxCredit r : resp.deniedMaxCreditRequests) {
                    if (r.mode != req.mode || r.maxCredit == null || !(r.maxCredit.floatValue() > maxCredit.floatValue()) || var37_82 != null && !(var37_82.floatValue() > r.maxCredit.floatValue())) continue;
                    Float f = r.maxCredit;
                }
            }
            HashMap overrides = new HashMap();
            Object maxCreditOverride = null;
            CourseRequestInterface.RequestedCourseStatus maxCreditOverrideStatus = null;
            if (resp.cancelRegistrationRequests != null) {
                for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : resp.cancelRegistrationRequests) {
                    if (specialRegistration.changes == null || specialRegistration.changes.isEmpty()) continue;
                    for (SpecialRegistrationInterface.Change change : specialRegistration.changes) {
                        if (change.status == SpecialRegistrationInterface.ChangeStatus.cancelled || change.status == SpecialRegistrationInterface.ChangeStatus.denied) continue;
                        if (change.subject != null && change.courseNbr != null) {
                            String string = change.subject + " " + change.courseNbr;
                            HashMap<String, CourseRequestInterface.RequestedCourseStatus> problems2 = (HashMap<String, CourseRequestInterface.RequestedCourseStatus>)overrides.get(string);
                            if (problems2 == null) {
                                problems2 = new HashMap<String, CourseRequestInterface.RequestedCourseStatus>();
                                overrides.put((CallSite)((Object)string), problems2);
                            }
                            if (change.errors == null) continue;
                            for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                                if (err.code == null) continue;
                                problems2.put(err.code, this.status(change));
                            }
                            continue;
                        }
                        if (specialRegistration.maxCredit == null || maxCreditOverride != null && !(((Float)maxCreditOverride).floatValue() < specialRegistration.maxCredit.floatValue())) continue;
                        maxCreditOverride = specialRegistration.maxCredit;
                        maxCreditOverrideStatus = this.status(change);
                    }
                }
            }
            Set<Long> advisorWaitListedCourseIds = original.getAdvisorWaitListedCourseIds(server);
            String string = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
            if (var37_82 != null && request.getCredit(advisorWaitListedCourseIds) + otherCredits[1] >= var37_82.floatValue()) {
                for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue() - otherCredits[1])) {
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))), CONF_NONE);
                }
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))).replace("{maxCreditDenied}", sCreditFormat.format((Number)var37_82)));
                response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                creditError = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))).replace("{maxCreditDenied}", sCreditFormat.format((Number)var37_82));
            } else if (string != null) {
                float maxCreditLimit = Float.parseFloat(string);
                if (maxCredit != null && maxCredit.floatValue() > maxCreditLimit) {
                    maxCreditLimit = maxCredit.floatValue();
                }
                if (request.getCredit(advisorWaitListedCourseIds) + otherCredits[1] > maxCreditLimit) {
                    for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCreditLimit - otherCredits[1])) {
                        response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))), CONF_NONE);
                    }
                    response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))));
                    response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                    creditError = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1])));
                }
            }
            if (creditError == null && maxCredit.floatValue() < request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]) {
                for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue() - otherCredits[1])) {
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))), maxCreditOverride == null || ((Float)maxCreditOverride).floatValue() < request.getCredit(advisorWaitListedCourseIds) + otherCredits[1] ? CONF_BANNER : CONF_NONE);
                }
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds) + otherCredits[1]))));
                response.setMaxCreditOverrideStatus(maxCreditOverrideStatus == null || ((Float)maxCreditOverride).floatValue() < request.getCredit(advisorWaitListedCourseIds) + otherCredits[1] ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : maxCreditOverrideStatus);
            }
            HashMap<CallSite, TreeSet<String>> deniedOverrides = new HashMap<CallSite, TreeSet<String>>();
            HashSet<CallSite> hashSet = new HashSet<CallSite>();
            if (resp.deniedRequests != null) {
                for (SpecialRegistrationInterface.DeniedRequest r : resp.deniedRequests) {
                    if (r.mode != req.mode) continue;
                    String course9 = r.subject + " " + r.courseNbr;
                    TreeSet<String> problems3 = (TreeSet<String>)deniedOverrides.get(course9);
                    if (problems3 == null) {
                        problems3 = new TreeSet<String>();
                        deniedOverrides.put((CallSite)((Object)course9), problems3);
                    }
                    problems3.add(r.code);
                    if (!this.isOverrideNotNeed(r)) continue;
                    hashSet.add((CallSite)((Object)course9));
                }
            }
            if (resp.outJson != null && resp.outJson.message != null && resp.outJson.status != null && resp.outJson.status != SpecialRegistrationInterface.ResponseStatus.success) {
                response.addError(null, null, "Failure", resp.outJson.message);
                response.setErrorMessage(resp.outJson.message);
            } else if (resp.outJsonAlternatives != null && resp.outJsonAlternatives.message != null && resp.outJsonAlternatives.status != null && resp.outJsonAlternatives.status != SpecialRegistrationInterface.ResponseStatus.success) {
                response.addError(null, null, "Failure", resp.outJsonAlternatives.message);
                response.setErrorMessage(resp.outJsonAlternatives.message);
            }
            if (resp.outJson != null && resp.outJson.problems != null) {
                for (SpecialRegistrationInterface.Problem problem : resp.outJson.problems) {
                    Set set;
                    if ("HOLD".equals(problem.code)) {
                        response.addError(null, null, problem.code, problem.message);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                    }
                    if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(course)) continue;
                    bc = (String)course2banner.get(course);
                    problems = bc == null ? null : (Map)overrides.get(bc);
                    Set set2 = set = bc == null ? null : (Set)deniedOverrides.get(bc);
                    if (set != null && set.contains(problem.code)) {
                        if (hashSet.contains(bc)) {
                            response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Needed " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                            continue;
                        }
                        if (fixedCourses.contains(course)) {
                            response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                        continue;
                    }
                    CourseRequestInterface.RequestedCourseStatus requestedCourseStatus = status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                    if (status == null) {
                        if (resp.overrides != null && !resp.overrides.contains(problem.code)) {
                            response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        XCourse xCourse = c = course instanceof XCourse ? (XCourse)course : server.getCourse(((XCourseId)course).getCourseId());
                        if (c != null && !c.isOverrideEnabled(problem.code)) {
                            response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                    }
                    response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                }
            }
            if (resp.outJsonAlternatives != null && resp.outJsonAlternatives.problems != null) {
                for (SpecialRegistrationInterface.Problem problem : resp.outJsonAlternatives.problems) {
                    Set set;
                    if ("HOLD".equals(problem.code)) {
                        response.addError(null, null, problem.code, problem.message);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                    }
                    if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(course)) continue;
                    bc = (String)course2banner.get(course);
                    problems = bc == null ? null : (Map)overrides.get(bc);
                    Set set3 = set = bc == null ? null : (Set)deniedOverrides.get(bc);
                    if (set != null && set.contains(problem.code)) {
                        if (hashSet.contains(bc)) {
                            response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Needed " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                            continue;
                        }
                        if (fixedCourses.contains(course)) {
                            response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                        continue;
                    }
                    CourseRequestInterface.RequestedCourseStatus requestedCourseStatus = status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                    if (status == null) {
                        if (resp.overrides != null && !resp.overrides.contains(problem.code)) {
                            response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        XCourse xCourse = c = course instanceof XCourse ? (XCourse)course : server.getCourse(((XCourseId)course).getCourseId());
                        if (c != null && !c.isOverrideEnabled(problem.code)) {
                            response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                    }
                    response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                }
            }
            if (response.hasMessages()) {
                for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                    if (m.getCourse() != null && m.getMessage().indexOf("this section") >= 0) {
                        m.setMessage(m.getMessage().replace("this section", m.getCourse()));
                    }
                    if (m.getCourse() == null || m.getMessage().indexOf(" (CRN ") < 0) continue;
                    m.setMessage(m.getMessage().replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " "));
                }
            }
            String string2 = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
            float minCredit = otherCredits[0];
            block51: for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    if (!requestedCourse.hasCredit()) continue;
                    minCredit += requestedCourse.getCreditMin().floatValue();
                    continue block51;
                }
            }
            if (creditError == null && string2 != null && minCredit < Float.parseFloat(string2) && (maxCredit == null || maxCredit.floatValue() > Float.parseFloat(string2)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
                creditError = ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string2).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string2).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
                response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
            }
        }
        HashSet<Long> coursesWithNotAlt = new HashSet<Long>();
        for (XRequest r : original.getRequests()) {
            XCourseRequest xCourseRequest;
            if (!(r instanceof XCourseRequest) || (xCourseRequest = (XCourseRequest)r).getCourseIds().size() != 1 || xCourseRequest.isAlternative()) continue;
            coursesWithNotAlt.add(xCourseRequest.getCourseIds().get(0).getCourseId());
        }
        HashSet<Long> advisorCoursesNoAlt = new HashSet<Long>();
        if (original.hasAdvisorRequests() && this.isAdvisedNoAlts()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                int count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != xAdvisorRequest.getPriority()) continue;
                    ++count;
                }
                if (count != true || xAdvisorRequest.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(xAdvisorRequest.getCourseId().getCourseId());
            }
        } else if (original.hasAdvisorRequests() && this.isWaitListNoAlts()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                if (!xAdvisorRequest.isWaitListOrNoSub() || xAdvisorRequest.isSubstitute()) continue;
                int count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != xAdvisorRequest.getPriority() || x.isSubstitute()) continue;
                    ++count;
                }
                if (count != true || xAdvisorRequest.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(xAdvisorRequest.getCourseId().getCourseId());
            }
        }
        boolean questionNoAlt = false;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || advisorCoursesNoAlt.contains(rc.getCourseId())) continue;
            response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), !coursesWithNotAlt.contains(rc.getCourseId()) ? CONF_UNITIME : CONF_NONE);
            if (coursesWithNotAlt.contains(rc.getCourseId())) continue;
            questionNoAlt = true;
        }
        boolean bl5 = false;
        boolean dropImportant = false;
        boolean dropVital = false;
        boolean dropCritical = false;
        for (XRequest xRequest : original.getRequests()) {
            boolean bl6;
            XCourseRequest cr;
            if (!(xRequest instanceof XCourseRequest) || !(cr = (XCourseRequest)xRequest).isCritical() || cr.isAlternative() || cr.getCourseIds().isEmpty()) continue;
            boolean bl7 = false;
            for (XCourseId course10 : cr.getCourseIds()) {
                if (request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course10.getCourseId(), course10.getCourseName())) == null) continue;
                bl6 = true;
                break;
            }
            if (bl6) continue;
            XCourseId xCourseId = cr.getCourseIds().get(0);
            if (cr.getCritical() == 2) {
                response.addMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Important course has been removed.").replace("{course}", xCourseId.getCourseName()), CONF_UNITIME);
                dropImportant = true;
            } else if (cr.getCritical() == 3) {
                response.addMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Vital course has been removed.").replace("{course}", xCourseId.getCourseName()), CONF_UNITIME);
                dropVital = true;
            } else {
                response.addMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Critical course has been removed.").replace("{course}", xCourseId.getCourseName()), CONF_UNITIME);
                dropCritical = true;
            }
            bl3 = true;
        }
        boolean questionMissingAdvisorCritical = false;
        boolean bl8 = false;
        boolean missImportant = false;
        boolean bl9 = false;
        CourseDemand.Critical critical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        if (original.hasAdvisorRequests()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                CourseRequestInterface.RequestPriority arp;
                if (ar.getAlternative() != 0 || ar.isSubstitute() || !ar.isCritical() || !ar.hasCourseId() || (arp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName()))) != null && !arp.isAlternative()) continue;
                boolean hasAlt = false;
                for (XAdvisorRequest alt : original.getAdvisorRequests()) {
                    CourseRequestInterface.RequestPriority altrp;
                    if (alt.getPriority() != ar.getPriority() || !alt.hasCourseId() || alt.isSubstitute() || !alt.isCritical() || ar.getAlternative() == 0 || (altrp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(alt.getCourseId().getCourseId(), alt.getCourseId().getCourseName()))) == null || altrp.isAlternative()) continue;
                    hasAlt = true;
                    break;
                }
                if (hasAlt) continue;
                if (critical == CourseDemand.Critical.IMPORTANT) {
                    response.addMessage(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseMissingAdvisedCritical", "Missing important course that has been recommended by the advisor.").replace("{course}", ar.getCourseId().getCourseName()), CONF_UNITIME);
                    missImportant = true;
                } else if (critical == CourseDemand.Critical.VITAL) {
                    response.addMessage(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseMissingAdvisedCritical", "Missing vital course that has been recommended by the advisor.").replace("{course}", ar.getCourseId().getCourseName()), CONF_UNITIME);
                    bl2 = true;
                } else {
                    response.addMessage(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseMissingAdvisedCritical", "Missing critical course that has been recommended by the advisor.").replace("{course}", ar.getCourseId().getCourseName()), CONF_UNITIME);
                    bl = true;
                }
                questionMissingAdvisorCritical = true;
            }
        }
        if (response.getConfirms().contains(CONF_BANNER)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.bannerProblemsFound", "The following registration errors have been detected:"), CONF_BANNER, -1);
            String note = ApplicationProperties.getProperty("purdue.specreg.messages.courseRequestNote", "<b>Request Note:</b>");
            int idx = 1;
            if (note != null && !note.isEmpty()) {
                response.addConfirmation(note, CONF_BANNER, idx++);
                HashSet<String> courses = new HashSet<String>();
                boolean hasCredit = false;
                for (CourseRequestInterface.CourseMessage x : response.getMessages(CONF_BANNER)) {
                    if ("CREDIT".equals(x.getCode()) || "MAXI".equals(x.getCode())) {
                        hasCredit = true;
                        continue;
                    }
                    if (!x.hasCourse() || !courses.add(x.getCourse())) continue;
                    CourseRequestInterface.CourseMessage cm = response.addConfirmation("", CONF_BANNER, idx++);
                    cm.setCourse(x.getCourse());
                    cm.setCourseId(x.getCourseId());
                    cm.setCode("REQUEST_NOTE");
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.prereg.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        cm.addSuggestion(suggestion);
                    }
                }
                if (hasCredit) {
                    CourseRequestInterface.CourseMessage courseMessage = response.addConfirmation("", CONF_BANNER, idx++);
                    courseMessage.setCourse(MESSAGES.tabRequestNoteMaxCredit());
                    courseMessage.setCode("REQUEST_NOTE");
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.prereg.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        courseMessage.addSuggestion(suggestion);
                    }
                }
            }
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.requestOverrides", "\nIf you have already discussed these courses with your advisor and were advised to request registration in them please select Request Overrides & Submit. If you aren\u2019t sure, click Cancel Submit and consult with your advisor before coming back to your Course Request page."), CONF_BANNER, idx++);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        int line = 2;
        if (creditError != null) {
            response.addConfirmation(creditError, CONF_UNITIME, line++);
        }
        if (questionNoAlt) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.noAlternatives", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no alternatives provided. You may not be able to get a full schedule because you did not provide an alternative course."), CONF_UNITIME, line++);
        }
        if (questionTimeConflict) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.timeConflicts", (line > 2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. You will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, line++);
        }
        if (questionInconStuPref) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", (line > 2 ? "\n" : "") + "One or more courses are not available due to the selected preferences."), CONF_UNITIME, line++);
        }
        if (bl3) {
            if (dropVital && !dropCritical && !dropImportant) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more vital courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (dropImportant && !dropVital && !dropCritical) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more important courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (critical != CourseDemand.Critical.NORMAL) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more critical courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked as critical in your degree plan have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            }
        }
        if (questionMissingAdvisorCritical) {
            if (critical == CourseDemand.Critical.IMPORTANT || missImportant && !bl && !bl2) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as important have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (critical == CourseDemand.Critical.VITAL || bl2 && !bl && !missImportant) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as vital have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (critical == CourseDemand.Critical.CRITICAL) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as critical have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked as critical in your degree plan and that have been listed by your advisor have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            }
        }
        if (questionRestrictionsNotMet) {
            if (rule != null) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.ruleNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no {rule} option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses.".replace("{rule}", rule.getRuleName())), CONF_UNITIME, line++);
            } else if (onlineOnly) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.onlineOnlyNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no online-only option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.residentialNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no residential option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses."), CONF_UNITIME, line++);
            }
        }
        if (questionFreeTime) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeRequested", (line > 2 ? "\n" : "") + "Free time requests will be considered as time blocks during the pre-registration process. When possible, classes should be avoided during free time. However, if a free time request is placed higher than a course, the course cannot be attended during free time and you may not receive a full schedule."), CONF_UNITIME, line++);
        }
        if (line > 2) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, line++);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeDialogName", "Warning Confirmations"), conf.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeContinueButton", "Accept & Continue") : ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButton", "Cancel Submit"), conf.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeContinueButtonTitle", "Accept the above warning(s) and continue to submit the Course Requests") : ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButtonTitle", "Go back to editing your Course Requests"));
        }
        if (conf.contains(CONF_BANNER)) {
            response.setConfirmation(CONF_BANNER, ApplicationProperties.getProperty("purdue.specreg.confirm.bannerDialogName", "Request Overrides"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerYesButton", "Request Overrides & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerYesButtonTitle", "Request overrides for the above registration errors and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerNoButtonTitle", "Go back to editing your Course Requests"));
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        XCourseId cid;
        SpecialRegistrationInterface.CourseCredit cc;
        float maxCreditLimit;
        String minCreditLimitFilter;
        SolverServer solverServer;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        float[] otherCredits = new float[]{0.0f, 0.0f};
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkCreditsFromOtherSessions", "false")) && (solverServer = SolverServerImplementation.getInstance()) != null) {
            otherCredits = solverServer.getCreditRangeFromOtherSessions(server.getAcademicSession(), original.getExternalId());
        }
        request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = otherCredits[0];
        block12: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block12;
            }
        }
        if (minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        ClientResource resource = null;
        HashMap overrides = new HashMap();
        Float maxCredit = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            Iterator<CourseRequestInterface.Request> term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", (String)((Object)term));
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(original));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue((String)((Object)term));
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            helper.getAction().addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
            if (status != null && status.data != null) {
                maxCredit = ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit;
                request.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
            }
            if (maxCredit == null) {
                maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            if (status != null && status.data != null && ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests != null) {
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (r.changes == null) continue;
                    for (SpecialRegistrationInterface.Change change : r.changes) {
                        if (this.status(change) != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING || change.subject == null || change.courseNbr == null) continue;
                        String string = change.subject + " " + change.courseNbr;
                        TreeSet<String> problems = (TreeSet<String>)overrides.get(string);
                        if (problems == null) {
                            problems = new TreeSet<String>();
                            overrides.put((CallSite)((Object)string), problems);
                        }
                        if (change.errors == null) continue;
                        for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                            if (err.code == null) continue;
                            problems.add(err.code);
                        }
                    }
                }
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        SpecialRegistrationInterface.SpecialRegistrationRequest req = new SpecialRegistrationInterface.SpecialRegistrationRequest();
        req.studentId = this.getBannerId(original);
        req.pgrmcode = SpecialRegistrationHelper.getProgramCode(original);
        req.studentCampus = SpecialRegistrationHelper.getCampusCode(original);
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationApiMode();
        req.changes = new ArrayList();
        if (helper.getUser() != null) {
            req.requestorId = this.getRequestorId(helper.getUser());
            req.requestorRole = this.getRequestorType(helper.getUser(), original);
        }
        if (request.hasConfirmations()) {
            SpecialRegistrationInterface.ChangeError e;
            ArrayList<SpecialRegistrationInterface.ChangeError> errors;
            String courseNbr;
            Object subject;
            for (CourseRequestInterface.CourseMessage m3 : request.getConfirmations()) {
                if (!"REQUEST_NOTE".equals(m3.getCode()) || m3.getMessage() == null || m3.getMessage().isEmpty() || m3.hasCourseId()) continue;
                req.maxCreditRequestorNotes = m3.getMessage();
            }
            for (CourseRequestInterface.Request c : request.getCourses()) {
                if (!c.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    XCourse course3;
                    XCourseId cid2 = server.getCourse(rc.getCourseId(), rc.getCourseName());
                    if (cid2 == null) continue;
                    XCourse xCourse = course3 = cid2 instanceof XCourse ? (XCourse)cid2 : server.getCourse(cid2.getCourseId());
                    if (course3 == null) continue;
                    subject = course3.getSubjectArea();
                    courseNbr = course3.getCourseNumber();
                    errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    for (CourseRequestInterface.CourseMessage courseMessage : request.getConfirmations()) {
                        if ("CREDIT".equals(courseMessage.getCode()) || "NO_ALT".equals(courseMessage.getCode()) || "DROP_CRIT".equals(courseMessage.getCode()) || "OVERLAP".equals(courseMessage.getCode()) || "STUD_PREF".equals(courseMessage.getCode()) || "NOT-ONLINE".equals(courseMessage.getCode()) || "NOT-RESIDENTIAL".equals(courseMessage.getCode()) || "NOT-RULE".equals(courseMessage.getCode()) || "REQUEST_NOTE".equals(courseMessage.getCode()) || !courseMessage.hasCourse() || courseMessage.isError() || !course3.getCourseId().equals(courseMessage.getCourseId()) && !course3.getCourseName().equals(courseMessage.getCourse())) continue;
                        e = new SpecialRegistrationInterface.ChangeError();
                        e.code = courseMessage.getCode();
                        e.message = courseMessage.getMessage();
                        errors.add(e);
                    }
                    if (errors.isEmpty()) continue;
                    SpecialRegistrationInterface.Change change = new SpecialRegistrationInterface.Change();
                    change.setCourse((String)subject, courseNbr, this.iExternalTermProvider, server.getAcademicSession());
                    change.crn = "";
                    change.errors = errors;
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    req.changes.add(change);
                    overrides.remove((String)subject + " " + courseNbr);
                    for (CourseRequestInterface.CourseMessage m : request.getConfirmations()) {
                        if (!"REQUEST_NOTE".equals(m.getCode()) || m.getMessage() == null || m.getMessage().isEmpty() || !course3.getCourseName().equals(m.getCourse())) continue;
                        change.requestorNotes = m.getMessage();
                    }
                }
            }
            for (CourseRequestInterface.Request c : request.getAlternatives()) {
                if (!c.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    XCourse course;
                    XCourseId cid2 = server.getCourse(rc.getCourseId(), rc.getCourseName());
                    if (cid2 == null) continue;
                    XCourse xCourse = course = cid2 instanceof XCourse ? (XCourse)cid2 : server.getCourse(cid2.getCourseId());
                    if (course == null) continue;
                    subject = course.getSubjectArea();
                    courseNbr = course.getCourseNumber();
                    errors = new ArrayList();
                    for (CourseRequestInterface.CourseMessage courseMessage : request.getConfirmations()) {
                        if ("CREDIT".equals(courseMessage.getCode()) || "NO_ALT".equals(courseMessage.getCode()) || "DROP_CRIT".equals(courseMessage.getCode()) || "OVERLAP".equals(courseMessage.getCode()) || "STUD_PREF".equals(courseMessage.getCode()) || "NOT-ONLINE".equals(courseMessage.getCode()) || "NOT-RESIDENTIAL".equals(courseMessage.getCode()) || "NOT-RULE".equals(courseMessage.getCode()) || "REQUEST_NOTE".equals(courseMessage.getCode()) || !courseMessage.hasCourse() || courseMessage.isError() || !course.getCourseId().equals(courseMessage.getCourseId()) && !course.getCourseName().equals(courseMessage.getCourse())) continue;
                        e = new SpecialRegistrationInterface.ChangeError();
                        e.code = courseMessage.getCode();
                        e.message = courseMessage.getMessage();
                        errors.add(e);
                    }
                    if (errors.isEmpty()) continue;
                    SpecialRegistrationInterface.Change change = new SpecialRegistrationInterface.Change();
                    change.setCourse((String)subject, courseNbr, this.iExternalTermProvider, server.getAcademicSession());
                    change.crn = "";
                    change.errors = errors;
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    req.changes.add(change);
                    overrides.remove((String)subject + " " + courseNbr);
                    for (CourseRequestInterface.CourseMessage m : request.getConfirmations()) {
                        if (!"REQUEST_NOTE".equals(m.getCode()) || m.getMessage() == null || m.getMessage().isEmpty() || !course.getCourseName().equals(m.getCourse())) continue;
                        change.requestorNotes = m.getMessage();
                    }
                }
            }
        }
        Set<Long> advisorWaitListedCourseIds = original.getAdvisorWaitListedCourseIds(server);
        float total = request.getCredit(advisorWaitListedCourseIds) + otherCredits[1];
        String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
        if (maxCreditLimitStr != null && total > (maxCreditLimit = Float.parseFloat(maxCreditLimitStr))) {
            total = maxCreditLimit;
        }
        if (maxCredit.floatValue() < total) {
            req.maxCredit = Float.valueOf(total);
        }
        req.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        req.alternateCourseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            cc = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                XCourse xCourse;
                cid = server.getCourse(rc.getCourseId(), rc.getCourseName());
                if (cid == null || (xCourse = cid instanceof XCourse ? (XCourse)cid : server.getCourse(cid.getCourseId())) == null) continue;
                if (cc == null) {
                    cc = new SpecialRegistrationInterface.CourseCredit();
                    cc.setCourse(xCourse.getSubjectArea(), xCourse.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                    cc.title = xCourse.getTitle();
                    cc.creditHrs = Float.valueOf(xCourse.hasCredit() ? xCourse.getMinCredit().floatValue() : 0.0f);
                    continue;
                }
                if (cc.alternatives == null) {
                    cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                }
                SpecialRegistrationInterface.CourseCredit courseCredit = new SpecialRegistrationInterface.CourseCredit();
                courseCredit.setCourse(xCourse.getSubjectArea(), xCourse.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                courseCredit.title = xCourse.getTitle();
                courseCredit.creditHrs = Float.valueOf(xCourse.hasCredit() ? xCourse.getMinCredit().floatValue() : 0.0f);
                cc.alternatives.add(courseCredit);
            }
            if (cc == null) continue;
            req.courseCreditHrs.add(cc);
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            cc = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                XCourse xCourse;
                cid = server.getCourse(rc.getCourseId(), rc.getCourseName());
                if (cid == null || (xCourse = cid instanceof XCourse ? (XCourse)cid : server.getCourse(cid.getCourseId())) == null) continue;
                if (cc == null) {
                    cc = new SpecialRegistrationInterface.CourseCredit();
                    cc.subject = xCourse.getSubjectArea();
                    cc.courseNbr = xCourse.getCourseNumber();
                    cc.title = xCourse.getTitle();
                    cc.creditHrs = Float.valueOf(xCourse.hasCredit() ? xCourse.getMinCredit().floatValue() : 0.0f);
                    continue;
                }
                if (cc.alternatives == null) {
                    cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                }
                SpecialRegistrationInterface.CourseCredit courseCredit = new SpecialRegistrationInterface.CourseCredit();
                courseCredit.subject = xCourse.getSubjectArea();
                courseCredit.courseNbr = xCourse.getCourseNumber();
                courseCredit.title = xCourse.getTitle();
                courseCredit.creditHrs = Float.valueOf(xCourse.hasCredit() ? xCourse.getMinCredit().floatValue() : 0.0f);
                cc.alternatives.add(courseCredit);
            }
            if (cc == null) continue;
            req.alternateCourseCreditHrs.add(cc);
        }
        if (!req.changes.isEmpty() || !overrides.isEmpty() || req.maxCredit != null) {
            resource = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)req));
                long t1 = System.currentTimeMillis();
                resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(req));
                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                SpecialRegistrationInterface.SpecialRegistrationResponseList response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)response));
                }
                helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                    throw new SectioningException((String)(response.message == null || response.message.isEmpty() ? "Failed to request overrides (" + response.status + ")." : response.message));
                }
                if (response.data != null) {
                    String courseNbr;
                    String subject;
                    for (CourseRequestInterface.Request c : request.getCourses()) {
                        if (!c.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : c.getRequestedCourse()) {
                            XCourse course4;
                            XCourseId cid3;
                            if (requestedCourse.getStatus() != null && requestedCourse.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
                                requestedCourse.setStatus(null);
                                requestedCourse.setOverrideExternalId(null);
                                requestedCourse.setOverrideTimeStamp(null);
                            }
                            if ((cid3 = server.getCourse(requestedCourse.getCourseId(), requestedCourse.getCourseName())) == null) continue;
                            XCourse xCourse = course4 = cid3 instanceof XCourse ? (XCourse)cid3 : server.getCourse(cid3.getCourseId());
                            if (course4 == null) continue;
                            subject = course4.getSubjectArea();
                            courseNbr = course4.getCourseNumber();
                            block32: for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                                if (r.changes == null) continue;
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr)) continue;
                                    requestedCourse.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                                    requestedCourse.setOverrideExternalId(r.regRequestId);
                                    requestedCourse.setStatus(this.status(r, false));
                                    requestedCourse.setStatusNote(SpecialRegistrationHelper.note(r, false));
                                    requestedCourse.setRequestId(r.regRequestId);
                                    requestedCourse.setRequestorNote(SpecialRegistrationHelper.requestorNotes(r, subject, courseNbr));
                                    continue block32;
                                }
                            }
                        }
                    }
                    for (CourseRequestInterface.Request c : request.getAlternatives()) {
                        if (!c.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse requestedCourse : c.getRequestedCourse()) {
                            XCourse course;
                            XCourseId cid3;
                            if (requestedCourse.getStatus() != null && requestedCourse.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
                                requestedCourse.setStatus(null);
                                requestedCourse.setOverrideExternalId(null);
                                requestedCourse.setOverrideTimeStamp(null);
                            }
                            if ((cid3 = server.getCourse(requestedCourse.getCourseId(), requestedCourse.getCourseName())) == null) continue;
                            XCourse xCourse = course = cid3 instanceof XCourse ? (XCourse)cid3 : server.getCourse(cid3.getCourseId());
                            if (course == null) continue;
                            subject = course.getSubjectArea();
                            courseNbr = course.getCourseNumber();
                            block36: for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                                if (r.changes == null) continue;
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr)) continue;
                                    requestedCourse.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                                    requestedCourse.setOverrideExternalId(r.regRequestId);
                                    requestedCourse.setStatus(this.status(r, false));
                                    requestedCourse.setStatusNote(SpecialRegistrationHelper.note(r, false));
                                    requestedCourse.setRequestId(r.regRequestId);
                                    requestedCourse.setRequestorNote(SpecialRegistrationHelper.requestorNotes(r, subject, courseNbr));
                                    continue block36;
                                }
                            }
                        }
                    }
                    if (req.maxCredit != null) {
                        for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                            if (r.maxCredit == null) continue;
                            request.setMaxCreditOverride(r.maxCredit);
                            request.setMaxCreditOverrideExternalId(r.regRequestId);
                            request.setMaxCreditOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            request.setMaxCreditOverrideStatus(this.status(r, true));
                            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(req.maxCredit)));
                            request.setCreditNote(SpecialRegistrationHelper.note(r, true));
                            request.setRequestorNote(SpecialRegistrationHelper.maxCreditRequestorNotes(r));
                            request.setRequestId(r.regRequestId);
                            break;
                        }
                    } else {
                        request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                }
                if (request.hasConfirmations()) {
                    for (CourseRequestInterface.CourseMessage message : request.getConfirmations()) {
                        if (message.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED) continue;
                        message.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                    }
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
    }

    protected boolean isOverrideNotNeed(SpecialRegistrationInterface.Change change) {
        if (change.status != SpecialRegistrationInterface.ChangeStatus.denied) {
            return false;
        }
        String notNeededRegExp = this.getOverrideNotNeededReasonRegExp();
        if (notNeededRegExp == null || notNeededRegExp.isEmpty()) {
            return false;
        }
        if (change.notes != null) {
            for (SpecialRegistrationInterface.ChangeNote note : change.notes) {
                if (note.notes == null || !note.notes.matches(notNeededRegExp)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isOverrideNotNeed(SpecialRegistrationInterface.DeniedRequest denied) {
        String notNeededRegExp = this.getOverrideNotNeededReasonRegExp();
        if (notNeededRegExp == null || notNeededRegExp.isEmpty()) {
            return false;
        }
        return denied.notes != null && denied.notes.matches(notNeededRegExp);
    }

    protected CourseRequestInterface.RequestedCourseStatus status(SpecialRegistrationInterface.Change change) {
        if (change.status == null) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
        }
        if (this.isOverrideNotNeed(change)) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED;
        }
        switch (change.status) {
            case denied: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
            }
            case approved: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
            }
            case cancelled: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
            }
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    protected CourseRequestInterface.RequestedCourseStatus combine(CourseRequestInterface.RequestedCourseStatus s1, CourseRequestInterface.RequestedCourseStatus s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == s2) {
            return s1;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED) {
            return s2;
        }
        if (s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED) {
            return s1;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
        }
        return s1;
    }

    protected CourseRequestInterface.RequestedCourseStatus status(SpecialRegistrationInterface.SpecialRegistration request, boolean credit) {
        CourseRequestInterface.RequestedCourseStatus ret = null;
        if (request.changes != null) {
            for (SpecialRegistrationInterface.Change ch : request.changes) {
                if (ch.status == null) continue;
                if (credit && ch.subject == null && ch.courseNbr == null) {
                    ret = this.combine(ret, this.status(ch));
                }
                if (credit || ch.subject == null || ch.courseNbr == null) continue;
                ret = this.combine(ret, this.status(ch));
            }
        }
        if (ret != null) {
            return ret;
        }
        if (request.completionStatus != null) {
            switch (request.completionStatus) {
                case completed: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
                }
                case cancelled: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
                }
                case inProgress: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
                }
            }
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    protected List<CourseRequestInterface.RequestedCourse> getOverCreditRequests(CourseRequestInterface request, float maxCredit) {
        ArrayList<CourseRequestInterface.RequestedCourse> ret = new ArrayList<CourseRequestInterface.RequestedCourse>();
        float primary = 0.0f;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).hasCredit() || !((primary += r.getRequestedCourse(0).getCreditMin().floatValue()) > maxCredit)) continue;
            ret.add(r.getRequestedCourse(0));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() <= 1) continue;
            float credit = r.getRequestedCourse(0).hasCredit() ? r.getRequestedCourse(0).getCreditMin().floatValue() : 0.0f;
            for (int i = 1; i < r.getRequestedCourse().size(); ++i) {
                float alt;
                float f = alt = r.getRequestedCourse(i).hasCredit() ? r.getRequestedCourse(i).getCreditMin().floatValue() : 0.0f;
                if (!(primary - credit + alt > maxCredit)) continue;
                ret.add(r.getRequestedCourse(i));
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        float total = 0.0f;
        CourseRequestInterface.RequestedCourse last = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            Float credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue()) || !(total + (credit = rc.getCreditMin()).floatValue() > maxCredit)) continue;
                ret.add(rc);
            }
            if (credit != null) {
                credits.add(credit);
                total += credit.floatValue();
            }
            last = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        Collections.sort(credits);
        float low = credits.isEmpty() ? 0.0f : ((Float)credits.get(0)).floatValue();
        CourseRequestInterface.RequestedCourse first = null;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || !(total + rc.getCreditMin().floatValue() - low > maxCredit)) continue;
                ret.add(rc);
                break;
            }
            if (first != null) continue;
            first = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ret.add(first != null ? first : last);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        String minCreditLimitFilter;
        SolverServer solverServer;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        float[] otherCredits = new float[]{0.0f, 0.0f};
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkCreditsFromOtherSessions", "false")) && (solverServer = SolverServerImplementation.getInstance()) != null) {
            otherCredits = solverServer.getCreditRangeFromOtherSessions(server.getAcademicSession(), original.getExternalId());
        }
        Integer ORD_UNITIME = 0;
        Integer ORD_BANNER = 1;
        Integer ORD_CREDIT = 2;
        HashSet<Long> advisorCoursesNoAlt = new HashSet<Long>();
        if (original.hasAdvisorRequests() && this.isAdvisedNoAlts()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != ar.getPriority()) continue;
                    ++count;
                }
                if (count != true || ar.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(ar.getCourseId().getCourseId());
            }
        } else if (original.hasAdvisorRequests() && this.isWaitListNoAlts()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                if (!ar.isWaitListOrNoSub() || ar.isSubstitute()) continue;
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != ar.getPriority() || x.isSubstitute()) continue;
                    ++count;
                }
                if (count != 1 || ar.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(ar.getCourseId().getCourseId());
            }
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || advisorCoursesNoAlt.contains(rc.getCourseId())) continue;
            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), ORD_UNITIME);
        }
        for (int i = 0; i < request.getCourses().size(); ++i) {
            void var13_25;
            void var13_23;
            CourseRequestInterface.Request r;
            r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            int n = i + 1;
            while (var13_23 < request.getCourses().size()) {
                CourseRequestInterface.Request q = request.getCourse((int)var13_23);
                if (q.hasRequestedCourse() && q.getRequestedCourse(0).isCourse()) {
                    hasCourse = true;
                    break;
                }
                ++var13_23;
            }
            if (!hasCourse) continue;
            String string = "";
            for (CourseRequestInterface.FreeTime freeTime : r.getRequestedCourse(0).getFreeTime()) {
                void var13_27;
                if (!var13_25.isEmpty()) {
                    String string2 = (String)var13_25 + ", ";
                }
                String string3 = (String)var13_27 + freeTime.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
            }
            request.addConfirmationMessage(0L, CONSTANTS.freePrefix() + (String)var13_25, "FREE-TIME", ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeHighPriority", "High priority free time"), ORD_UNITIME);
        }
        HashSet<String> fixedCourses = new HashSet<String>();
        if (server instanceof DatabaseServer) {
            singleSections = new HashMap<Serializable, XCourseId>();
            for (XRequest xRequest : original.getRequests()) {
                if (xRequest.isAlternative() || !(xRequest instanceof XCourseRequest)) continue;
                cr = (XCourseRequest)xRequest;
                for (XCourseId xCourseId : cr.getCourseIds()) {
                    offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId(), helper.getHibSession());
                    if (offering == null || ((BaseInstructionalOffering)offering).getInstrOfferingConfigs().size() != 1) continue;
                    for (SchedulingSubpart schedulingSubpart : ((BaseInstructionalOffering)offering).getInstrOfferingConfigs().iterator().next().getSchedulingSubparts()) {
                        Class_ clazz;
                        if (schedulingSubpart.getClasses().size() != 1 || (clazz = schedulingSubpart.getClasses().iterator().next()).getCommittedAssignment() == null) continue;
                        TimeLocation time = clazz.getCommittedAssignment().getTimeLocation();
                        for (Object other : singleSections.keySet()) {
                            if (!((BaseClass_)other).getCommittedAssignment().getTimeLocation().hasIntersection(time) || clazz.isToIgnoreStudentConflictsWith((Class_)other)) continue;
                            request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", xCourseId.getCourseName()).replace("{other}", ((XCourseId)singleSections.get(other)).getCourseName()), ORD_UNITIME);
                        }
                        if (cr.getCourseIds().size() != 1) continue;
                        singleSections.put(clazz, xCourseId);
                    }
                }
            }
            rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
            if (rule != null) {
                for (XRequest r : original.getRequests()) {
                    if (!(r instanceof XCourseRequest)) continue;
                    XCourseRequest xCourseRequest = (XCourseRequest)r;
                    for (XCourseId course : xCourseRequest.getCourseIds()) {
                        if (((XSchedulingRule)rule).matchesCourse(course, helper.getHibSession())) continue;
                        request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", ((XSchedulingRule)rule).getRuleName()).replace("{course}", course.getCourseName()), ORD_UNITIME);
                        rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                        if (rp == null) continue;
                        rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                    }
                }
            } else {
                String string = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
                if (string != null && !string.isEmpty()) {
                    if (new Query(string).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                        cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                        String string4 = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                        for (XRequest r : original.getRequests()) {
                            if (!(r instanceof XCourseRequest)) continue;
                            cr = (XCourseRequest)r;
                            for (XCourseId course : ((XCourseRequest)cr).getCourseIds()) {
                                if (cn != null && !((String)cn).isEmpty() && !course.getCourseName().matches((String)cn)) {
                                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                    CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                    if (rp == null) continue;
                                    rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                                    continue;
                                }
                                if (string4 == null) continue;
                                boolean hasMatchingConfig = false;
                                offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), helper.getHibSession());
                                if (offering != null) {
                                    for (InstrOfferingConfig instrOfferingConfig : ((BaseInstructionalOffering)offering).getInstrOfferingConfigs()) {
                                        configIm = instrOfferingConfig.getEffectiveInstructionalMethod();
                                        if (string4.isEmpty()) {
                                            if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                            hasMatchingConfig = true;
                                            continue;
                                        }
                                        if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string4)) continue;
                                        hasMatchingConfig = true;
                                    }
                                }
                                if (hasMatchingConfig) continue;
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                if (rp == null) continue;
                                ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                            }
                        }
                    } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                        cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                        String string5 = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                        for (XRequest r : original.getRequests()) {
                            if (!(r instanceof XCourseRequest)) continue;
                            cr = (XCourseRequest)r;
                            for (XCourseId course : ((XCourseRequest)cr).getCourseIds()) {
                                if (cn != null && !((String)cn).isEmpty() && course.getCourseName().matches((String)cn)) {
                                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                    CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                    if (rp == null) continue;
                                    rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                                    continue;
                                }
                                if (string5 == null) continue;
                                boolean hasMatchingConfig = false;
                                offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), helper.getHibSession());
                                if (offering != null) {
                                    for (InstrOfferingConfig instrOfferingConfig : ((BaseInstructionalOffering)offering).getInstrOfferingConfigs()) {
                                        configIm = instrOfferingConfig.getEffectiveInstructionalMethod();
                                        if (string5.isEmpty()) {
                                            if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                            hasMatchingConfig = true;
                                            continue;
                                        }
                                        if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string5)) continue;
                                        hasMatchingConfig = true;
                                    }
                                }
                                if (hasMatchingConfig) continue;
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                if (rp == null) continue;
                                ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                            }
                        }
                    }
                }
            }
        } else {
            singleSections = new HashMap();
            for (XRequest xRequest : original.getRequests()) {
                if (xRequest.isAlternative() || !(xRequest instanceof XCourseRequest)) continue;
                cr = (XCourseRequest)xRequest;
                for (XCourseId xCourseId : cr.getCourseIds()) {
                    offering = server.getOffering(xCourseId.getOfferingId());
                    if (offering != null && (((XOffering)offering).hasIndividualReservation(original, xCourseId) || ((XOffering)offering).hasGroupReservation(original, xCourseId))) {
                        fixedCourses.add(xCourseId.getCourseName());
                    }
                    if (offering != null && ((XOffering)offering).getConfigs().size() == 1) {
                        for (XSubpart xSubpart : ((XOffering)offering).getConfigs().get(0).getSubparts()) {
                            if (xSubpart.getSections().size() != 1) continue;
                            XSection section = xSubpart.getSections().get(0);
                            for (XSection other : singleSections.keySet()) {
                                if (!section.isOverlapping(((XOffering)offering).getDistributions(), other)) continue;
                                request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", xCourseId.getCourseName()).replace("{other}", ((XCourseId)singleSections.get(other)).getCourseName()), ORD_UNITIME);
                            }
                            if (cr.getCourseIds().size() != 1) continue;
                            singleSections.put(section, xCourseId);
                        }
                    }
                    if (!((XOffering)offering).hasInconsistentRequirements(original, cr, xCourseId, server.getAcademicSession())) continue;
                    request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "STUD_PREF", ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", xCourseId.getCourseName()), ORD_UNITIME);
                }
            }
            rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
            if (rule != null) {
                for (XRequest r : original.getRequests()) {
                    if (!(r instanceof XCourseRequest)) continue;
                    XCourseRequest xCourseRequest = (XCourseRequest)r;
                    for (XCourseId course : xCourseRequest.getCourseIds()) {
                        if (((XSchedulingRule)rule).matchesCourse(course, server)) continue;
                        request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", ((XSchedulingRule)rule).getRuleName()).replace("{course}", course.getCourseName()), ORD_UNITIME);
                        rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                        if (rp == null) continue;
                        rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                    }
                }
            } else {
                String string = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
                if (string != null && !string.isEmpty()) {
                    if (new Query(string).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                        cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                        String string6 = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                        for (XRequest r : original.getRequests()) {
                            if (!(r instanceof XCourseRequest)) continue;
                            cr = (XCourseRequest)r;
                            for (XCourseId course : ((XCourseRequest)cr).getCourseIds()) {
                                if (cn != null && !((String)cn).isEmpty() && !course.getCourseName().matches((String)cn)) {
                                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                    CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                    if (rp == null) continue;
                                    rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                                    continue;
                                }
                                if (string6 == null) continue;
                                boolean hasMatchingConfig = false;
                                offering = server.getOffering(course.getOfferingId());
                                if (offering != null) {
                                    for (XConfig xConfig : ((XOffering)offering).getConfigs()) {
                                        if (string6.isEmpty()) {
                                            if (xConfig.getInstructionalMethod() != null && xConfig.getInstructionalMethod().getReference() != null && !xConfig.getInstructionalMethod().getReference().isEmpty()) continue;
                                            hasMatchingConfig = true;
                                            continue;
                                        }
                                        if (xConfig.getInstructionalMethod() == null || xConfig.getInstructionalMethod().getReference() == null || !xConfig.getInstructionalMethod().getReference().matches(string6)) continue;
                                        hasMatchingConfig = true;
                                    }
                                }
                                if (hasMatchingConfig) continue;
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                if (rp == null) continue;
                                ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                            }
                        }
                    } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                        cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                        String string7 = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                        for (XRequest r : original.getRequests()) {
                            if (!(r instanceof XCourseRequest)) continue;
                            cr = (XCourseRequest)r;
                            for (XCourseId course : ((XCourseRequest)cr).getCourseIds()) {
                                if (cn != null && !((String)cn).isEmpty() && course.getCourseName().matches((String)cn)) {
                                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                    CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                    if (rp == null) continue;
                                    rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                                    continue;
                                }
                                if (string7 == null) continue;
                                boolean hasMatchingConfig = false;
                                offering = server.getOffering(course.getOfferingId());
                                if (offering != null) {
                                    for (XConfig xConfig : ((XOffering)offering).getConfigs()) {
                                        if (string7.isEmpty()) {
                                            if (xConfig.getInstructionalMethod() != null && xConfig.getInstructionalMethod().getReference() != null && !xConfig.getInstructionalMethod().getReference().isEmpty()) continue;
                                            hasMatchingConfig = true;
                                            continue;
                                        }
                                        if (xConfig.getInstructionalMethod() == null || xConfig.getInstructionalMethod().getReference() == null || !xConfig.getInstructionalMethod().getReference().matches(string7)) continue;
                                        hasMatchingConfig = true;
                                    }
                                }
                                if (hasMatchingConfig) continue;
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                if (rp == null) continue;
                                ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                            }
                        }
                    }
                }
            }
        }
        HashMap<String, CourseRequestInterface.RequestedCourse> rcs = new HashMap<String, CourseRequestInterface.RequestedCourse>();
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            if (!request2.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse requestedCourse : request2.getRequestedCourse()) {
                if (requestedCourse.getOverrideExternalId() == null) continue;
                rcs.put(requestedCourse.getOverrideExternalId(), requestedCourse);
            }
        }
        for (CourseRequestInterface.Request request3 : request.getAlternatives()) {
            if (!request3.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse requestedCourse : request3.getRequestedCourse()) {
                if (requestedCourse.getOverrideExternalId() == null) continue;
                rcs.put(requestedCourse.getOverrideExternalId(), requestedCourse);
            }
        }
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float f = otherCredits[0];
        block42: for (CourseRequestInterface.Request request4 : request.getCourses()) {
            if (!request4.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                f += rc.getCreditMin().floatValue();
                continue block42;
            }
        }
        if (minCreditLimit != null && f > 0.0f && f < Float.parseFloat(minCreditLimit) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(f))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (f > 0.0f && request.getMaxCreditOverrideStatus() == null) {
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
        }
        if (rcs.isEmpty() && !request.hasMaxCreditOverride()) {
            return;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo academicSessionInfo = server.getAcademicSession();
            String string = this.getBannerTerm(academicSessionInfo);
            String campus = this.getBannerCampus(academicSessionInfo);
            resource.addQueryParameter("term", string);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(original));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(string);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            helper.getAction().addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
            Float maxCredit = null;
            if (status != null && status.data != null) {
                maxCredit = ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit;
                request.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
            }
            if (maxCredit == null) {
                maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            String creditNote = null;
            if (status != null && status.data != null && ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests != null) {
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    Object rc;
                    if (r.regRequestId == null) continue;
                    if (r.regRequestId.equals(request.getMaxCreditOverrideExternalId())) {
                        request.setMaxCreditOverrideStatus(this.status(r, true));
                        if (r.maxCredit != null) {
                            request.setMaxCreditOverride(r.maxCredit);
                        }
                        creditNote = SpecialRegistrationHelper.note(r, true);
                        request.setRequestorNote(SpecialRegistrationHelper.maxCreditRequestorNotes(r));
                        request.setRequestId(r.regRequestId);
                        for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.prereg.requestorNoteSuggestions", "").split("[\r\n]+")) {
                            if (suggestion.isEmpty()) continue;
                            request.addRequestorNoteSuggestion(suggestion);
                        }
                    }
                    if ((rc = (CourseRequestInterface.RequestedCourse)rcs.get(r.regRequestId)) == null) continue;
                    if (((CourseRequestInterface.RequestedCourse)rc).getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) {
                        ((CourseRequestInterface.RequestedCourse)rc).setStatus(this.status(r, false));
                    }
                    if (r.changes != null) {
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (ch.errors == null || ch.courseNbr == null || ch.subject == null || ch.status == null) continue;
                            for (SpecialRegistrationInterface.ChangeError er : ch.errors) {
                                if (this.isOverrideNotNeed(ch)) {
                                    request.addConfirmationMessage(((CourseRequestInterface.RequestedCourse)rc).getCourseId(), ((CourseRequestInterface.RequestedCourse)rc).getCourseName(), er.code, "Not Needed " + er.message, this.status(ch), ORD_BANNER);
                                    continue;
                                }
                                if (ch.status == SpecialRegistrationInterface.ChangeStatus.denied && !this.isOverrideNotNeed(ch)) {
                                    request.addConfirmationError(((CourseRequestInterface.RequestedCourse)rc).getCourseId(), ((CourseRequestInterface.RequestedCourse)rc).getCourseName(), er.code, "Denied " + er.message, this.status(ch), ORD_BANNER);
                                    if (fixedCourses.contains(((CourseRequestInterface.RequestedCourse)rc).getCourseName())) continue;
                                    request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                                    continue;
                                }
                                if (ch.status == SpecialRegistrationInterface.ChangeStatus.approved || ch.status == SpecialRegistrationInterface.ChangeStatus.cancelled) continue;
                                request.addConfirmationMessage(((CourseRequestInterface.RequestedCourse)rc).getCourseId(), ((CourseRequestInterface.RequestedCourse)rc).getCourseName(), er.code, er.message, this.status(ch), ORD_BANNER);
                            }
                        }
                    }
                    ((CourseRequestInterface.RequestedCourse)rc).setStatusNote(SpecialRegistrationHelper.note(r, false));
                    ((CourseRequestInterface.RequestedCourse)rc).setRequestorNote(SpecialRegistrationHelper.requestorNotes(r, ((CourseRequestInterface.RequestedCourse)rc).getCourseName()));
                    ((CourseRequestInterface.RequestedCourse)rc).setRequestId(r.regRequestId);
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.prereg.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        ((CourseRequestInterface.RequestedCourse)rc).addRequestorNoteSuggestion(suggestion);
                    }
                }
            }
            Set<Long> set = original.getAdvisorWaitListedCourseIds(server);
            String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
            if (maxCredit.floatValue() < request.getCredit(set) + otherCredits[1]) {
                for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue() - otherCredits[1])) {
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set) + otherCredits[1]))), null, ORD_CREDIT);
                }
                request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set) + otherCredits[1]))));
                if (request.getMaxCreditOverrideStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED && request.getMaxCreditOverride() != null) {
                    if (!request.hasErrorMessage()) {
                        request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set) + otherCredits[1]))).replace("{maxCreditDenied}", sCreditFormat.format(request.getMaxCreditOverride())));
                    }
                } else if (maxCreditLimitStr != null && Float.parseFloat(maxCreditLimitStr) < request.getCredit(set) + otherCredits[1]) {
                    float maxCreditLimit = Float.parseFloat(maxCreditLimitStr);
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                    if (!request.hasErrorMessage()) {
                        request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCreditLimit))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set) + otherCredits[1]))));
                    }
                }
                if (creditNote != null && !creditNote.isEmpty()) {
                    request.setCreditNote(creditNote);
                }
            }
        }
        catch (SectioningException sectioningException) {
            helper.getAction().setApiException(sectioningException.getMessage());
            throw sectioningException;
        }
        catch (Exception exception) {
            helper.getAction().setApiException(exception.getMessage() == null ? "Null" : exception.getMessage());
            sLog.error((Object)exception.getMessage(), (Throwable)exception);
            throw new SectioningException(exception.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean isValidationEnabled(org.unitime.timetable.model.Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean hasOverride(org.unitime.timetable.model.Student student) {
        if (student.getOverrideExternalId() != null) {
            return true;
        }
        if (student.getMaxCredit() == null) {
            return true;
        }
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        if (student == null || !this.hasOverride(student)) {
            return false;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? new AcademicSessionInfo(student.getSession()) : server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            action.addOptionBuilder().setKey("term").setValue(term);
            action.addOptionBuilder().setKey("campus").setValue(campus);
            action.addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            action.setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            action.addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
            boolean changed = false;
            for (CourseDemand cd : student.getCourseDemands()) {
                for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                    if (cr.getOverrideExternalId() == null) continue;
                    SpecialRegistrationInterface.SpecialRegistration req = null;
                    for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                        if (!cr.getOverrideExternalId().equals(r.regRequestId)) continue;
                        req = r;
                        break;
                    }
                    if (req == null) {
                        if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                        cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        helper.getHibSession().merge((Object)cr);
                        changed = true;
                        continue;
                    }
                    Integer oldStatus = cr.getOverrideStatus();
                    switch (this.status(req, false)) {
                        case OVERRIDE_REJECTED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                            break;
                        }
                        case OVERRIDE_NOT_NEEDED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED);
                        }
                    }
                    if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                    helper.getHibSession().merge((Object)cr);
                    changed = true;
                }
            }
            boolean studentChanged = false;
            if (((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit != null && !((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit.equals(student.getMaxCredit())) {
                student.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                studentChanged = true;
            }
            if (student.getOverrideExternalId() != null) {
                SpecialRegistrationInterface.SpecialRegistration req = null;
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (!student.getOverrideExternalId().equals(r.regRequestId)) continue;
                    req = r;
                    break;
                }
                if (req == null) {
                    student.setOverrideExternalId(null);
                    student.setOverrideMaxCredit(null);
                    student.setOverrideStatus(null);
                    student.setOverrideTimeStamp(null);
                    student.setOverrideIntent(null);
                    studentChanged = true;
                } else {
                    Integer oldStatus = student.getOverrideStatus();
                    switch (this.status(req, true)) {
                        case OVERRIDE_REJECTED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                    }
                    if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                        studentChanged = true;
                    }
                }
            }
            if (studentChanged) {
                helper.getHibSession().merge((Object)student);
            }
            if (changed || studentChanged) {
                helper.getHibSession().flush();
            }
            boolean bl = changed || studentChanged;
            return bl;
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean hasNotApprovedCourseRequestOverride(org.unitime.timetable.model.Student student) {
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.APPROVED) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        void var23_34;
        float maxCreditLimit;
        Object err;
        SpecialRegistrationInterface.Change change;
        Course course;
        Object solverServer;
        if (!this.isValidationEnabled(student)) {
            return false;
        }
        boolean studentUpdated = false;
        if (this.hasOverride(student)) {
            studentUpdated = this.updateStudent(server, helper, student, action);
        }
        if (!this.hasNotApprovedCourseRequestOverride(student) && !"true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.forceRevalidation", "false"))) {
            return false;
        }
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        XStudent original = server.getStudent(student.getUniqueId());
        if (original == null) {
            original = new XStudent(student, helper, server.getAcademicSession().getFreeTimePattern(), server.getAcademicSession().getDatePatternFirstDate());
        }
        OnlineSectioningInterface.WaitListMode wlMode = student.getWaitListMode();
        Student s = new Student(student.getUniqueId().longValue());
        s.setExternalId(original.getExternalId());
        s.setName(original.getName());
        s.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        s.setAllowDisabled(original.isAllowDisabled());
        s.setClassFirstDate(original.getClassStartDate());
        s.setClassLastDate(original.getClassEndDate());
        s.setBackToBackPreference(original.getBackToBackPreference());
        s.setModalityPreference(original.getModalityPreference());
        HashSet<XDistribution> distributions = new HashSet<XDistribution>();
        Hashtable preferredSections = new Hashtable();
        HashSet<XCourseId> lcCourses = new HashSet<XCourseId>();
        boolean ignoreLcCourses = this.isIngoreLCRegistrationErrors();
        for (XRequest r : original.getRequests()) {
            Object clonnedCourse3;
            Object section;
            action.addRequest(OnlineSectioningHelper.toProto(r));
            if (r instanceof XFreeTimeRequest) {
                XFreeTimeRequest ft = (XFreeTimeRequest)r;
                new FreeTimeRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), s, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                continue;
            }
            XCourseRequest cr = (XCourseRequest)r;
            XEnrollment enrollment = cr.getEnrollment();
            Iterator courses = new ArrayList<Course>();
            HashSet<Section> sections = new HashSet<Section>();
            for (XCourseId xCourseId : cr.getCourseIds()) {
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null) continue;
                Course clonnedCourse2 = offering.toCourse(xCourseId.getCourseId(), original, server, helper);
                courses.add(clonnedCourse2);
                model.addOffering(clonnedCourse2.getOffering());
                distributions.addAll(offering.getDistributions());
                if (enrollment != null && enrollment.getCourseId().equals(xCourseId.getCourseId())) {
                    for (Long sectionId : enrollment.getSectionIds()) {
                        section = clonnedCourse2.getOffering().getSection(sectionId.longValue());
                        if (section == null) continue;
                        sections.add((Section)section);
                    }
                }
                if (offering == null || !offering.hasLearningCommunityReservation(original, xCourseId)) continue;
                lcCourses.add(xCourseId);
            }
            if (courses.isEmpty()) continue;
            CourseRequest clonnedRequest = new CourseRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), s, courses, cr.isWaitListOrNoSub(wlMode), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
            if (!sections.isEmpty()) {
                preferredSections.put(clonnedRequest, sections);
            }
            for (Object clonnedCourse3 : clonnedRequest.getCourses()) {
                if (enrollment == null || !enrollment.getCourseId().equals(clonnedCourse3.getId())) continue;
                if (clonnedCourse3.getOffering().hasReservations()) {
                    Object reservation22;
                    boolean hasMustUse = false;
                    for (Object reservation22 : clonnedCourse3.getOffering().getReservations()) {
                        if (!reservation22.isApplicable(s) || !reservation22.mustBeUsed()) continue;
                        hasMustUse = true;
                    }
                    OnlineReservation reservation3 = new OnlineReservation(XReservationType.Dummy.ordinal(), -original.getStudentId().longValue(), clonnedCourse3.getOffering(), 1000, false, 1, true, hasMustUse, false, true, true);
                    reservation22 = sections.iterator();
                    while (reservation22.hasNext()) {
                        section = (Section)reservation22.next();
                        reservation3.addSection((Section)section);
                    }
                }
                if (!clonnedCourse3.getOffering().hasRestrictions()) break;
                IndividualRestriction restriction = new IndividualRestriction(-4L, clonnedCourse3.getOffering(), new Long[]{original.getStudentId()});
                for (Section section2 : sections) {
                    restriction.addSection(section2);
                }
            }
            cr.fillChoicesIn(clonnedRequest);
            if (clonnedRequest.getRequiredChoices().isEmpty()) continue;
            boolean bl = false;
            clonnedCourse3 = sections.iterator();
            while (clonnedCourse3.hasNext()) {
                boolean bl2;
                Section section3 = (Section)clonnedCourse3.next();
                clonnedRequest.getRequiredChoices().add(new Choice(section3));
                if (bl2) continue;
                clonnedRequest.getRequiredChoices().add(new Choice(section3.getSubpart().getConfig()));
                bl2 = true;
            }
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkUnavailabilitiesFromOtherSessions", "false"))) {
            if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                GetInfo.fillInUnavailabilitiesFromOtherSessions(s, server, helper);
            } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(s, server, helper);
            }
        }
        float[] otherCredits = new float[]{0.0f, 0.0f};
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkCreditsFromOtherSessions", "false")) && (solverServer = SolverServerImplementation.getInstance()) != null) {
            otherCredits = solverServer.getCreditRangeFromOtherSessions(server.getAcademicSession(), s.getExternalId());
        }
        model.addStudent(s);
        model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
        for (XDistribution link : distributions) {
            if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
            ArrayList<Section> sections = new ArrayList<Section>();
            block34: for (Long sectionId : link.getSectionIds()) {
                for (Offering offering : model.getOfferings()) {
                    Section x = offering.getSection(sectionId.longValue());
                    if (x == null) continue;
                    sections.add(x);
                    continue block34;
                }
            }
            if (sections.size() < 2) continue;
            model.addLinkedSections(linkedClassesMustBeUsed, sections);
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
            for (Request r : s.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                for (Course course2 : cr.getCourses()) {
                    new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course2.getOffering(), -100, true, 1, true, true, true, true, true);
                }
            }
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
            selection.setPreferredSections(new Hashtable());
            selection.setRequiredSections(preferredSections);
        } else {
            selection.setPreferredSections(preferredSections);
            selection.setRequiredSections(new Hashtable());
        }
        selection.setRequiredFreeTimes(new HashSet());
        selection.setRequiredUnassinged(new HashSet());
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, s);
        neighbour.assign((Assignment)assignment, 0L);
        SpecialRegistrationInterface.CheckRestrictionsRequest validationRequest = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        validationRequest.studentId = this.getBannerId(original);
        validationRequest.term = this.getBannerTerm(server.getAcademicSession());
        validationRequest.campus = this.getBannerCampus(server.getAcademicSession());
        validationRequest.mode = this.getSpecialRegistrationApiMode();
        HashMap<Object, Course> crn2course = new HashMap<Object, Course>();
        SpecialRegistrationInterface.CheckRestrictionsResponse validation = null;
        for (Request request : model.variables()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)request;
            Enrollment e = (Enrollment)assignment.getValue((Variable)cr);
            block39: for (Course course3 : cr.getCourses()) {
                if (e != null && course3.equals((Object)e.getCourse())) {
                    for (Section section : e.getSections()) {
                        String crn = this.getCRN(section, course3);
                        crn2course.put(crn, course3);
                        SpecialRegistrationHelper.addCrn(validationRequest, crn);
                    }
                    continue;
                }
                for (Enrollment x : cr.values((Assignment)assignment)) {
                    if (!course3.equals((Object)x.getCourse())) continue;
                    for (Object section : x.getSections()) {
                        String crn = this.getCRN((Section)section, course3);
                        crn2course.put(crn, course3);
                        SpecialRegistrationHelper.addAltCrn(validationRequest, crn);
                    }
                    continue block39;
                }
                for (Object config : course3.getOffering().getConfigs()) {
                    Enrollment x;
                    Object section;
                    if (cr.isNotAllowed(course3, (Config)config) || (x = this.firstEnrollment(cr, (Assignment<Request, Enrollment>)assignment, course3, (Config)config, new HashSet<Section>(), 0)) == null) continue;
                    section = x.getSections().iterator();
                    while (section.hasNext()) {
                        Section section4 = (Section)section.next();
                        String crn = this.getCRN(section4, course3);
                        crn2course.put(crn, course3);
                        SpecialRegistrationHelper.addAltCrn(validationRequest, crn);
                    }
                    continue block39;
                }
            }
        }
        if (validationRequest.changes == null) {
            validationRequest.changes = new SpecialRegistrationInterface.RestrictionsCheckRequest();
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Validation Request: " + gson.toJson((Object)validationRequest));
            }
            action.addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)validationRequest));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(validationRequest));
            action.setApiPostTime(System.currentTimeMillis() - t1);
            validation = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Validation Response: " + gson.toJson((Object)validation));
            }
            action.addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)validation));
            if (SpecialRegistrationInterface.ResponseStatus.success != validation.status) {
                throw new SectioningException((String)(validation.message == null || validation.message.isEmpty() ? "Failed to check student eligibility (" + validation.status + ")." : validation.message));
            }
        }
        catch (SectioningException sectioningException) {
            action.setApiException(sectioningException.getMessage());
            throw sectioningException;
        }
        catch (Exception exception) {
            action.setApiException(exception.getMessage());
            sLog.error((Object)exception.getMessage(), (Throwable)exception);
            throw new SectioningException(exception.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        Float f = student.getMaxCredit();
        if (f == null) {
            Float f2 = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        SpecialRegistrationInterface.SpecialRegistrationRequest submitRequest = new SpecialRegistrationInterface.SpecialRegistrationRequest();
        submitRequest.studentId = this.getBannerId(original);
        submitRequest.pgrmcode = SpecialRegistrationHelper.getProgramCode(original);
        submitRequest.studentCampus = SpecialRegistrationHelper.getCampusCode(original);
        submitRequest.term = this.getBannerTerm(server.getAcademicSession());
        submitRequest.campus = this.getBannerCampus(server.getAcademicSession());
        submitRequest.mode = this.getSpecialRegistrationApiMode();
        submitRequest.changes = new ArrayList();
        if (helper.getUser() != null) {
            submitRequest.requestorId = this.getRequestorId(helper.getUser());
            submitRequest.requestorRole = this.getRequestorType(helper.getUser(), original);
        }
        if (validation.outJson != null && validation.outJson.problems != null) {
            block45: for (SpecialRegistrationInterface.Problem problem : validation.outJson.problems) {
                if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (Course)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(new XCourseId(course))) continue;
                change = null;
                for (SpecialRegistrationInterface.Change ch : submitRequest.changes) {
                    if (!ch.subject.equals(course.getSubjectArea()) || !ch.courseNbr.equals(course.getCourseNumber())) continue;
                    change = ch;
                    break;
                }
                if (change == null) {
                    change = new SpecialRegistrationInterface.Change();
                    change.setCourse(course.getSubjectArea(), course.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                    change.crn = "";
                    change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    submitRequest.changes.add(change);
                } else {
                    for (SpecialRegistrationInterface.ChangeError err2 : change.errors) {
                        if (!problem.code.equals(err2.code)) continue;
                        continue block45;
                    }
                }
                err = new SpecialRegistrationInterface.ChangeError();
                ((SpecialRegistrationInterface.ChangeError)err).code = problem.code;
                ((SpecialRegistrationInterface.ChangeError)err).message = problem.message;
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf("this section") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replace("this section", course.getName());
                }
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf(" (CRN ") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                }
                change.errors.add((SpecialRegistrationInterface.ChangeError)err);
            }
        }
        if (validation.outJsonAlternatives != null && validation.outJsonAlternatives.problems != null) {
            block48: for (SpecialRegistrationInterface.Problem problem : validation.outJsonAlternatives.problems) {
                if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (Course)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(new XCourseId(course))) continue;
                change = null;
                for (SpecialRegistrationInterface.Change ch : submitRequest.changes) {
                    if (!ch.subject.equals(course.getSubjectArea()) || !ch.courseNbr.equals(course.getCourseNumber())) continue;
                    change = ch;
                    break;
                }
                if (change == null) {
                    change = new SpecialRegistrationInterface.Change();
                    change.setCourse(course.getSubjectArea(), course.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                    change.crn = "";
                    change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    submitRequest.changes.add(change);
                } else {
                    for (SpecialRegistrationInterface.ChangeError err2 : change.errors) {
                        if (!problem.code.equals(err2.code)) continue;
                        continue block48;
                    }
                }
                err = new SpecialRegistrationInterface.ChangeError();
                ((SpecialRegistrationInterface.ChangeError)err).code = problem.code;
                ((SpecialRegistrationInterface.ChangeError)err).message = problem.message;
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf("this section") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replace("this section", course.getName());
                }
                if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf(" (CRN ") >= 0) {
                    ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                }
                change.errors.add((SpecialRegistrationInterface.ChangeError)err);
            }
        }
        float total = otherCredits[1];
        ArrayList<Float> credits = new ArrayList<Float>();
        int nrCourses = 0;
        submitRequest.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        submitRequest.alternateCourseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        Set<Long> advisorWaitListedCourseIds = original.getAdvisorWaitListedCourseIds(server);
        for (XRequest r : original.getRequests()) {
            SpecialRegistrationInterface.CourseCredit cc = null;
            if (r instanceof XCourseRequest) {
                XCourseRequest cr = (XCourseRequest)r;
                Float credit = null;
                for (XCourseId cid : cr.getCourseIds()) {
                    XCourse course4 = server.getCourse(cid.getCourseId());
                    if (course4 == null) continue;
                    if (cc == null) {
                        cc = new SpecialRegistrationInterface.CourseCredit();
                        cc.setCourse(course4.getSubjectArea(), course4.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                        cc.title = course4.getTitle();
                        cc.creditHrs = Float.valueOf(course4.hasCredit() ? course4.getMinCredit().floatValue() : 0.0f);
                    } else {
                        if (cc.alternatives == null) {
                            cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                        }
                        SpecialRegistrationInterface.CourseCredit acc = new SpecialRegistrationInterface.CourseCredit();
                        acc.setCourse(course4.getSubjectArea(), course4.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                        acc.title = course4.getTitle();
                        acc.creditHrs = Float.valueOf(course4.hasCredit() ? course4.getMinCredit().floatValue() : 0.0f);
                        cc.alternatives.add(acc);
                    }
                    if (!course4.hasCredit() || credit != null && !(credit.floatValue() < course4.getMinCredit().floatValue())) continue;
                    credit = course4.getMinCredit();
                }
                if (credit != null) {
                    if (!r.isAlternative() && cr.isWaitListOrNoSub(wlMode, advisorWaitListedCourseIds)) {
                        total += credit.floatValue();
                    } else {
                        credits.add(credit);
                        if (!r.isAlternative()) {
                            ++nrCourses;
                        }
                    }
                }
            }
            if (cc == null) continue;
            if (r.isAlternative()) {
                submitRequest.alternateCourseCreditHrs.add(cc);
                continue;
            }
            submitRequest.courseCreditHrs.add(cc);
        }
        Collections.sort(credits);
        for (int i = 0; i < nrCourses; ++i) {
            total += ((Float)credits.get(credits.size() - i - 1)).floatValue();
        }
        String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
        if (maxCreditLimitStr != null && total > (maxCreditLimit = Float.parseFloat(maxCreditLimitStr))) {
            total = maxCreditLimit;
        }
        if (var23_34.floatValue() < total) {
            submitRequest.maxCredit = Float.valueOf(total);
        }
        SpecialRegistrationInterface.SpecialRegistrationResponseList response = null;
        resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Submit Request: " + gson.toJson((Object)submitRequest));
            }
            action.addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)submitRequest));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(submitRequest));
            action.setApiPostTime(action.getApiPostTime() + System.currentTimeMillis() - t1);
            response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Submit Response: " + gson.toJson((Object)response));
            }
            action.addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                throw new SectioningException((String)(response.message == null || response.message.isEmpty() ? "Failed to request overrides (" + response.status + ")." : response.message));
            }
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        boolean changed = false;
        for (CourseDemand cd : student.getCourseDemands()) {
            block55: for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (response != null && response.data != null) {
                    for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                        if (r.changes == null) continue;
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (!cr.getCourseOffering().getSubjectAreaAbbv().equals(ch.subject) || !cr.getCourseOffering().getCourseNbr().equals(ch.courseNbr)) continue;
                            Integer oldStatus = cr.getOverrideStatus();
                            switch (this.status(r, false)) {
                                case OVERRIDE_REJECTED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED);
                                }
                            }
                            if (oldStatus == null || !oldStatus.equals(cr.getOverrideStatus())) {
                                changed = true;
                            }
                            if (cr.getOverrideExternalId() == null || !cr.getOverrideExternalId().equals(r.regRequestId)) {
                                changed = true;
                            }
                            cr.setOverrideExternalId(r.regRequestId);
                            cr.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            cr.setCourseRequestOverrideIntent(CourseRequest.CourseRequestOverrideIntent.REGISTER);
                            helper.getHibSession().merge((Object)cr);
                            continue block55;
                        }
                    }
                }
                if (cr.getOverrideExternalId() == null && cr.getOverrideStatus() == null) continue;
                cr.setOverrideExternalId(null);
                cr.setOverrideStatus(null);
                cr.setOverrideTimeStamp(null);
                cr.setOverrideIntent(null);
                helper.getHibSession().merge((Object)cr);
                changed = true;
            }
        }
        boolean studentChanged = false;
        if (submitRequest.maxCredit != null) {
            for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                if (r.maxCredit == null) continue;
                Integer oldStatus = student.getOverrideStatus();
                switch (this.status(r, true)) {
                    case OVERRIDE_REJECTED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                        break;
                    }
                    case OVERRIDE_APPROVED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                        break;
                    }
                    case OVERRIDE_CANCELLED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        break;
                    }
                    case OVERRIDE_PENDING: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                    }
                }
                if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                    studentChanged = true;
                }
                if (student.getOverrideMaxCredit() == null || !student.getOverrideMaxCredit().equals(r.maxCredit)) {
                    studentChanged = true;
                }
                student.setOverrideMaxCredit(r.maxCredit);
                if (student.getOverrideExternalId() == null || !student.getOverrideExternalId().equals(r.regRequestId)) {
                    studentChanged = true;
                }
                student.setOverrideExternalId(r.regRequestId);
                student.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                student.setMaxCreditOverrideIntent(CourseRequest.CourseRequestOverrideIntent.REGISTER);
                break;
            }
        } else if (student.getOverrideExternalId() != null || student.getOverrideMaxCredit() != null) {
            student.setOverrideExternalId(null);
            student.setOverrideMaxCredit(null);
            student.setOverrideStatus(null);
            student.setOverrideTimeStamp(null);
            student.setOverrideIntent(null);
            studentChanged = true;
        }
        if (studentChanged) {
            helper.getHibSession().merge((Object)student);
        }
        if (changed) {
            helper.getHibSession().flush();
        }
        if (changed || studentChanged) {
            helper.getHibSession().flush();
        }
        return changed || studentChanged || studentUpdated;
    }

    public boolean isDisableRegistrationWhenNotEligible() {
        return "true".equals(ApplicationProperties.getProperty("purdue.specreg.disableRegistrationWhenNotEligible", "true"));
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, org.unitime.timetable.model.Student student) throws SectioningException {
        if (student == null) {
            return;
        }
        if (!this.isValidationEnabled(student)) {
            return;
        }
        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_CHANGE_NOTE, this.isCanChangeNote());
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            return;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + eligibility.status + ")." : eligibility.message));
            }
            if ((eligibility.data == null || ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligible == null || !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligible.booleanValue()) && this.isDisableRegistrationWhenNotEligible()) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, helper.isAdmin());
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                Object m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = (String)m + "\n" + p.message;
                }
                if (m != null) {
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck((String)m));
                }
            }
            String pin = null;
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                pin = ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN;
            }
            Float maxCredit = null;
            if (eligibility.maxCredit != null && eligibility.maxCredit.floatValue() > 0.0f) {
                maxCredit = eligibility.maxCredit;
                check.setMaxCredit(eligibility.maxCredit);
            }
            if (maxCredit != null && !maxCredit.equals(student.getMaxCredit()) || pin != null && !pin.equals(student.getPin())) {
                XStudent xs;
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
                if (maxCredit != null) {
                    dbStudent.setMaxCredit(maxCredit);
                }
                if (pin != null) {
                    dbStudent.setPin(pin);
                }
                helper.getHibSession().merge((Object)dbStudent);
                helper.getHibSession().flush();
                if (!(server instanceof DatabaseServer) && (xs = server.getStudent(student.getUniqueId())) != null) {
                    if (maxCredit != null) {
                        xs.setMaxCredit(maxCredit);
                    }
                    if (pin != null) {
                        xs.setPin(pin);
                    }
                    server.update(xs, false);
                }
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected void checkStudentStatuses(OnlineSectioningServer server, OnlineSectioningHelper helper, Map<String, org.unitime.timetable.model.Student> id2student, List<Long> reloadIds, int batchNumber) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? null : server.getAcademicSession();
            Object studentIds = null;
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<String, org.unitime.timetable.model.Student> e : id2student.entrySet()) {
                if (session == null) {
                    session = new AcademicSessionInfo(e.getValue().getSession());
                }
                studentIds = studentIds == null ? e.getKey() : (String)studentIds + "," + e.getKey();
                ids.add(e.getKey());
            }
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentIds", (String)studentIds);
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (action != null) {
                action.addOptionBuilder().setKey("term").setValue(term);
                action.addOptionBuilder().setKey("campus").setValue(campus);
                action.addOptionBuilder().setKey("studentIds-" + batchNumber).setValue((String)studentIds);
            }
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (action != null) {
                action.setApiGetTime(action.getApiGetTime() + System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            if (action != null) {
                action.addOptionBuilder().setKey("response-" + batchNumber).setValue(gson.toJson((Object)response));
            }
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                throw new SectioningException((String)(response.message == null || response.message.isEmpty() ? "Failed to check student statuses (" + response.status + ")." : response.message));
            }
            if (response.data != null && ((SpecialRegistrationInterface.SpecialRegistrationMultipleStatus)response.data).students != null) {
                int index = 0;
                for (SpecialRegistrationInterface.SpecialRegistrationStatus status : ((SpecialRegistrationInterface.SpecialRegistrationMultipleStatus)response.data).students) {
                    String studentId = status.studentId;
                    if (studentId == null && status.requests != null) {
                        for (SpecialRegistrationInterface.SpecialRegistration req : status.requests) {
                            if (req.studentId == null) continue;
                            studentId = req.studentId;
                            break;
                        }
                    }
                    if (studentId == null) {
                        studentId = (String)ids.get(index);
                    }
                    ++index;
                    org.unitime.timetable.model.Student student = id2student.get(studentId);
                    if (student == null) continue;
                    boolean changed = false;
                    for (CourseDemand cd : student.getCourseDemands()) {
                        for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                            if (cr.getOverrideExternalId() == null) continue;
                            SpecialRegistrationInterface.SpecialRegistration req = null;
                            for (SpecialRegistrationInterface.SpecialRegistration r : status.requests) {
                                if (!cr.getOverrideExternalId().equals(r.regRequestId)) continue;
                                req = r;
                                break;
                            }
                            if (req == null) {
                                if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                helper.getHibSession().merge((Object)cr);
                                changed = true;
                                continue;
                            }
                            Integer oldStatus = cr.getOverrideStatus();
                            switch (this.status(req, false)) {
                                case OVERRIDE_REJECTED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED);
                                }
                            }
                            if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                            helper.getHibSession().merge((Object)cr);
                            changed = true;
                        }
                    }
                    boolean studentChanged = false;
                    if (status.maxCredit != null && !status.maxCredit.equals(student.getMaxCredit())) {
                        student.setMaxCredit(status.maxCredit);
                        studentChanged = true;
                    }
                    if (student.getOverrideExternalId() != null) {
                        SpecialRegistrationInterface.SpecialRegistration req = null;
                        for (SpecialRegistrationInterface.SpecialRegistration r : status.requests) {
                            if (!student.getOverrideExternalId().equals(r.regRequestId)) continue;
                            req = r;
                            break;
                        }
                        if (req == null) {
                            student.setOverrideExternalId(null);
                            student.setOverrideMaxCredit(null);
                            student.setOverrideStatus(null);
                            student.setOverrideTimeStamp(null);
                            student.setOverrideIntent(null);
                            studentChanged = true;
                        } else {
                            Integer oldStatus = student.getOverrideStatus();
                            switch (this.status(req, true)) {
                                case OVERRIDE_REJECTED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                                studentChanged = true;
                            }
                        }
                    }
                    if (studentChanged) {
                        helper.getHibSession().merge((Object)student);
                    }
                    if (!changed && !studentChanged) continue;
                    reloadIds.add(student.getUniqueId());
                }
            }
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<org.unitime.timetable.model.Student> students) throws SectioningException {
        HashMap<String, org.unitime.timetable.model.Student> id2student = new HashMap<String, org.unitime.timetable.model.Student>();
        ArrayList<Long> reloadIds = new ArrayList<Long>();
        int batchNumber = 1;
        for (int i = 0; i < students.size(); ++i) {
            org.unitime.timetable.model.Student student = students.get(i);
            if (student == null || !this.hasOverride(student) || !this.isValidationEnabled(student)) continue;
            String id = this.getBannerId(student);
            id2student.put(id, student);
            if (id2student.size() < 100) continue;
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
            id2student.clear();
        }
        if (!id2student.isEmpty()) {
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
        }
        if (!reloadIds.isEmpty()) {
            helper.getHibSession().flush();
        }
        if (!reloadIds.isEmpty() && server != null && !(server instanceof DatabaseServer)) {
            server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
        }
        return reloadIds;
    }

    protected boolean isAdvisorValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, String status) {
        if (status == null) {
            status = student.getStatus();
        } else if (status.isEmpty()) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval) || dbStatus.hasOption(StudentSectioningStatus.Option.specreg);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateAdvisorRecommendations(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.AdvisingStudentDetails details, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        void var38_82;
        void var38_78;
        void var38_77;
        void var38_76;
        void var38_75;
        void var34_53;
        XCourseRequest cr;
        XStudent original;
        XStudent xStudent = original = details.getStudentId() == null ? null : server.getStudent(details.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isAdvisorValidationEnabled(server, helper, original, details.getStatus() == null ? null : details.getStatus().getReference())) {
            return;
        }
        CourseRequestInterface request = details.getRequest();
        Integer CONF_UNITIME = 0;
        Integer CONF_BANNER = 1;
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        float[] otherCredits = new float[]{0.0f, 0.0f};
        if (details.hasOtherSessionRecommendations() && "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkCreditsFromOtherSessions", "false"))) {
            for (Map.Entry<String, CourseRequestInterface> e : details.getOtherSessionRecommendations().entrySet()) {
                float[] creds = e.getValue().getCreditRange(null);
                otherCredits[0] = otherCredits[0] + creds[0];
                otherCredits[1] = otherCredits[1] + creds[1];
            }
        }
        Student student = new Student(request.getStudentId().longValue());
        student.setExternalId(original.getExternalId());
        student.setName(original.getName());
        student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        student.setAllowDisabled(original.isAllowDisabled());
        student.setClassFirstDate(original.getClassStartDate());
        student.setClassLastDate(original.getClassEndDate());
        student.setBackToBackPreference(original.getBackToBackPreference());
        student.setModalityPreference(original.getModalityPreference());
        HashMap<Long, Section> classTable = new HashMap<Long, Section>();
        HashSet<XDistribution> distributions = new HashSet<XDistribution>();
        Hashtable preferredSections = new Hashtable();
        boolean hasAssignment = false;
        for (XRequest reqest : original.getRequests()) {
            if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
            hasAssignment = true;
            break;
        }
        for (CourseRequestInterface.Request c : request.getCourses()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, false, classTable, distributions, hasAssignment, true, helper);
        }
        for (CourseRequestInterface.Request c : request.getAlternatives()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, false, classTable, distributions, hasAssignment, true, helper);
        }
        HashSet<XCourseId> lcCourses = new HashSet<XCourseId>();
        HashSet<XCourseId> fixedCourses = new HashSet<XCourseId>();
        boolean ignoreLcCourses = this.isIngoreLCRegistrationErrors();
        for (XRequest r : original.getRequests()) {
            if (!(r instanceof XCourseRequest)) continue;
            cr = (XCourseRequest)r;
            XEnrollment en = cr.getEnrollment();
            if (en != null) {
                for (Request q : student.getRequests()) {
                    Object course;
                    if (!(q instanceof CourseRequest) || (course = ((CourseRequest)q).getCourse(en.getCourseId().longValue())) == null) continue;
                    HashSet<Section> sections = new HashSet<Section>();
                    for (Long sectionId : en.getSectionIds()) {
                        Section section = course.getOffering().getSection(sectionId.longValue());
                        if (section == null) continue;
                        sections.add(section);
                    }
                    if (sections.isEmpty()) continue;
                    preferredSections.put((CourseRequest)q, sections);
                }
            }
            for (XCourseId course : cr.getCourseIds()) {
                XOffering offering = server.getOffering(course.getOfferingId());
                if (offering != null && offering.hasLearningCommunityReservation(original, course)) {
                    lcCourses.add(course);
                }
                if (offering == null || !offering.hasIndividualReservation(original, course) && !offering.hasGroupReservation(original, course)) continue;
                fixedCourses.add(course);
            }
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkUnavailabilitiesFromOtherSessions", "false"))) {
            if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                GetInfo.fillInUnavailabilitiesFromOtherSessions(student, server, helper);
            } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(student, server, helper);
            }
        }
        model.addStudent(student);
        model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
        for (XDistribution link : distributions) {
            if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
            ArrayList<Section> sections = new ArrayList<Section>();
            for (Long sectionId : link.getSectionIds()) {
                Section x = (Section)classTable.get(sectionId);
                if (x == null) continue;
                sections.add(x);
            }
            if (sections.size() < 2) continue;
            model.addLinkedSections(linkedClassesMustBeUsed, sections);
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
            for (XRequest r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course : cr.getCourses()) {
                    new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true, true);
                }
            }
        }
        boolean questionTimeConflict = false;
        HashMap<Section, Object> singleSections = new HashMap<Section, Object>();
        for (Request r : student.getRequests()) {
            if (r.isAlternative() || !(r instanceof CourseRequest)) continue;
            CourseRequest cr2 = (CourseRequest)r;
            for (Object course : cr2.getCourses()) {
                if (course.getOffering().getConfigs().size() != 1) continue;
                for (Subpart subpart : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                    if (subpart.getSections().size() != 1) continue;
                    Section section = (Section)subpart.getSections().get(0);
                    for (Section other : singleSections.keySet()) {
                        if (!section.isOverlapping((SctAssignment)other)) continue;
                        response.addMessage(course.getId(), course.getName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getName()).replace("{other}", ((Course)singleSections.get(other)).getName()), CONF_UNITIME);
                        questionTimeConflict = true;
                    }
                    if (cr2.getCourses().size() != 1) continue;
                    singleSections.put(section, course);
                }
            }
        }
        boolean questionInconStuPref = false;
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr3 = (CourseRequest)r;
            for (Course course : cr3.getCourses()) {
                if (!SectioningRequest.hasInconsistentRequirements(cr3, course.getId())) continue;
                response.addMessage(course.getId(), course.getName(), "STUD_PREF", ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getName()), CONF_UNITIME);
                questionInconStuPref = true;
            }
        }
        boolean questionRestrictionsNotMet = false;
        boolean onlineOnly = false;
        String filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
        if (filter != null && !filter.isEmpty() && new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
            onlineOnly = true;
        }
        XSchedulingRule rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr4 = (CourseRequest)r;
            for (Course course : cr4.getCourses()) {
                if (!course.getOffering().hasRestrictions()) continue;
                for (Restriction restriction : course.getOffering().getRestrictions()) {
                    if (!restriction.isApplicable(student) || !restriction.getConfigs().isEmpty()) continue;
                    if (rule != null) {
                        response.addMessage(course.getId(), course.getName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", course.getName()), CONF_UNITIME);
                    } else if (onlineOnly) {
                        response.addMessage(course.getId(), course.getName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getName()), CONF_UNITIME);
                    } else {
                        response.addMessage(course.getId(), course.getName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getName()), CONF_UNITIME);
                    }
                    questionRestrictionsNotMet = true;
                }
            }
        }
        boolean questionFreeTime = false;
        for (int i = 0; i < request.getCourses().size(); ++i) {
            CourseRequestInterface.Request r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).hasCourseId()) continue;
                hasCourse = true;
            }
            Object free = "";
            for (CourseRequestInterface.FreeTime freeTime : r.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + freeTime.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
            }
            if (hasCourse) {
                response.addMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeHighPriority", "High priority free time"), CONF_UNITIME);
            }
            questionFreeTime = true;
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
            selection.setPreferredSections(new Hashtable());
            selection.setRequiredSections(preferredSections);
        } else {
            selection.setPreferredSections(preferredSections);
            selection.setRequiredSections(new Hashtable());
        }
        selection.setRequiredFreeTimes(new HashSet());
        selection.setRequiredUnassinged(new HashSet());
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student);
        neighbour.assign((Assignment)assignment, 0L);
        SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
        req.studentId = this.getBannerId(original);
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationApiMode();
        HashMap<Object, XCourseId> crn2course = new HashMap<Object, XCourseId>();
        HashMap<XCourseId, CallSite> course2banner = new HashMap<XCourseId, CallSite>();
        for (Request r : model.variables()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr5 = (CourseRequest)r;
            Enrollment e = (Enrollment)assignment.getValue((Variable)cr5);
            block31: for (Course course : cr5.getCourses()) {
                XCourseId cid = new XCourseId(course);
                course2banner.put(cid, (CallSite)((Object)(course.getSubjectArea() + " " + course.getCourseNumber())));
                if (e != null && course.equals((Object)e.getCourse())) {
                    for (Section section : e.getSections()) {
                        String crn = this.getCRN(section, course);
                        crn2course.put(crn, cid);
                        SpecialRegistrationHelper.addCrn(req, crn);
                    }
                    continue;
                }
                for (Enrollment x : cr5.values((Assignment)assignment)) {
                    if (!course.equals((Object)x.getCourse())) continue;
                    for (Section section : x.getSections()) {
                        String string = this.getCRN(section, course);
                        crn2course.put(string, cid);
                        SpecialRegistrationHelper.addAltCrn(req, string);
                    }
                    continue block31;
                }
                for (Config config : course.getOffering().getConfigs()) {
                    Object x;
                    if (cr5.isNotAllowed(course, config) || (x = this.firstEnrollment(cr5, (Assignment<Request, Enrollment>)assignment, course, config, new HashSet<Section>(), 0)) == null) continue;
                    for (Section section : x.getSections()) {
                        String crn = this.getCRN(section, course);
                        crn2course.put(crn, cid);
                        SpecialRegistrationHelper.addAltCrn(req, crn);
                    }
                    continue block31;
                }
            }
        }
        Object var34_48 = null;
        boolean hasDeniedOverrides = false;
        if (!SpecialRegistrationHelper.isEmpty(req)) {
            String minCreditLimitFilter;
            Set denied;
            String bc;
            void var34_51;
            Object problems;
            Object course;
            void var38_65;
            if (req.changes == null) {
                req.changes = new SpecialRegistrationInterface.RestrictionsCheckRequest();
            }
            SpecialRegistrationInterface.CheckRestrictionsResponse resp = null;
            ClientResource resource = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)req));
                long t1 = System.currentTimeMillis();
                resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                resp = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)resp));
                }
                helper.getAction().addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)resp));
                if (SpecialRegistrationInterface.ResponseStatus.success != resp.status) {
                    throw new SectioningException((String)(resp.message == null || resp.message.isEmpty() ? "Failed to check student eligibility (" + resp.status + ")." : resp.message));
                }
            }
            catch (SectioningException sectioningException) {
                helper.getAction().setApiException(sectioningException.getMessage());
                throw sectioningException;
            }
            catch (Exception exception) {
                helper.getAction().setApiException(exception.getMessage());
                sLog.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SectioningException(exception.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
            Float f = resp.maxCredit;
            if (f == null) {
                Float f2 = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            Object maxCreditDenied = null;
            if (resp.deniedMaxCreditRequests != null) {
                for (SpecialRegistrationInterface.DeniedMaxCredit r : resp.deniedMaxCreditRequests) {
                    if (r.mode != req.mode || r.maxCredit == null || !(r.maxCredit.floatValue() > var38_65.floatValue()) || maxCreditDenied != null && !(((Float)maxCreditDenied).floatValue() > r.maxCredit.floatValue())) continue;
                    maxCreditDenied = r.maxCredit;
                }
            }
            HashMap overrides = new HashMap();
            Float maxCreditOverride = null;
            CourseRequestInterface.RequestedCourseStatus maxCreditOverrideStatus = null;
            if (resp.cancelRegistrationRequests != null) {
                for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : resp.cancelRegistrationRequests) {
                    if (specialRegistration.changes == null || specialRegistration.changes.isEmpty()) continue;
                    for (SpecialRegistrationInterface.Change ch : specialRegistration.changes) {
                        if (ch.status == SpecialRegistrationInterface.ChangeStatus.cancelled || ch.status == SpecialRegistrationInterface.ChangeStatus.denied) continue;
                        if (ch.subject != null && ch.courseNbr != null) {
                            course = ch.subject + " " + ch.courseNbr;
                            problems = (Map)overrides.get(course);
                            if (problems == null) {
                                problems = new HashMap<String, CourseRequestInterface.RequestedCourseStatus>();
                                overrides.put(course, problems);
                            }
                            if (ch.errors == null) continue;
                            for (SpecialRegistrationInterface.ChangeError err : ch.errors) {
                                if (err.code == null) continue;
                                problems.put(err.code, this.status(ch));
                            }
                            continue;
                        }
                        if (specialRegistration.maxCredit == null || maxCreditOverride != null && !(maxCreditOverride.floatValue() < specialRegistration.maxCredit.floatValue())) continue;
                        maxCreditOverride = specialRegistration.maxCredit;
                        maxCreditOverrideStatus = this.status(ch);
                    }
                }
            }
            request.setWaitListMode(details.getWaitListMode());
            String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
            if (maxCreditDenied != null && request.getCredit(null) + otherCredits[1] >= ((Float)maxCreditDenied).floatValue()) {
                for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, var38_65.floatValue() - otherCredits[1])) {
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format((Number)var38_65)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))), CONF_UNITIME);
                }
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format((Number)var38_65)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))).replace("{maxCreditDenied}", sCreditFormat.format((Number)maxCreditDenied)));
                response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                String string = ApplicationProperties.getProperty("purdue.specreg.messages.acr.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nThe student may not be able to get a full schedule.").replace("{max}", sCreditFormat.format((Number)var38_65)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))).replace("{maxCreditDenied}", sCreditFormat.format((Number)maxCreditDenied));
            } else if (maxCreditLimitStr != null) {
                float f3 = Float.parseFloat(maxCreditLimitStr);
                if (var38_65 != null && var38_65.floatValue() > f3) {
                    f3 = var38_65.floatValue();
                }
                if (request.getCredit(null) + otherCredits[1] > f3) {
                    for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, f3 - otherCredits[1])) {
                        response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(f3))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))), CONF_UNITIME);
                    }
                    response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(f3))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))));
                    response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                    String string = ApplicationProperties.getProperty("purdue.specreg.messages.acr.maxCreditError", "Maximum of {max} credit hours exceeded.\nThe student may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(Float.valueOf(f3))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1])));
                }
            }
            if (var34_51 == null && var38_65.floatValue() < request.getCredit(null) + otherCredits[1]) {
                for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, var38_65.floatValue() - otherCredits[1])) {
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format((Number)var38_65)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))), CONF_BANNER);
                }
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format((Number)var38_65)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null) + otherCredits[1]))));
                response.setMaxCreditOverrideStatus(maxCreditOverrideStatus == null || maxCreditOverride.floatValue() < request.getCredit(null) + otherCredits[1] ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : maxCreditOverrideStatus);
            }
            HashMap hashMap = new HashMap();
            if (resp.deniedRequests != null) {
                for (SpecialRegistrationInterface.DeniedRequest r : resp.deniedRequests) {
                    if (r.mode != req.mode) continue;
                    course = r.subject + " " + r.courseNbr;
                    problems = (TreeSet<String>)hashMap.get(course);
                    if (problems == null) {
                        problems = new TreeSet<String>();
                        hashMap.put(course, problems);
                    }
                    problems.add(r.code);
                }
            }
            if (resp.outJson != null && resp.outJson.message != null && resp.outJson.status != null && resp.outJson.status != SpecialRegistrationInterface.ResponseStatus.success) {
                response.addError(null, null, "Failure", resp.outJson.message);
                response.setErrorMessage(resp.outJson.message);
            } else if (resp.outJsonAlternatives != null && resp.outJsonAlternatives.message != null && resp.outJsonAlternatives.status != null && resp.outJsonAlternatives.status != SpecialRegistrationInterface.ResponseStatus.success) {
                response.addError(null, null, "Failure", resp.outJsonAlternatives.message);
                response.setErrorMessage(resp.outJsonAlternatives.message);
            }
            if (resp.outJson != null && resp.outJson.problems != null) {
                for (SpecialRegistrationInterface.Problem problem : resp.outJson.problems) {
                    if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(course)) continue;
                    bc = (String)course2banner.get(course);
                    Set set = denied = bc == null ? null : (Set)hashMap.get(bc);
                    if (denied != null && denied.contains(problem.code)) {
                        if (fixedCourses.contains(course)) {
                            response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_BANNER).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_BANNER).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        hasDeniedOverrides = true;
                        continue;
                    }
                    response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, CONF_BANNER).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                }
            }
            if (resp.outJsonAlternatives != null && resp.outJsonAlternatives.problems != null) {
                for (SpecialRegistrationInterface.Problem problem : resp.outJsonAlternatives.problems) {
                    if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null || ignoreLcCourses && lcCourses.contains(course)) continue;
                    bc = (String)course2banner.get(course);
                    Set set = denied = bc == null ? null : (Set)hashMap.get(bc);
                    if (denied != null && denied.contains(problem.code)) {
                        if (fixedCourses.contains(course)) {
                            response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_BANNER).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message, CONF_BANNER).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        hasDeniedOverrides = true;
                        continue;
                    }
                    response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, CONF_BANNER).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                }
            }
            if (response.hasMessages()) {
                for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                    if (m.getCourse() != null && m.getMessage().indexOf("this section") >= 0) {
                        m.setMessage(m.getMessage().replace("this section", m.getCourse()));
                    }
                    if (m.getCourse() == null || m.getMessage().indexOf(" (CRN ") < 0) continue;
                    m.setMessage(m.getMessage().replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " "));
                }
            }
            String string = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
            float minCredit = otherCredits[0];
            block48: for (CourseRequestInterface.Request r : request.getCourses()) {
                if (r.hasAdvisorCredit()) {
                    minCredit += r.getAdvisorCreditMin();
                    continue;
                }
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    if (!rc.hasCredit()) continue;
                    minCredit += rc.getCreditMin().floatValue();
                    continue block48;
                }
            }
            if (var34_51 == null && string != null && minCredit < Float.parseFloat(string) && (var38_65 == null || var38_65.floatValue() > Float.parseFloat(string)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
                String string2 = ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
                response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
                response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
            }
        }
        HashSet<Long> courseIds = new HashSet<Long>();
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            if (!request2.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request2.getRequestedCourse()) {
                if (!rc.hasCourseId() || courseIds.add(rc.getCourseId())) continue;
                response.addError(rc.getCourseId(), rc.getCourseName(), "DUPL", ApplicationProperties.getProperty("purdue.specreg.messages.duplicateCourse", "Course {course} used multiple times.").replace("{course}", rc.getCourseName()));
                if (response.hasErrorMessage()) continue;
                response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.duplicateCourse", "Course {course} used multiple times.").replace("{course}", rc.getCourseName()));
            }
        }
        boolean questionNoAlt = false;
        if (!this.isAdvisedNoAlts()) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                CourseRequestInterface.RequestedCourse rc;
                if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (r.isWaitList() || r.isNoSub()) && this.isWaitListNoAlts() || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly()) continue;
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), CONF_UNITIME);
                questionNoAlt = true;
            }
        }
        if (response.getConfirms().contains(CONF_BANNER)) {
            void var38_73;
            void var38_72;
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.bannerProblemsFound", "The following registration errors have been detected:"), CONF_BANNER, -1);
            int n = 1;
            if (hasDeniedOverrides) {
                ++var38_72;
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.deniedOverrides", "One or more courses require registration overrides which have been denied. The student will not be able to request these."), CONF_BANNER, n);
            }
            ++var38_73;
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.requestOverrides", (var38_72 == true ? "" : "\n") + "The student may need to request overrides for the above registration errors. Do you want to proceed?"), CONF_BANNER, (int)var38_72);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        int n = 2;
        if (var34_53 != null) {
            ++var38_75;
            response.addConfirmation((String)var34_53, CONF_UNITIME, n);
        }
        if (questionNoAlt) {
            ++var38_76;
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.noAlternatives", (var38_75 > 2 ? "\n" : "") + "One or more of the recommended courses have no alternatives provided. The student may not be able to get a full schedule."), CONF_UNITIME, (int)var38_75);
        }
        if (questionTimeConflict) {
            ++var38_77;
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.timeConflicts", (var38_76 > 2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. The student will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, (int)var38_76);
        }
        if (questionInconStuPref) {
            ++var38_78;
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.inconsistentStudPref", (var38_77 > 2 ? "\n" : "") + "One or more courses are not available due to the selected preferences."), CONF_UNITIME, (int)var38_77);
        }
        if (questionRestrictionsNotMet) {
            if (onlineOnly) {
                void var38_79;
                ++var38_79;
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.onlineOnlyNotMet", (var38_78 > 2 ? "\n" : "") + "One or more of the recommended courses have no online-only option at the moment. The student may not be able to get a full schedule."), CONF_UNITIME, (int)var38_78);
            } else {
                void var38_80;
                ++var38_80;
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.residentialNotMet", (var38_78 > 2 ? "\n" : "") + "One or more of the recommended courses have no residential option at the moment. The student may not be able to get a full schedule."), CONF_UNITIME, (int)var38_78);
            }
        }
        if (questionFreeTime) {
            void var38_81;
            ++var38_82;
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.freeTimeRequested", (var38_81 > 2 ? "\n" : "") + "Free time requests will be considered as time blocks during the pre-registration process. When possible, classes should be avoided during free time. However, if a free time request is placed higher than a course, the course cannot be attended during free time and the student may not receive a full schedule."), CONF_UNITIME, (int)var38_81);
        }
        if (var38_82 > 2) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, 9);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeDialogName", "Warning Confirmations"), conf.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeContinueButton", "Accept & Continue") : ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeNoButton", "Cancel Submit"), conf.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeContinueButtonTitle", "Accept the above warning(s) and continue to submit the Advisor Course Recommendations") : ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Advisor Course Recommendations"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeNoButtonTitle", "Go back to editing your Advisor Course Recommendations"));
        }
        if (conf.contains(CONF_BANNER)) {
            response.setConfirmation(CONF_BANNER, ApplicationProperties.getProperty("purdue.specreg.confirm.acr.bannerDialogName", "Registration Errors"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.bannerYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.bannerNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.bannerYesButtonTitle", "Accept the above warning(s) and submit the Advisor Course Recommendations"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.bannerNoButtonTitle", "Go back to editing your Advisor Course Recommendations"));
        }
    }
}

