/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.custom.CustomClassAttendanceProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

public class PurdueClassAttendance
implements CustomClassAttendanceProvider {
    private static Log sLog = LogFactory.getLog(PurdueClassAttendance.class);
    private static GwtConstants CONST = Localization.create(GwtConstants.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public PurdueClassAttendance() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getClassAttendanceApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getClassAttendanceApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.classAttendance.readTimeout", "60000");
    }

    protected String getClassAttendanceApiSite() {
        return ApplicationProperties.getProperty("purdue.classAttendance.site");
    }

    protected String getClassAttendanceApiKey() {
        return ApplicationProperties.getProperty("purdue.classAttendance.apiKey");
    }

    protected String getStudentClassAttendanceApiSite() {
        return ApplicationProperties.getProperty("purdue.classAttendance.getStudentMeetPlan", this.getClassAttendanceApiSite() + "/getStudentMeetPlan");
    }

    protected String getBannerId(Student student) {
        Object id = student.getExternalUniqueId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomClassAttendanceProvider.StudentClassAttendance getCustomClassAttendanceForStudent(Student student, OnlineSectioningHelper helper, SessionContext context) {
        if (student == null) {
            return null;
        }
        boolean logHelper = false;
        if (helper == null) {
            OnlineSectioningLog.Entity.Builder user = OnlineSectioningLog.Entity.newBuilder().setExternalId(context == null || context.getUser() == null ? "System" : context.getUser().getExternalUserId()).setType(OnlineSectioningLog.Entity.EntityType.MANAGER);
            if (context != null && context.getUser() != null) {
                user.setName(context.getUser().getName());
            }
            if (context != null && context.getUser() != null && context.getUser().getExternalUserId().equals(student.getExternalUniqueId())) {
                user.setType(OnlineSectioningLog.Entity.EntityType.STUDENT);
            }
            helper = new OnlineSectioningHelper(SessionDAO.getInstance().getSession(), user.build());
            logHelper = true;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setOperation("check-attendance");
            action.setSession(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getSession().getUniqueId()).setName(student.getSession().getReference()));
            action.setStartTime(System.currentTimeMillis());
            action.setUser(user);
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getUniqueId()).setExternalId(student.getExternalUniqueId()).setName(NameFormat.LAST_FIRST_MIDDLE.format(student)).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
        }
        long c0 = OnlineSectioningHelper.getCpuTime();
        ClientResource resource = null;
        try {
            Gson gson = this.getGson(helper);
            resource = new ClientResource(this.getStudentClassAttendanceApiSite());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = new AcademicSessionInfo(student.getSession());
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getClassAttendanceApiKey());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            long t1 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            long t2 = System.currentTimeMillis();
            StudentAttendancePlanResponse response = new GsonRepresentation<StudentAttendancePlanResponse>(resource.getResponseEntity(), StudentAttendancePlanResponse.class).getObject();
            sLog.debug((Object)("Response for " + this.getBannerId(student) + " [" + (t2 - t1) + " ms]: " + gson.toJson((Object)response)));
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
            if (response.data != null && "success".equals(response.status)) {
                PurdueStudentClassAttendance purdueStudentClassAttendance = new PurdueStudentClassAttendance(response.data, student.getSession());
                return purdueStudentClassAttendance;
            }
            if (response.message != null) {
                helper.warn(response.message);
            }
            CustomClassAttendanceProvider.StudentClassAttendance studentClassAttendance = null;
            return studentClassAttendance;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            if (e.getMessage() != null) {
                helper.error(e.getMessage());
            }
            CustomClassAttendanceProvider.StudentClassAttendance studentClassAttendance = null;
            return studentClassAttendance;
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
            if (logHelper) {
                helper.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                helper.getAction().setEndTime(System.currentTimeMillis());
                OnlineSectioningLogger.getInstance().record(OnlineSectioningLog.Log.newBuilder().addAction(helper.getAction()).build());
            }
        }
    }

    public static class StudentAttendancePlanResponse {
        StudentMeetings data;
        String message;
        String status;
    }

    public static class StudentMeetings {
        String puid;
        List<StudentSectionMeetings> sectionMeetings;
    }

    public static class PurdueStudentClassAttendance
    implements CustomClassAttendanceProvider.StudentClassAttendance {
        private StudentMeetings iMeetings;
        private int iStartYear;
        private int iStartMonth;
        private String iHolidays = null;
        private boolean iSkipBreaks;

        PurdueStudentClassAttendance(StudentMeetings meetings, Session session) {
            this.iMeetings = meetings;
            this.iStartYear = session.getSessionStartYear();
            this.iStartMonth = session.getStartMonth();
            this.iHolidays = session.getHolidays();
            this.iSkipBreaks = "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.classAttendance.skipBreaks", "true"));
        }

        protected boolean isHoliday(Date date) {
            if (!this.iSkipBreaks) {
                return false;
            }
            try {
                if (this.iHolidays == null) {
                    return false;
                }
                int idx = CalendarUtils.date2dayOfYear(this.iStartYear, date) - DateUtils.getDayOfYear(1, this.iStartMonth, this.iStartYear) - 1;
                if (idx < 0 || idx >= this.iHolidays.length()) {
                    return false;
                }
                return this.iHolidays.charAt(idx) - 48 != 0;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }

        protected StudentSectionMeetings getMeetings(String externalId) {
            if (externalId == null) {
                return null;
            }
            if (externalId.indexOf(45) > 0) {
                externalId = externalId.substring(0, externalId.indexOf(45));
            }
            if (this.iMeetings == null || this.iMeetings.sectionMeetings == null) {
                return null;
            }
            for (StudentSectionMeetings ssm : this.iMeetings.sectionMeetings) {
                if (ssm.crns == null || !ssm.crns.contains(externalId) || ssm.meetings == null || ssm.meetings.isEmpty()) continue;
                return ssm;
            }
            return null;
        }

        protected StudentSectionMeetings getMeetings(EventInterface event) {
            if (event.hasExternalIds()) {
                for (String externalId : event.getExternalIds()) {
                    StudentSectionMeetings ssm = this.getMeetings(externalId);
                    if (ssm == null) continue;
                    return ssm;
                }
            }
            return null;
        }

        public String getTime(int time) {
            int min = 60 * (time / 100) + time % 100;
            int h = min / 60;
            int m = min % 60;
            if (min == 0) {
                return CONST.timeMidnight();
            }
            if (min == 720) {
                return CONST.timeNoon();
            }
            if (CONST.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? CONST.timeShortAm() : (h >= 12 ? CONST.timeShortPm() : CONST.timeShortAm()));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        protected Date getFirstMeetingDate(MeetingDetail m, EventInterface event) {
            Calendar c = Calendar.getInstance();
            c.setTime(m.startDate);
            int index = 0;
            int startSlot = 12 * (m.startTime / 100) + m.startTime % 100 / 5;
            int endSlot = 12 * (m.endTime / 100) + m.endTime % 100 / 5;
            while (!c.getTime().after(m.endDate)) {
                if (c.get(7) == m.meetDay.getDayOfWeek()) {
                    if (event != null) {
                        boolean match = false;
                        for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                            if (meeting.getDayOfYear() != CalendarUtils.date2dayOfYear(this.iStartYear, c.getTime()) || startSlot >= meeting.getEndSlot() || meeting.getStartSlot() >= endSlot || !meeting.getLocationName().equalsIgnoreCase((String)("OFFCAMP".equals(m.bldg) ? "" : m.bldg + " ") + m.room)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            c.add(6, 1);
                            continue;
                        }
                    } else if (this.isHoliday(c.getTime())) {
                        c.add(6, 1);
                        continue;
                    }
                    ++index;
                    boolean meet = true;
                    if ("Every Other Week".equals(m.occurance)) {
                        meet = index % 2 == 1;
                    } else if ("One Time".equals(m.occurance)) {
                        boolean bl = meet = index <= 1;
                    }
                    if (meet) {
                        return c.getTime();
                    }
                }
                c.add(6, 1);
            }
            return null;
        }

        protected Date getLastMeetingDate(MeetingDetail m, EventInterface event) {
            Calendar c = Calendar.getInstance();
            c.setTime(m.startDate);
            int index = 0;
            Date last = null;
            int startSlot = 12 * (m.startTime / 100) + m.startTime % 100 / 5;
            int endSlot = 12 * (m.endTime / 100) + m.endTime % 100 / 5;
            while (!c.getTime().after(m.endDate)) {
                if (c.get(7) == m.meetDay.getDayOfWeek()) {
                    if (event != null) {
                        boolean match = false;
                        for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                            if (meeting.getDayOfYear() != CalendarUtils.date2dayOfYear(this.iStartYear, c.getTime()) || startSlot >= meeting.getEndSlot() || meeting.getStartSlot() >= endSlot || !meeting.getLocationName().equalsIgnoreCase((String)("OFFCAMP".equals(m.bldg) ? "" : m.bldg + " ") + m.room)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            c.add(6, 1);
                            continue;
                        }
                    } else if (this.isHoliday(c.getTime())) {
                        c.add(6, 1);
                        continue;
                    }
                    ++index;
                    boolean meet = true;
                    if ("Every Other Week".equals(m.occurance)) {
                        meet = index % 2 == 1;
                    } else if ("One Time".equals(m.occurance)) {
                        boolean bl = meet = index <= 1;
                    }
                    if (meet) {
                        last = c.getTime();
                    }
                }
                c.add(6, 1);
            }
            return last;
        }

        protected String toString(MeetingDetail m, EventInterface classEvent) {
            Date first = this.getFirstMeetingDate(m, classEvent);
            Date last = this.getLastMeetingDate(m, classEvent);
            if (classEvent != null && first == null) {
                return null;
            }
            Formats.Format<Date> f = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
            return m.occurance + " " + CONST.days()[m.meetDay.ordinal()] + " " + this.getTime(m.startTime) + " - " + this.getTime(m.endTime) + "\n    " + (String)(first == null ? "" : (first.equals(last) ? f.format(first) + " " : f.format(first) + " - " + f.format(last) + " ")) + (String)("OFFCAMP".equals(m.bldg) ? "" : m.bldg + " ") + m.room;
        }

        protected List<EventInterface.MeetingInterface> toMeetings(StudentSectionMeetings ssm, EventInterface event) {
            ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
            for (MeetingDetail m : ssm.meetings) {
                int startSlot = 12 * (m.startTime / 100) + m.startTime % 100 / 5;
                int endSlot = 12 * (m.endTime / 100) + m.endTime % 100 / 5;
                int startOffset = m.startTime % 5;
                int endOffset = m.endTime % 5;
                Calendar c = Calendar.getInstance();
                c.setTime(m.startDate);
                int index = 0;
                while (!c.getTime().after(m.endDate)) {
                    if (c.get(7) == m.meetDay.getDayOfWeek()) {
                        if (event != null) {
                            boolean match = false;
                            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                                if (meeting.getDayOfYear() != CalendarUtils.date2dayOfYear(this.iStartYear, c.getTime()) || startSlot >= meeting.getEndSlot() || meeting.getStartSlot() >= endSlot || !meeting.getLocationName().equalsIgnoreCase((String)("OFFCAMP".equals(m.bldg) ? "" : m.bldg + " ") + m.room)) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                c.add(6, 1);
                                continue;
                            }
                        }
                        ++index;
                        boolean meet = true;
                        if ("Every Other Week".equals(m.occurance)) {
                            meet = index % 2 == 1;
                        } else if ("One Time".equals(m.occurance)) {
                            boolean bl = meet = index <= 1;
                        }
                        if (meet) {
                            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                            meeting.setDayOfWeek(m.meetDay.ordinal());
                            meeting.setMeetingDate(c.getTime());
                            meeting.setStartSlot(startSlot);
                            meeting.setEndSlot(endSlot);
                            meeting.setStartOffset(startOffset);
                            meeting.setEndOffset(endOffset);
                            meeting.setDayOfYear(CalendarUtils.date2dayOfYear(this.iStartYear, c.getTime()));
                            EventInterface.ResourceInterface room = new EventInterface.ResourceInterface();
                            room.setName((String)("OFFCAMP".equals(m.bldg) ? "" : m.bldg + " ") + m.room);
                            meeting.setLocation(room);
                            meetings.add(meeting);
                        }
                    }
                    c.add(6, 1);
                }
            }
            return meetings;
        }

        protected String getMessage(StudentSectionMeetings ssm, EventInterface classEvent) {
            Object message = ApplicationProperties.getProperty("purdue.classAttendance.messageFace2FacePlan", "In-person course meetings ({group}):").replace("{group}", ssm.meetings.get((int)0).groupName);
            boolean hasMessage = false;
            for (MeetingDetail m : ssm.meetings) {
                String msg = this.toString(m, classEvent);
                if (msg == null) continue;
                message = (String)message + "\n  " + msg;
                hasMessage = true;
            }
            if (hasMessage) {
                if (classEvent == null) {
                    message = (String)message + ApplicationProperties.getProperty("purdue.classAttendance.footerMessage", "\nFor more details, see your <a href='gwt.jsp?page=personal' target='_blank'>Personal Schedule</a>.");
                }
                return message;
            }
            return null;
        }

        @Override
        public String getClassNote(String externalId) {
            StudentSectionMeetings ssm = this.getMeetings(externalId);
            if (ssm != null) {
                return this.getMessage(ssm, null);
            }
            return null;
        }

        protected EventInterface.MeetingInterface match(List<EventInterface.MeetingInterface> meetings, EventInterface.MeetingInterface meeting) {
            for (EventInterface.MeetingInterface m : meetings) {
                if (!m.overlapsWith(meeting) || !m.getLocationName().equals(meeting.getLocationName())) continue;
                return m;
            }
            return null;
        }

        @Override
        public void updateAttendance(EventInterface classEvent) {
            StudentSectionMeetings ssm = this.getMeetings(classEvent);
            if (ssm != null) {
                String note;
                EventInterface.ResourceInterface onl = new EventInterface.ResourceInterface();
                onl.setName(ApplicationProperties.getProperty("purdue.classAttendance.onlineRoom", "Remote"));
                onl.setType(EventInterface.ResourceType.ROOM);
                Location online = Location.findByName(SessionDAO.getInstance().getSession(), classEvent.getSessionId(), onl.getName());
                if (online != null) {
                    onl.setId(online.getUniqueId());
                    onl.setName(online.getLabel());
                    onl.setSize(online.getCapacity());
                    onl.setRoomType(online.getRoomTypeLabel());
                    onl.setBreakTime(online.getEffectiveBreakTime());
                    onl.setMessage(online.getEventMessage());
                    onl.setIgnoreRoomCheck(online.isIgnoreRoomCheck());
                    onl.setDisplayName(online.getDisplayName());
                    onl.setPartitionParentId(online.getPartitionParentId());
                    onl.setEventEmail(online.effectiveEventEmail());
                }
                if ((note = this.getMessage(ssm, this.iSkipBreaks ? classEvent : null)) != null) {
                    EventInterface.NoteInterface n = new EventInterface.NoteInterface();
                    n.setDate(new Date());
                    n.setNote(note);
                    classEvent.addNote(n);
                }
                long id = 0L;
                List<EventInterface.MeetingInterface> meetings = this.toMeetings(ssm, this.iSkipBreaks ? classEvent : null);
                for (EventInterface.MeetingInterface m : new ArrayList<EventInterface.MeetingInterface>(classEvent.getMeetings())) {
                    EventInterface.MeetingInterface match = this.match(meetings, m);
                    if (match == null) {
                        m.setLocation(onl);
                        m.setStyle("online-meeting");
                        continue;
                    }
                    if (match.getStartSlot() == m.getStartSlot() && 5 * m.getEndSlot() + m.getEndOffset() == 5 * match.getEndSlot()) {
                        m.setStyle("f2f-meeting");
                        continue;
                    }
                    m.setStyle("f2f-meeting");
                    if (m.getStartSlot() < match.getStartSlot()) {
                        EventInterface.MeetingInterface before = new EventInterface.MeetingInterface(m);
                        before.setLocation(onl);
                        before.setEndSlot(match.getStartSlot());
                        before.setEndOffset(match.getStartOffset());
                        before.setId(--id);
                        before.setStyle("online-meeting");
                        m.setStartSlot(match.getStartSlot());
                        m.setStartOffset(match.getStartOffset());
                        classEvent.addMeeting(before);
                    }
                    if (5 * m.getEndSlot() + m.getEndOffset() <= 5 * match.getEndSlot()) continue;
                    EventInterface.MeetingInterface after = new EventInterface.MeetingInterface(m);
                    after.setLocation(onl);
                    after.setStartSlot(match.getEndSlot());
                    after.setStartOffset(match.getEndOffset());
                    after.setId(--id);
                    after.setStyle("online-meeting");
                    m.setEndSlot(match.getEndSlot());
                    m.setEndOffset(match.getEndOffset());
                    classEvent.addMeeting(after);
                }
            }
        }
    }

    public static class MeetingDetail {
        Date startDate;
        Date endDate;
        String groupName;
        DayOfWeek meetDay;
        String bldg;
        String room;
        Integer startTime;
        Integer endTime;
        String occurance;
    }

    public static class StudentSectionMeetings {
        Set<String> crns;
        List<MeetingDetail> meetings;
    }

    public static enum DayOfWeek {
        M(2),
        T(3),
        W(4),
        R(5),
        F(6),
        S(7),
        U(1);

        private int iDayOfWeek;

        private DayOfWeek(int dow) {
            this.iDayOfWeek = dow;
        }

        public int getDayOfWeek() {
            return this.iDayOfWeek;
        }
    }
}

