/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;

public class CustomCriticalCoursesHolder {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public static CriticalCoursesProvider getProvider() {
        return (CriticalCoursesProvider)Customization.CriticalCoursesProvider.getProvider();
    }

    public static void release() {
        Customization.CriticalCoursesProvider.release();
    }

    public static boolean hasProvider() {
        return Customization.CriticalCoursesProvider.hasProvider();
    }

    protected static abstract class Worker
    extends Thread {
        private Iterator<Long> iStudentsIds;
        private Long iSessionId;

        public Worker(int index, Long sessionId, Iterator<Long> studentsIds) {
            this.setName("CriticalCourses-" + (1 + index));
            this.iSessionId = sessionId;
            this.iStudentsIds = studentsIds;
        }

        protected abstract void process(Long var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ApplicationProperties.setSessionId(this.iSessionId);
                while (true) {
                    Long studentId = null;
                    Iterator<Long> iterator = this.iStudentsIds;
                    synchronized (iterator) {
                        if (!this.iStudentsIds.hasNext()) {
                            break;
                        }
                        studentId = this.iStudentsIds.next();
                    }
                    this.process(studentId);
                }
            }
            finally {
                ApplicationProperties.setSessionId(null);
                HibernateUtil.closeCurrentThreadSessions();
            }
        }
    }

    public static class CheckCriticalCourses
    implements OnlineSectioningAction<Boolean> {
        private static final long serialVersionUID = 1L;
        private Collection<Long> iStudentIds = null;

        public CheckCriticalCourses forStudents(Long ... studentIds) {
            this.iStudentIds = new ArrayList<Long>();
            for (Long studentId : studentIds) {
                this.iStudentIds.add(studentId);
            }
            return this;
        }

        public CheckCriticalCourses forStudents(Collection<Long> studentIds) {
            this.iStudentIds = studentIds;
            return this;
        }

        public Collection<Long> getStudentIds() {
            return this.iStudentIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean execute(final OnlineSectioningServer server, final OnlineSectioningHelper helper) {
            if (!CustomCriticalCoursesHolder.hasProvider()) {
                return false;
            }
            final ArrayList<Long> reloadIds = new ArrayList<Long>();
            try {
                int nrThreads = server.getConfig().getPropertyInt("CheckCriticalCourses.NrThreads", 10);
                if (nrThreads <= 1 || this.getStudentIds().size() <= 1) {
                    for (Long studentId : this.getStudentIds()) {
                        if (!this.recheckStudent(server, helper, studentId)) continue;
                        reloadIds.add(studentId);
                    }
                } else {
                    ArrayList<1> workers = new ArrayList<1>();
                    Iterator<Long> studentIds = this.getStudentIds().iterator();
                    for (int i = 0; i < nrThreads; ++i) {
                        workers.add(new Worker(i, server.getAcademicSession().getUniqueId(), studentIds){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void process(Long studentId) {
                                if (this.recheckStudent(server, new OnlineSectioningHelper(helper), studentId)) {
                                    List list = reloadIds;
                                    synchronized (list) {
                                        reloadIds.add(studentId);
                                    }
                                }
                            }
                        });
                    }
                    for (Worker worker : workers) {
                        worker.start();
                    }
                    for (Worker worker : workers) {
                        try {
                            worker.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            finally {
                if (!reloadIds.isEmpty() && !(server instanceof DatabaseServer)) {
                    server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
                }
            }
            return !reloadIds.isEmpty();
        }

        protected int isCritical(CourseDemand cd, CriticalCoursesProvider.CriticalCourses critical) {
            if (critical == null || cd.isAlternative().booleanValue()) {
                return 0;
            }
            for (CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOrder() != 0 || critical.isCritical(cr.getCourseOffering()) <= 0) continue;
                return critical.isCritical(cr.getCourseOffering());
            }
            return 0;
        }

        protected int isCritical(XCourseRequest cr, CriticalCoursesProvider.CriticalCourses critical) {
            if (critical == null || cr.isAlternative()) {
                return 0;
            }
            Iterator<XCourseId> iterator = cr.getCourseIds().iterator();
            if (iterator.hasNext()) {
                XCourseId courseId = iterator.next();
                return critical.isCritical(courseId);
            }
            return 0;
        }

        protected int isCritical(XAdvisorRequest cr, CriticalCoursesProvider.CriticalCourses critical) {
            if (critical == null) {
                return 0;
            }
            if (critical instanceof CriticalCoursesProvider.AdvisorCriticalCourses) {
                return ((CriticalCoursesProvider.AdvisorCriticalCourses)((Object)critical)).isCritical(cr);
            }
            if (cr.isSubstitute() || cr.getCourseId() == null) {
                return 0;
            }
            return critical.isCritical(cr.getCourseId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean recheckStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Long studentId) {
            helper.beginTransaction();
            try {
                XStudent student = server.getStudent(studentId);
                boolean changed = false;
                if (student != null) {
                    OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(studentId).setExternalId(student.getExternalId()).setName(student.getName()).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
                    long c0 = OnlineSectioningHelper.getCpuTime();
                    try {
                        Student student2;
                        CriticalCoursesProvider.CriticalCourses critical = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(server, helper, student, action);
                        boolean courseDemandsNeedChange = false;
                        for (XRequest xRequest : student.getRequests()) {
                            XCourseRequest cr;
                            if (!(xRequest instanceof XCourseRequest) || (cr = (XCourseRequest)xRequest).getCritical() == this.isCritical(cr, critical)) continue;
                            courseDemandsNeedChange = true;
                            break;
                        }
                        if (courseDemandsNeedChange) {
                            Student dbStudent2 = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                            for (CourseDemand cd : dbStudent2.getCourseDemands()) {
                                int crit = this.isCritical(cd, critical);
                                if (cd.getCritical() != null && cd.getCritical() == crit) continue;
                                cd.setCritical(crit);
                                helper.getHibSession().merge((Object)cd);
                                changed = true;
                            }
                        }
                        boolean advisorRecommendationsNeedChange = false;
                        if (student.getAdvisorRequests() != null) {
                            for (XAdvisorRequest acr : student.getAdvisorRequests()) {
                                if (acr.getCritical() == this.isCritical(acr, critical)) continue;
                                advisorRecommendationsNeedChange = true;
                                break;
                            }
                        }
                        if (advisorRecommendationsNeedChange && (student2 = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession())).getAdvisorCourseRequests() != null) {
                            for (AdvisorCourseRequest acr : student2.getAdvisorCourseRequests()) {
                                int crit = acr.isCritical(critical);
                                if (acr.getCritical() != null && acr.getCritical() == crit) continue;
                                acr.setCritical(crit);
                                helper.getHibSession().merge((Object)acr);
                            }
                        }
                        if (changed) {
                            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
                        } else {
                            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                        }
                    }
                    catch (SectioningException e) {
                        action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        if (e.getCause() != null) {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
                        } else {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
                        }
                    }
                    finally {
                        action.setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                        action.setEndTime(System.currentTimeMillis());
                    }
                }
                helper.commitTransaction();
                return changed;
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }

        @Override
        public String name() {
            return "critical-courses";
        }
    }
}

