/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.selection.StudentSchedulingAssistantWeights;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumOverride;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.LearningCommunityReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.AnyStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XLearningCommunityReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XUniversalReservation;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.DateUtils;

public class GetInfo
implements OnlineSectioningAction<Map<String, String>> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<String, String> info = new HashMap<String, String>();
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            void var30_76;
            void var27_57;
            void var26_44;
            List<Object> list;
            HashMap<Long, Offering> offerings = new HashMap<Long, Offering>();
            Hashtable<Long, Course> courses = new Hashtable<Long, Course>();
            HashMap groups = new HashMap();
            Hashtable<Long, Config> configs = new Hashtable<Long, Config>();
            Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
            Hashtable<Long, Section> sections = new Hashtable<Long, Section>();
            Hashtable<Long, DummyReservation> reservations = new Hashtable<Long, DummyReservation>();
            DistanceMetric dm = server.getDistanceMetric();
            AcademicSessionInfo session = server.getAcademicSession();
            HashSet<String> wlStates = new HashSet<String>();
            HashSet<String> noSubStates = new HashSet<String>();
            Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
            for (Object status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
                if (StudentSectioningStatus.hasEffectiveOption((StudentSectioningStatus)status, dbSession, StudentSectioningStatus.Option.waitlist)) {
                    wlStates.add(((BaseRefTableEntry)status).getReference());
                    continue;
                }
                if (!StudentSectioningStatus.hasEffectiveOption((StudentSectioningStatus)status, dbSession, StudentSectioningStatus.Option.nosubs)) continue;
                noSubStates.add(((BaseRefTableEntry)status).getReference());
            }
            boolean checkUnavailabilitiesFromOtherSessions = server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsForReporting", false);
            for (XCourseId xCourseId : server.findCourses(new AnyCourseMatcher())) {
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null || offerings.containsKey(offering.getOfferingId())) continue;
                Offering offering2 = new Offering(offering.getOfferingId().longValue(), offering.getName());
                for (XCourse course : offering.getCourses()) {
                    Course clonedCourse = new Course(course.getCourseId().longValue(), course.getSubjectArea(), course.getCourseNumber(), offering2, course.getLimit(), course.getProjected());
                    clonedCourse.setNote(course.getNote());
                    clonedCourse.setType(course.getType());
                    clonedCourse.setTitle(course.getTitle());
                    clonedCourse.setCredit(course.getCredit());
                    courses.put(course.getCourseId(), clonedCourse);
                }
                for (XConfig config : offering.getConfigs()) {
                    Config clonedConfig = new Config(config.getConfigId().longValue(), config.getLimit(), config.getName(), offering2);
                    if (config.getInstructionalMethod() != null) {
                        clonedConfig.setInstructionalMethodId(config.getInstructionalMethod().getUniqueId());
                        clonedConfig.setInstructionalMethodName(config.getInstructionalMethod().getLabel());
                        clonedConfig.setInstructionalMethodReference(config.getInstructionalMethod().getReference());
                    }
                    configs.put(config.getConfigId(), clonedConfig);
                    for (XSubpart xSubpart : config.getSubparts()) {
                        Subpart subpart = new Subpart(xSubpart.getSubpartId().longValue(), xSubpart.getInstructionalType(), xSubpart.getName(), clonedConfig, xSubpart.getParentId() == null ? null : (Subpart)subparts.get(xSubpart.getParentId()));
                        subpart.setAllowOverlap(xSubpart.isAllowOverlap());
                        subpart.setCredit(xSubpart.getCredit(null));
                        subparts.put(xSubpart.getSubpartId(), subpart);
                        for (XSection section : xSubpart.getSections()) {
                            Section section2 = new Section(section.getSectionId().longValue(), section.getLimit(), section.getName(), subpart, section.toPlacement(), section.toInstructors(), section.getParentId() == null ? null : (Section)sections.get(section.getParentId()));
                            section2.setName(-1L, section.getName(-1L));
                            section2.setNote(section.getNote());
                            section2.setCancelled(section.isCancelled());
                            section2.setEnabled(section.isEnabledForScheduling());
                            section2.setOnline(section.isOnline());
                            section2.setPast(section.isPast());
                            for (XDistribution distribution : offering.getDistributions()) {
                                if (distribution.getDistributionType() != XDistributionType.IngoreConflicts || !distribution.hasSection(section.getSectionId())) continue;
                                for (Long l : distribution.getSectionIds()) {
                                    if (l.equals(section.getSectionId())) continue;
                                    section2.addIgnoreConflictWith(l.longValue());
                                }
                            }
                            sections.put(section.getSectionId(), section2);
                        }
                    }
                }
                for (XReservation reservation : offering.getReservations()) {
                    Object clonedReservation = null;
                    switch (reservation.getType()) {
                        case Course: {
                            Iterator<Map.Entry<Long, Set<Long>>> courseR = (XCourseReservation)reservation;
                            clonedReservation = new CourseReservation(reservation.getReservationId().longValue(), (Course)courses.get(((XCourseReservation)((Object)courseR)).getCourseId()));
                            break;
                        }
                        case Curriculum: {
                            XCurriculumReservation xCurriculumReservation = (XCurriculumReservation)reservation;
                            clonedReservation = new CurriculumReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, xCurriculumReservation.getAcademicAreas(), xCurriculumReservation.getClassifications(), xCurriculumReservation.getMajors(), xCurriculumReservation.getMinors());
                            for (String major : xCurriculumReservation.getMajors()) {
                                Set<String> concs = xCurriculumReservation.getConcentrations(major);
                                if (concs == null) continue;
                                for (String conc : concs) {
                                    ((CurriculumReservation)clonedReservation).addConcentration(major, conc);
                                }
                            }
                            break;
                        }
                        case Group: {
                            if (reservation instanceof XIndividualReservation) {
                                XIndividualReservation xIndividualReservation = (XIndividualReservation)reservation;
                                clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, xIndividualReservation.getStudentIds());
                                break;
                            }
                            XGroupReservation xGroupReservation = (XGroupReservation)reservation;
                            clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, new Long[0]);
                            list = (List)groups.get(xGroupReservation.getGroup());
                            if (list == null) {
                                list = new ArrayList<GroupReservation>();
                                groups.put(xGroupReservation.getGroup(), list);
                            }
                            list.add((GroupReservation)clonedReservation);
                            break;
                        }
                        case Individual: {
                            XIndividualReservation xIndividualReservation = (XIndividualReservation)reservation;
                            clonedReservation = new IndividualReservation(reservation.getReservationId().longValue(), offering2, xIndividualReservation.getStudentIds());
                            break;
                        }
                        case IndividualOverride: {
                            XIndividualReservation ovrR = (XIndividualReservation)reservation;
                            clonedReservation = ovrR.isOverride() ? new ReservationOverride(reservation.getReservationId().longValue(), offering2, ovrR.getStudentIds()) : new IndividualReservation(reservation.getReservationId().longValue(), offering2, ovrR.getStudentIds());
                            clonedReservation.setMustBeUsed(ovrR.mustBeUsed());
                            clonedReservation.setAllowOverlap(ovrR.isAllowOverlap());
                            clonedReservation.setCanAssignOverLimit(ovrR.canAssignOverLimit());
                            break;
                        }
                        case GroupOverride: {
                            void var30_67;
                            XGroupReservation groupR = (XGroupReservation)reservation;
                            clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, new Long[0]);
                            List list2 = (List)groups.get(groupR.getGroup());
                            if (list2 == null) {
                                ArrayList arrayList = new ArrayList();
                                groups.put(groupR.getGroup(), arrayList);
                            }
                            var30_67.add((GroupReservation)clonedReservation);
                            ((GroupReservation)clonedReservation).setMustBeUsed(groupR.mustBeUsed());
                            ((GroupReservation)clonedReservation).setAllowOverlap(groupR.isAllowOverlap());
                            ((GroupReservation)clonedReservation).setCanAssignOverLimit(groupR.canAssignOverLimit());
                            break;
                        }
                        case LearningCommunity: {
                            void var30_70;
                            XLearningCommunityReservation lcR = (XLearningCommunityReservation)reservation;
                            clonedReservation = new LearningCommunityReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), (Course)courses.get(lcR.getCourseId()), lcR.getStudentIds());
                            if (lcR.getGroup() == null) break;
                            List list3 = (List)groups.get(lcR.getGroup());
                            if (list3 == null) {
                                ArrayList arrayList = new ArrayList();
                                groups.put(lcR.getGroup(), arrayList);
                            }
                            var30_70.add((GroupReservation)clonedReservation);
                            break;
                        }
                        case CurriculumOverride: {
                            XCurriculumReservation curR = (XCurriculumReservation)reservation;
                            clonedReservation = curR.isOverride() ? new CurriculumOverride(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, curR.getAcademicAreas(), curR.getClassifications(), curR.getMajors(), curR.getMinors()) : new CurriculumReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), offering2, curR.getAcademicAreas(), curR.getClassifications(), curR.getMajors(), curR.getMinors());
                            ((CurriculumReservation)clonedReservation).setMustBeUsed(curR.mustBeUsed());
                            ((CurriculumReservation)clonedReservation).setAllowOverlap(curR.isAllowOverlap());
                            ((CurriculumReservation)clonedReservation).setCanAssignOverLimit(curR.canAssignOverLimit());
                            for (String string : curR.getMajors()) {
                                Set<String> set = curR.getConcentrations(string);
                                if (set == null) continue;
                                for (String conc : set) {
                                    ((CurriculumReservation)clonedReservation).addConcentration(string, conc);
                                }
                            }
                            break;
                        }
                        case Universal: {
                            XUniversalReservation uniR = (XUniversalReservation)reservation;
                            clonedReservation = new UniversalOverride(reservation.getReservationId().longValue(), reservation.isOverride(), (double)reservation.getLimit(), offering2, uniR.getFilter());
                            ((UniversalOverride)clonedReservation).setMustBeUsed(uniR.mustBeUsed());
                            ((UniversalOverride)clonedReservation).setAllowOverlap(uniR.isAllowOverlap());
                            ((UniversalOverride)clonedReservation).setCanAssignOverLimit(uniR.canAssignOverLimit());
                            break;
                        }
                        default: {
                            clonedReservation = new DummyReservation(offering2);
                        }
                    }
                    for (Long l : reservation.getConfigsIds()) {
                        clonedReservation.addConfig((Config)configs.get(l));
                    }
                    for (Map.Entry<Long, Set<Long>> entry : reservation.getSections().entrySet()) {
                        HashSet<Section> hashSet = new HashSet<Section>();
                        for (Object sectionId : entry.getValue()) {
                            hashSet.add((Section)sections.get(sectionId));
                        }
                        clonedReservation.getSections().put((Subpart)subparts.get(entry.getKey()), hashSet);
                    }
                    reservations.put(reservation.getReservationId(), (DummyReservation)clonedReservation);
                }
                offerings.put(offering.getOfferingId(), offering2);
            }
            HashMap<Long, Student> students = new HashMap<Long, Student>();
            AssignmentMap assignmentMap = new AssignmentMap();
            for (XStudentId xStudentId : server.findStudents(new AnyStudentMatcher())) {
                Collection<Long> collection;
                XStudent student;
                XStudent xStudent = student = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                if (student == null) {
                    XReservation reservation;
                    reservation = null;
                    return reservation;
                }
                String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
                if (status == null || wlStates.contains(status)) {
                    wl = OnlineSectioningInterface.WaitListMode.WaitList;
                } else if (noSubStates.contains(status)) {
                    wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                }
                Student clonnedStudent = new Student(student.getStudentId().longValue());
                clonnedStudent.setExternalId(student.getExternalId());
                clonnedStudent.setName(student.getName());
                for (XStudent.XGroup xGroup : student.getGroups()) {
                    list = (ArrayList<GroupReservation>)groups.get(xGroup);
                    if (list == null) continue;
                    for (GroupReservation groupReservation : list) {
                        groupReservation.getStudentIds().add(student.getStudentId());
                    }
                }
                clonnedStudent.setNeedShortDistances(student.hasAccomodation(dm.getShortDistanceAccommodationReference()));
                clonnedStudent.setAllowDisabled(student.isAllowDisabled());
                clonnedStudent.setClassFirstDate(student.getClassStartDate());
                clonnedStudent.setClassLastDate(student.getClassEndDate());
                clonnedStudent.setBackToBackPreference(student.getBackToBackPreference());
                clonnedStudent.setModalityPreference(student.getModalityPreference());
                for (XRequest xRequest : student.getRequests()) {
                    if (xRequest instanceof XFreeTimeRequest) {
                        XFreeTimeRequest ft = (XFreeTimeRequest)xRequest;
                        new FreeTimeRequest(xRequest.getRequestId().longValue(), xRequest.getPriority(), xRequest.isAlternative(), clonnedStudent, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                    } else {
                        XCourseRequest cr = (XCourseRequest)xRequest;
                        ArrayList<Course> req = new ArrayList<Course>();
                        for (XCourseId c : cr.getCourseIds()) {
                            Course course = (Course)courses.get(c.getCourseId());
                            if (course == null) continue;
                            req.add(course);
                        }
                        if (!req.isEmpty()) {
                            CourseRequest courseRequest = new CourseRequest(xRequest.getRequestId().longValue(), xRequest.getPriority(), xRequest.isAlternative(), clonnedStudent, req, cr.isWaitListOrNoSub(wl), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
                            XEnrollment enrollment = cr.getEnrollment();
                            if (enrollment != null) {
                                Reservation reservation;
                                Config config = (Config)configs.get(enrollment.getConfigId());
                                HashSet<Section> assignments = new HashSet<Section>();
                                for (Long l : enrollment.getSectionIds()) {
                                    Section section = (Section)sections.get(l);
                                    if (section == null) continue;
                                    assignments.add(section);
                                }
                                Reservation reservation2 = reservation = enrollment.getReservation() == null ? null : (Reservation)reservations.get(enrollment.getReservation().getReservationId());
                                if (config != null && !sections.isEmpty()) {
                                    assignmentMap.assign(0L, (Value)new Enrollment((Request)courseRequest, 0, (Course)courses.get(enrollment.getCourseId()), config, assignments, reservation));
                                }
                            }
                        }
                    }
                    students.put(student.getStudentId(), clonnedStudent);
                }
                if (clonnedStudent.getExternalId() == null || clonnedStudent.getExternalId().isEmpty() || (collection = server.getInstructedOfferings(clonnedStudent.getExternalId())) == null) continue;
                for (Long offeringId : collection) {
                    XOffering offering = server.getOffering(offeringId);
                    if (offering == null) continue;
                    offering.fillInUnavailabilities(clonnedStudent);
                }
            }
            if (checkUnavailabilitiesFromOtherSessions) {
                GetInfo.fillInAllUnavailabilitiesFromOtherSessionsUsingDatabase(students, server, helper);
            }
            DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            StudentSchedulingAssistantWeights studentSchedulingAssistantWeights = new StudentSchedulingAssistantWeights(server.getConfig());
            DistanceConflict dc = new DistanceConflict(server.getDistanceMetric(), server.getConfig());
            TimeOverlapsCounter toc = new TimeOverlapsCounter(null, server.getConfig());
            int nrVars = 0;
            int assgnVars = 0;
            boolean bl = false;
            boolean bl2 = false;
            int dist = 0;
            int overlap = 0;
            boolean bl3 = false;
            int unav = 0;
            int fc = 0;
            double value = 0.0;
            for (Student student : students.values()) {
                boolean complete = true;
                for (Request request : student.getRequests()) {
                    if (request instanceof FreeTimeRequest) continue;
                    Enrollment enrollment = (Enrollment)assignmentMap.getValue((Variable)request);
                    if (enrollment != null) {
                        ++assgnVars;
                        ++nrVars;
                        value += studentSchedulingAssistantWeights.getWeight((Assignment)assignmentMap, enrollment);
                        if (!((Course)((CourseRequest)request).getCourses().get(0)).equals((Object)enrollment.getCourse()) || request.isAlternative()) continue;
                        ++fc;
                        continue;
                    }
                    if (!student.canAssign((Assignment)assignmentMap, request)) continue;
                    ++nrVars;
                    complete = false;
                }
                ++var26_44;
                if (complete) {
                    ++var27_57;
                }
                for (int i = 0; i < student.getRequests().size() - 1; ++i) {
                    Enrollment e1 = (Enrollment)assignmentMap.getValue((Variable)((Request)student.getRequests().get(i)));
                    if (e1 == null || !e1.isCourseRequest()) continue;
                    dist += dc.nrConflicts(e1);
                    var30_76 += toc.nrFreeTimeConflicts(e1);
                    unav += toc.nrNotAvailableTimeConflicts(e1);
                    for (int j = i + 1; j < student.getRequests().size(); ++j) {
                        Enrollment e2;
                        Request r2 = (Request)student.getRequests().get(j);
                        if (r2 instanceof FreeTimeRequest || (e2 = (Enrollment)assignmentMap.getValue((Variable)r2)) == null) continue;
                        dist += dc.nrConflicts(e1, e2);
                        overlap += toc.nrConflicts(e1, e2);
                    }
                }
            }
            info.put("Assigned variables", df.format(100.0 * (double)assgnVars / (double)nrVars) + "% (" + assgnVars + "/" + nrVars + ")");
            info.put("Overall solution value", df.format(value));
            info.put("Students with complete schedule", df.format(100.0 * (double)var27_57 / (double)var26_44) + "% (" + (int)var27_57 + "/" + (int)var26_44 + ")");
            info.put("Student distance conflicts", df.format(1.0 * (double)dist / (double)var26_44) + " (" + dist + ")");
            info.put("Time overlapping conflicts", df.format((double)overlap / 12.0 / (double)var26_44) + "h (" + overlap + ")");
            info.put("Free time overlapping conflicts", df.format((double)var30_76 / 12.0 / (double)var26_44) + "h (" + (int)var30_76 + ")");
            info.put("Instructing class overlapping conflicts", df.format((double)unav / 12.0 / (double)var26_44) + "h (" + unav + ")");
            info.put("Assigned priority course requests", df.format(100.0 * (double)fc / (double)assgnVars) + "% (" + fc + "/" + assgnVars + ")");
            double d = 0.0;
            int disbSections = 0;
            int disb10Sections = 0;
            boolean balanceUnlimited = server.getConfig().getPropertyBoolean("General.BalanceUnlimited", false);
            for (Offering offering : offerings.values()) {
                for (Config config : offering.getConfigs()) {
                    double enrl = config.getEnrollments((Assignment)assignmentMap).size();
                    for (Subpart subpart : config.getSubparts()) {
                        if (subpart.getSections().size() <= 1) continue;
                        if (subpart.getLimit() > 0) {
                            double ratio = enrl / (double)subpart.getLimit();
                            for (Section section : subpart.getSections()) {
                                double desired = ratio * (double)section.getLimit();
                                d += Math.abs((double)section.getEnrollments((Assignment)assignmentMap).size() - desired);
                                ++disbSections;
                                if (!(Math.abs(desired - (double)section.getEnrollments((Assignment)assignmentMap).size()) >= Math.max(1.0, 0.1 * (double)section.getLimit()))) continue;
                                ++disb10Sections;
                            }
                            continue;
                        }
                        if (!balanceUnlimited) continue;
                        for (Section section : subpart.getSections()) {
                            double desired = enrl / (double)subpart.getSections().size();
                            d += Math.abs((double)section.getEnrollments((Assignment)assignmentMap).size() - desired);
                            ++disbSections;
                            if (!(Math.abs(desired - (double)section.getEnrollments((Assignment)assignmentMap).size()) >= Math.max(1.0, 0.1 * desired))) continue;
                            ++disb10Sections;
                        }
                    }
                }
            }
            if (disbSections != 0) {
                info.put("Average disbalance", df.format(d / (double)disbSections) + " (" + df.format(assgnVars == 0 ? 0.0 : 100.0 * d / (double)assgnVars) + "%)");
                info.put("Sections disbalanced by 10% or more", disb10Sections + " (" + df.format(disbSections == 0 ? 0.0 : 100.0 * (double)disb10Sections / (double)disbSections) + "%)");
            }
        }
        finally {
            lock.release();
        }
        return info;
    }

    public static void fillInUnavailabilitiesFromOtherSessions(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Collection<XClassEnrollment> unavailabilities;
        if (student == null || student.getId() < 0L || student.getExternalId() == null || student.getExternalId().isEmpty()) {
            return;
        }
        SolverServer solverServer = SolverServerImplementation.getInstance();
        if (solverServer != null && (unavailabilities = solverServer.getUnavailabilitiesFromOtherSessions(server.getAcademicSession(), student.getExternalId())) != null) {
            for (XClassEnrollment e : unavailabilities) {
                if (e.getSection().isCancelled() || e.getSection().getTime() == null) continue;
                Unavailability ua = new Unavailability(student, new Section(e.getSection().getSectionId().longValue(), e.getSection().getLimit(), e.getCourseId().getCourseName() + " " + e.getSection().getSubpartName() + " " + e.getSection().getName(e.getCourseId().getCourseId()), null, e.getSection().toPlacement(e.getShiftDays()), null, new Instructor[0]), e.getSection().isAllowOverlap());
                ua.setTeachingAssignment(false);
                ua.setCourseId(e.getCourseId().getCourseId());
            }
        }
    }

    public static void fillInUnavailabilitiesFromOtherSessionsUsingDatabase(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        List enrollments = helper.getHibSession().createQuery("select e2 from Student s1 inner join s1.session z1, StudentClassEnrollment e2 inner join e2.student s2 inner join s2.session z2 where s1.uniqueId = :studentId and s1.externalUniqueId = s2.externalUniqueId and e2.clazz.cancelled = false and e2.clazz.committedAssignment is not null and z1 != z2 and z1.sessionBeginDateTime <= z2.classesEndDateTime and z2.sessionBeginDateTime <= z1.classesEndDateTime", StudentClassEnrollment.class).setParameter("studentId", (Object)student.getId()).list();
        if (!enrollments.isEmpty()) {
            for (StudentClassEnrollment enrollment : enrollments) {
                if (enrollment.getClazz().isCancelled().booleanValue() || enrollment.getClazz().getCommittedAssignment() == null) continue;
                int shiftDays = DateUtils.daysBetween(server.getAcademicSession().getDatePatternFirstDate(), AcademicSessionInfo.getDatePatternFirstDay(enrollment.getCourseOffering().getInstructionalOffering().getSession()));
                Unavailability ua = new Unavailability(student, new Section(enrollment.getClazz().getUniqueId().longValue(), enrollment.getClazz().getMaxExpectedCapacity().intValue(), enrollment.getClazz().getClassLabel(enrollment.getCourseOffering()), null, enrollment.getClazz().getCommittedAssignment().getPlacement(shiftDays), null, new Instructor[0]), enrollment.getClazz().getSchedulingSubpart().getStudentAllowOverlap().booleanValue());
                ua.setTeachingAssignment(false);
                ua.setCourseId(enrollment.getCourseOffering().getUniqueId());
            }
        }
    }

    public static void fillInAllUnavailabilitiesFromOtherSessionsUsingDatabase(Map<Long, Student> students, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        List enrollments = helper.getHibSession().createQuery("select s1.uniqueId, e2 from Student s1 inner join s1.session z1, StudentClassEnrollment e2 inner join e2.student s2 inner join s2.session z2 where s1.externalUniqueId is not null and z1.uniqueId = :sessionId and s1.externalUniqueId = s2.externalUniqueId and e2.clazz.cancelled = false and e2.clazz.committedAssignment is not null and z1 != z2 and z1.sessionBeginDateTime <= z2.classesEndDateTime and z2.sessionBeginDateTime <= z1.classesEndDateTime", Object[].class).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).list();
        for (Object[] row : enrollments) {
            Long studentId = (Long)row[0];
            StudentClassEnrollment enrollment = (StudentClassEnrollment)row[1];
            Student student = students.get(studentId);
            if (student == null || enrollment.getClazz().isCancelled().booleanValue() || enrollment.getClazz().getCommittedAssignment() == null) continue;
            int shiftDays = DateUtils.daysBetween(server.getAcademicSession().getDatePatternFirstDate(), AcademicSessionInfo.getDatePatternFirstDay(enrollment.getCourseOffering().getInstructionalOffering().getSession()));
            Unavailability ua = new Unavailability(student, new Section(enrollment.getClazz().getUniqueId().longValue(), enrollment.getClazz().getMaxExpectedCapacity().intValue(), enrollment.getClazz().getClassLabel(enrollment.getCourseOffering()), null, enrollment.getClazz().getCommittedAssignment().getPlacement(shiftDays), null, new Instructor[0]), enrollment.getClazz().getSchedulingSubpart().getStudentAllowOverlap().booleanValue());
            ua.setTeachingAssignment(false);
            ua.setCourseId(enrollment.getCourseOffering().getUniqueId());
        }
    }

    @Override
    public String name() {
        return "info";
    }
}

