/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;

public class MultiLock {
    private Log iLog = LogFactory.getLog(MultiLock.class);
    private Lock iLock = new ReentrantLock();
    private Condition iAllLocked = null;
    private Map<Long, Condition> iIndividualLocks = new HashMap<Long, Condition>();

    public MultiLock() {
        this.iLog = LogFactory.getLog((String)(MultiLock.class.getName() + ".lock"));
    }

    public MultiLock(AcademicSessionInfo session) {
        this.iLog = LogFactory.getLog((String)(MultiLock.class.getName() + ".lock[" + session.toCompactString() + "]"));
    }

    private Condition hasLock(Collection<Long> ids) {
        if (this.iAllLocked != null) {
            return this.iAllLocked;
        }
        for (Long id : ids) {
            Condition c = this.iIndividualLocks.get(id);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Unlock lock(Long ... ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (Long id : ids) {
            list.add(id);
        }
        return this.lock(list);
    }

    public UnlockAll lockAll() {
        this.iLock.lock();
        try {
            this.iLog.debug((Object)"Locking all ...");
            while (this.iAllLocked != null) {
                this.iAllLocked.awaitUninterruptibly();
            }
            this.iAllLocked = this.iLock.newCondition();
            while (!this.iIndividualLocks.isEmpty()) {
                Condition otherCondition = this.iIndividualLocks.values().iterator().next();
                otherCondition.awaitUninterruptibly();
            }
            this.iLog.debug((Object)"Locked: all");
            UnlockAll unlockAll = new UnlockAll();
            return unlockAll;
        }
        finally {
            this.iLock.unlock();
        }
    }

    public void unlockAll() {
        this.iLock.lock();
        try {
            this.iLog.debug((Object)"Unlocking all ...");
            Condition allLocked = this.iAllLocked;
            this.iAllLocked = null;
            allLocked.signalAll();
            this.iLog.debug((Object)"Unlocked: all");
        }
        finally {
            this.iLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unlock lock(Collection<Long> ids) {
        this.iLock.lock();
        try {
            if (ids == null || ids.isEmpty()) {
                Unlock unlock = new Unlock(ids);
                return unlock;
            }
            this.iLog.debug((Object)("Locking " + ids + " ..."));
            Condition otherCondition = null;
            while ((otherCondition = this.hasLock(ids)) != null) {
                otherCondition.awaitUninterruptibly();
            }
            Condition myCondition = this.iLock.newCondition();
            for (Long id : ids) {
                this.iIndividualLocks.put(id, myCondition);
            }
            this.iLog.debug((Object)("Locked: " + ids));
            Unlock unlock = new Unlock(ids);
            return unlock;
        }
        finally {
            this.iLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(Collection<Long> ids) {
        this.iLock.lock();
        try {
            if (ids == null || ids.isEmpty()) {
                return;
            }
            this.iLog.debug((Object)("Unlocking " + ids + " ..."));
            Condition myCondition = null;
            for (Long id : ids) {
                myCondition = this.iIndividualLocks.remove(id);
            }
            if (myCondition != null) {
                myCondition.signalAll();
            }
            this.iLog.debug((Object)("Unlocked: " + ids));
        }
        finally {
            this.iLock.unlock();
        }
    }

    public Set<Long> locked() {
        this.iLock.lock();
        try {
            TreeSet<Long> treeSet = new TreeSet<Long>(this.iIndividualLocks.keySet());
            return treeSet;
        }
        finally {
            this.iLock.unlock();
        }
    }

    public boolean isLocked(Long id) {
        this.iLock.lock();
        try {
            boolean bl = this.iIndividualLocks.containsKey(id);
            return bl;
        }
        finally {
            this.iLock.unlock();
        }
    }

    public static void main(String[] args) {
        try {
            Thread t;
            int i;
            final MultiLock lock = new MultiLock();
            for (i = 1; i <= 1000; ++i) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                int nrCourses = 2 + ToolBox.random((int)9);
                                HashSet<Long> courses = new HashSet<Long>();
                                Object s = "";
                                for (int i = 0; i < nrCourses; ++i) {
                                    long courseId;
                                    while (!courses.add(courseId = (long)ToolBox.random((int)10000))) {
                                    }
                                    s = (String)s + (i > 0 ? ", " : "") + courseId;
                                }
                                System.out.println(Thread.currentThread().getName() + "Locking: [" + (String)s + "]");
                                Unlock l = lock.lock(courses);
                                System.out.println(Thread.currentThread().getName() + "Locked: [" + (String)s + "]");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "Unlocking: [" + (String)s + "]");
                                l.release();
                                System.out.println(Thread.currentThread().getName() + "Unlocked: [" + (String)s + "]");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                            return;
                        }
                    }
                });
                t.setName("[T" + i + "]: ");
                t.start();
            }
            for (i = 1; i <= 3; ++i) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                try {
                                    Thread.sleep(ToolBox.random((int)5000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "Locking all...");
                                lock.lockAll();
                                System.out.println(Thread.currentThread().getName() + "All locked.");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "Unlocking all.");
                                lock.unlockAll();
                                System.out.println(Thread.currentThread().getName() + "All unlocked.");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                            return;
                        }
                    }
                });
                t.setName("[A" + i + "]: ");
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Unlock
    implements OnlineSectioningServer.Lock {
        private Collection<Long> iIds;

        private Unlock(Collection<Long> ids) {
            this.iIds = ids;
        }

        @Override
        public void release() {
            MultiLock.this.unlock(this.iIds);
        }
    }

    public class UnlockAll
    implements OnlineSectioningServer.Lock {
        private UnlockAll() {
        }

        @Override
        public void release() {
            MultiLock.this.unlockAll();
        }
    }
}

