/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.WaitList;

@MappedSuperclass
public abstract class BaseWaitList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iType;
    private Date iTimestamp;
    private Boolean iWaitListed;
    private String iChangedBy;
    private String iRequest;
    private String iEnrollment;
    private Date iWaitListedTimeStamp;
    private Student iStudent;
    private CourseOffering iCourseOffering;
    private CourseOffering iEnrolledCourse;
    private CourseDemand iCourseDemand;
    private CourseOffering iSwapCourseOffering;

    public BaseWaitList() {
    }

    public BaseWaitList(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="type", nullable=false, length=10)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @Column(name="timestamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @Column(name="waitlisted", nullable=false)
    public Boolean isWaitListed() {
        return this.iWaitListed;
    }

    @Transient
    public Boolean getWaitListed() {
        return this.iWaitListed;
    }

    public void setWaitListed(Boolean waitListed) {
        this.iWaitListed = waitListed;
    }

    @Column(name="changed_by", nullable=true, length=40)
    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    @Column(name="request", nullable=true, length=255)
    public String getRequest() {
        return this.iRequest;
    }

    public void setRequest(String request) {
        this.iRequest = request;
    }

    @Column(name="enrollment", nullable=true, length=255)
    public String getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(String enrollment) {
        this.iEnrollment = enrollment;
    }

    @Column(name="waitlist_ts", nullable=true)
    public Date getWaitListedTimeStamp() {
        return this.iWaitListedTimeStamp;
    }

    public void setWaitListedTimeStamp(Date waitListedTimeStamp) {
        this.iWaitListedTimeStamp = waitListedTimeStamp;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_offering_id", nullable=false)
    public CourseOffering getCourseOffering() {
        return this.iCourseOffering;
    }

    public void setCourseOffering(CourseOffering courseOffering) {
        this.iCourseOffering = courseOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="enrolled_course_id", nullable=true)
    public CourseOffering getEnrolledCourse() {
        return this.iEnrolledCourse;
    }

    public void setEnrolledCourse(CourseOffering enrolledCourse) {
        this.iEnrolledCourse = enrolledCourse;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="demand_id", nullable=true)
    public CourseDemand getCourseDemand() {
        return this.iCourseDemand;
    }

    public void setCourseDemand(CourseDemand courseDemand) {
        this.iCourseDemand = courseDemand;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="swap_course_id", nullable=true)
    public CourseOffering getSwapCourseOffering() {
        return this.iSwapCourseOffering;
    }

    public void setSwapCourseOffering(CourseOffering swapCourseOffering) {
        this.iSwapCourseOffering = swapCourseOffering;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WaitList)) {
            return false;
        }
        if (this.getUniqueId() == null || ((WaitList)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((WaitList)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "WaitList[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "WaitList[\n\tChangedBy: " + this.getChangedBy() + "\n\tCourseDemand: " + this.getCourseDemand() + "\n\tCourseOffering: " + this.getCourseOffering() + "\n\tEnrolledCourse: " + this.getEnrolledCourse() + "\n\tEnrollment: " + this.getEnrollment() + "\n\tRequest: " + this.getRequest() + "\n\tStudent: " + this.getStudent() + "\n\tSwapCourseOffering: " + this.getSwapCourseOffering() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tWaitListed: " + this.getWaitListed() + "\n\tWaitListedTimeStamp: " + this.getWaitListedTimeStamp() + "]";
    }
}

