/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TravelTime;

@MappedSuperclass
public abstract class BaseTravelTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iLocation1Id;
    private Long iLocation2Id;
    private Integer iDistance;
    private Session iSession;

    public BaseTravelTime() {
    }

    public BaseTravelTime(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="loc1_id", nullable=false)
    public Long getLocation1Id() {
        return this.iLocation1Id;
    }

    public void setLocation1Id(Long location1Id) {
        this.iLocation1Id = location1Id;
    }

    @Column(name="loc2_id", nullable=false)
    public Long getLocation2Id() {
        return this.iLocation2Id;
    }

    public void setLocation2Id(Long location2Id) {
        this.iLocation2Id = location2Id;
    }

    @Column(name="distance", nullable=false)
    public Integer getDistance() {
        return this.iDistance;
    }

    public void setDistance(Integer distance) {
        this.iDistance = distance;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TravelTime)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TravelTime)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TravelTime)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "TravelTime[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "TravelTime[\n\tDistance: " + this.getDistance() + "\n\tLocation1Id: " + this.getLocation1Id() + "\n\tLocation2Id: " + this.getLocation2Id() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

