/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;

@MappedSuperclass
public abstract class BaseTimePattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private Integer iMinPerMtg;
    private Integer iSlotsPerMtg;
    private Integer iNrMeetings;
    private Integer iBreakTime;
    private Integer iType;
    private Boolean iVisible;
    private Session iSession;
    private Set<TimePatternTime> iTimes;
    private Set<TimePatternDays> iDays;
    private Set<Department> iDepartments;

    public BaseTimePattern() {
    }

    public BaseTimePattern(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="time_pattern_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=true, length=50)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="mins_pmt", nullable=true, length=3)
    public Integer getMinPerMtg() {
        return this.iMinPerMtg;
    }

    public void setMinPerMtg(Integer minPerMtg) {
        this.iMinPerMtg = minPerMtg;
    }

    @Column(name="slots_pmt", nullable=true, length=3)
    public Integer getSlotsPerMtg() {
        return this.iSlotsPerMtg;
    }

    public void setSlotsPerMtg(Integer slotsPerMtg) {
        this.iSlotsPerMtg = slotsPerMtg;
    }

    @Column(name="nr_mtgs", nullable=true, length=3)
    public Integer getNrMeetings() {
        return this.iNrMeetings;
    }

    public void setNrMeetings(Integer nrMeetings) {
        this.iNrMeetings = nrMeetings;
    }

    @Column(name="break_time", nullable=true, length=3)
    public Integer getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(Integer breakTime) {
        this.iBreakTime = breakTime;
    }

    @Column(name="type", nullable=true, length=2)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @Column(name="visible", nullable=true)
    public Boolean isVisible() {
        return this.iVisible;
    }

    @Transient
    public Boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(Boolean visible) {
        this.iVisible = visible;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="time_pattern_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TimePatternTime> getTimes() {
        return this.iTimes;
    }

    public void setTimes(Set<TimePatternTime> times) {
        this.iTimes = times;
    }

    public void addToTimes(TimePatternTime timePatternTime) {
        if (this.iTimes == null) {
            this.iTimes = new HashSet<TimePatternTime>();
        }
        this.iTimes.add(timePatternTime);
    }

    @Deprecated
    public void addTotimes(TimePatternTime timePatternTime) {
        this.addToTimes(timePatternTime);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="time_pattern_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TimePatternDays> getDays() {
        return this.iDays;
    }

    public void setDays(Set<TimePatternDays> days) {
        this.iDays = days;
    }

    public void addToDays(TimePatternDays timePatternDays) {
        if (this.iDays == null) {
            this.iDays = new HashSet<TimePatternDays>();
        }
        this.iDays.add(timePatternDays);
    }

    @Deprecated
    public void addTodays(TimePatternDays timePatternDays) {
        this.addToDays(timePatternDays);
    }

    @ManyToMany(mappedBy="timePatterns")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addToDepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    @Deprecated
    public void addTodepartments(Department department) {
        this.addToDepartments(department);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimePattern)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TimePattern)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TimePattern)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "TimePattern[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "TimePattern[\n\tBreakTime: " + this.getBreakTime() + "\n\tMinPerMtg: " + this.getMinPerMtg() + "\n\tName: " + this.getName() + "\n\tNrMeetings: " + this.getNrMeetings() + "\n\tSession: " + this.getSession() + "\n\tSlotsPerMtg: " + this.getSlotsPerMtg() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tVisible: " + this.getVisible() + "]";
    }
}

