/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;

@MappedSuperclass
public abstract class BaseTeachingRequest
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iNbrInstructors;
    private Float iTeachingLoad;
    private Boolean iAssignCoordinator;
    private Integer iPercentShare;
    private InstructionalOffering iOffering;
    private PreferenceLevel iSameCoursePreference;
    private PreferenceLevel iSameCommonPart;
    private TeachingResponsibility iResponsibility;
    private Set<DepartmentalInstructor> iAssignedInstructors;
    private Set<TeachingClassRequest> iClassRequests;

    public BaseTeachingRequest() {
    }

    public BaseTeachingRequest(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="nbr_instructors", nullable=false)
    public Integer getNbrInstructors() {
        return this.iNbrInstructors;
    }

    public void setNbrInstructors(Integer nbrInstructors) {
        this.iNbrInstructors = nbrInstructors;
    }

    @Column(name="teaching_load", nullable=false)
    public Float getTeachingLoad() {
        return this.iTeachingLoad;
    }

    public void setTeachingLoad(Float teachingLoad) {
        this.iTeachingLoad = teachingLoad;
    }

    @Column(name="assign_coordinator", nullable=false)
    public Boolean isAssignCoordinator() {
        return this.iAssignCoordinator;
    }

    @Transient
    public Boolean getAssignCoordinator() {
        return this.iAssignCoordinator;
    }

    public void setAssignCoordinator(Boolean assignCoordinator) {
        this.iAssignCoordinator = assignCoordinator;
    }

    @Column(name="percent_share", nullable=false, length=3)
    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="offering_id", nullable=false)
    public InstructionalOffering getOffering() {
        return this.iOffering;
    }

    public void setOffering(InstructionalOffering offering) {
        this.iOffering = offering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="same_course_pref", nullable=true)
    public PreferenceLevel getSameCoursePreference() {
        return this.iSameCoursePreference;
    }

    public void setSameCoursePreference(PreferenceLevel sameCoursePreference) {
        this.iSameCoursePreference = sameCoursePreference;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="same_common_pref", nullable=true)
    public PreferenceLevel getSameCommonPart() {
        return this.iSameCommonPart;
    }

    public void setSameCommonPart(PreferenceLevel sameCommonPart) {
        this.iSameCommonPart = sameCommonPart;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="responsibility_id", nullable=true)
    public TeachingResponsibility getResponsibility() {
        return this.iResponsibility;
    }

    public void setResponsibility(TeachingResponsibility responsibility) {
        this.iResponsibility = responsibility;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="teachreq_instructor", joinColumns={@JoinColumn(name="request_id")}, inverseJoinColumns={@JoinColumn(name="instructor_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DepartmentalInstructor> getAssignedInstructors() {
        return this.iAssignedInstructors;
    }

    public void setAssignedInstructors(Set<DepartmentalInstructor> assignedInstructors) {
        this.iAssignedInstructors = assignedInstructors;
    }

    public void addToAssignedInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iAssignedInstructors == null) {
            this.iAssignedInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iAssignedInstructors.add(departmentalInstructor);
    }

    @Deprecated
    public void addToassignedInstructors(DepartmentalInstructor departmentalInstructor) {
        this.addToAssignedInstructors(departmentalInstructor);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="teachingRequest", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TeachingClassRequest> getClassRequests() {
        return this.iClassRequests;
    }

    public void setClassRequests(Set<TeachingClassRequest> classRequests) {
        this.iClassRequests = classRequests;
    }

    public void addToClassRequests(TeachingClassRequest teachingClassRequest) {
        if (this.iClassRequests == null) {
            this.iClassRequests = new HashSet<TeachingClassRequest>();
        }
        this.iClassRequests.add(teachingClassRequest);
    }

    @Deprecated
    public void addToclassRequests(TeachingClassRequest teachingClassRequest) {
        this.addToClassRequests(teachingClassRequest);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TeachingRequest)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TeachingRequest)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TeachingRequest)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "TeachingRequest[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "TeachingRequest[\n\tAssignCoordinator: " + this.getAssignCoordinator() + "\n\tNbrInstructors: " + this.getNbrInstructors() + "\n\tOffering: " + this.getOffering() + "\n\tPercentShare: " + this.getPercentShare() + "\n\tResponsibility: " + this.getResponsibility() + "\n\tSameCommonPart: " + this.getSameCommonPart() + "\n\tSameCoursePreference: " + this.getSameCoursePreference() + "\n\tTeachingLoad: " + this.getTeachingLoad() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

