/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;

@MappedSuperclass
public abstract class BaseTeachingClassRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPercentShare;
    private Boolean iLead;
    private Boolean iCanOverlap;
    private Boolean iAssignInstructor;
    private Boolean iCommon;
    private TeachingRequest iTeachingRequest;
    private Class_ iTeachingClass;

    public BaseTeachingClassRequest() {
    }

    public BaseTeachingClassRequest(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="percent_share", nullable=false)
    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    @Column(name="is_lead", nullable=false)
    public Boolean isLead() {
        return this.iLead;
    }

    @Transient
    public Boolean getLead() {
        return this.iLead;
    }

    public void setLead(Boolean lead) {
        this.iLead = lead;
    }

    @Column(name="can_overlap", nullable=false)
    public Boolean isCanOverlap() {
        return this.iCanOverlap;
    }

    @Transient
    public Boolean getCanOverlap() {
        return this.iCanOverlap;
    }

    public void setCanOverlap(Boolean canOverlap) {
        this.iCanOverlap = canOverlap;
    }

    @Column(name="assign_instructor", nullable=false)
    public Boolean isAssignInstructor() {
        return this.iAssignInstructor;
    }

    @Transient
    public Boolean getAssignInstructor() {
        return this.iAssignInstructor;
    }

    public void setAssignInstructor(Boolean assignInstructor) {
        this.iAssignInstructor = assignInstructor;
    }

    @Column(name="common", nullable=false)
    public Boolean isCommon() {
        return this.iCommon;
    }

    @Transient
    public Boolean getCommon() {
        return this.iCommon;
    }

    public void setCommon(Boolean common) {
        this.iCommon = common;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="request_id", nullable=false)
    public TeachingRequest getTeachingRequest() {
        return this.iTeachingRequest;
    }

    public void setTeachingRequest(TeachingRequest teachingRequest) {
        this.iTeachingRequest = teachingRequest;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="class_id", nullable=false)
    public Class_ getTeachingClass() {
        return this.iTeachingClass;
    }

    public void setTeachingClass(Class_ teachingClass) {
        this.iTeachingClass = teachingClass;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TeachingClassRequest)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TeachingClassRequest)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TeachingClassRequest)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "TeachingClassRequest[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "TeachingClassRequest[\n\tAssignInstructor: " + this.getAssignInstructor() + "\n\tCanOverlap: " + this.getCanOverlap() + "\n\tCommon: " + this.getCommon() + "\n\tLead: " + this.getLead() + "\n\tPercentShare: " + this.getPercentShare() + "\n\tTeachingClass: " + this.getTeachingClass() + "\n\tTeachingRequest: " + this.getTeachingRequest() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

