/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.TaskExecution;

@MappedSuperclass
public abstract class BaseTaskExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iExecutionDate;
    private Integer iExecutionPeriod;
    private Integer iExecutionStatus;
    private Date iCreatedDate;
    private Date iScheduledDate;
    private Date iQueuedDate;
    private Date iStartedDate;
    private Date iFinishedDate;
    private String iLogFile;
    private byte[] iOutputFile;
    private String iOutputName;
    private String iOutputContentType;
    private String iStatusMessage;
    private PeriodicTask iTask;

    public BaseTaskExecution() {
    }

    public BaseTaskExecution(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="exec_date", nullable=false)
    public Integer getExecutionDate() {
        return this.iExecutionDate;
    }

    public void setExecutionDate(Integer executionDate) {
        this.iExecutionDate = executionDate;
    }

    @Column(name="exec_period", nullable=false)
    public Integer getExecutionPeriod() {
        return this.iExecutionPeriod;
    }

    public void setExecutionPeriod(Integer executionPeriod) {
        this.iExecutionPeriod = executionPeriod;
    }

    @Column(name="status", nullable=false)
    public Integer getExecutionStatus() {
        return this.iExecutionStatus;
    }

    public void setExecutionStatus(Integer executionStatus) {
        this.iExecutionStatus = executionStatus;
    }

    @Column(name="created_date", nullable=false)
    public Date getCreatedDate() {
        return this.iCreatedDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.iCreatedDate = createdDate;
    }

    @Column(name="scheduled_date", nullable=false)
    public Date getScheduledDate() {
        return this.iScheduledDate;
    }

    public void setScheduledDate(Date scheduledDate) {
        this.iScheduledDate = scheduledDate;
    }

    @Column(name="queued_date", nullable=true)
    public Date getQueuedDate() {
        return this.iQueuedDate;
    }

    public void setQueuedDate(Date queuedDate) {
        this.iQueuedDate = queuedDate;
    }

    @Column(name="started_date", nullable=true)
    public Date getStartedDate() {
        return this.iStartedDate;
    }

    public void setStartedDate(Date startedDate) {
        this.iStartedDate = startedDate;
    }

    @Column(name="finished_date", nullable=true)
    public Date getFinishedDate() {
        return this.iFinishedDate;
    }

    public void setFinishedDate(Date finishedDate) {
        this.iFinishedDate = finishedDate;
    }

    @Column(name="log_file", nullable=true)
    public String getLogFile() {
        return this.iLogFile;
    }

    public void setLogFile(String logFile) {
        this.iLogFile = logFile;
    }

    @Column(name="output_file", nullable=true)
    public byte[] getOutputFile() {
        return this.iOutputFile;
    }

    public void setOutputFile(byte[] outputFile) {
        this.iOutputFile = outputFile;
    }

    @Column(name="output_name", nullable=true, length=260)
    public String getOutputName() {
        return this.iOutputName;
    }

    public void setOutputName(String outputName) {
        this.iOutputName = outputName;
    }

    @Column(name="output_content", nullable=true, length=260)
    public String getOutputContentType() {
        return this.iOutputContentType;
    }

    public void setOutputContentType(String outputContentType) {
        this.iOutputContentType = outputContentType;
    }

    @Column(name="status_message", nullable=true, length=260)
    public String getStatusMessage() {
        return this.iStatusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.iStatusMessage = statusMessage;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="task_id", nullable=false)
    public PeriodicTask getTask() {
        return this.iTask;
    }

    public void setTask(PeriodicTask task) {
        this.iTask = task;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TaskExecution)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TaskExecution)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TaskExecution)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "TaskExecution[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "TaskExecution[\n\tCreatedDate: " + this.getCreatedDate() + "\n\tExecutionDate: " + this.getExecutionDate() + "\n\tExecutionPeriod: " + this.getExecutionPeriod() + "\n\tExecutionStatus: " + this.getExecutionStatus() + "\n\tFinishedDate: " + this.getFinishedDate() + "\n\tLogFile: " + this.getLogFile() + "\n\tOutputContentType: " + this.getOutputContentType() + "\n\tOutputFile: " + this.getOutputFile() + "\n\tOutputName: " + this.getOutputName() + "\n\tQueuedDate: " + this.getQueuedDate() + "\n\tScheduledDate: " + this.getScheduledDate() + "\n\tStartedDate: " + this.getStartedDate() + "\n\tStatusMessage: " + this.getStatusMessage() + "\n\tTask: " + this.getTask() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

