/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;

@MappedSuperclass
public abstract class BaseSubjectArea
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iSubjectAreaAbbreviation;
    private String iTitle;
    private Session iSession;
    private Department iDepartment;
    private Department iFundingDept;
    private Set<CourseOffering> iCourseOfferings;

    public BaseSubjectArea() {
    }

    public BaseSubjectArea(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="subject_area_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="subject_area_abbreviation", nullable=false, length=20)
    public String getSubjectAreaAbbreviation() {
        return this.iSubjectAreaAbbreviation;
    }

    public void setSubjectAreaAbbreviation(String subjectAreaAbbreviation) {
        this.iSubjectAreaAbbreviation = subjectAreaAbbreviation;
    }

    @Column(name="long_title", nullable=false, length=100)
    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="department_uniqueid", nullable=false)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="funding_dept_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getFundingDept() {
        return this.iFundingDept;
    }

    public void setFundingDept(Department fundingDept) {
        this.iFundingDept = fundingDept;
    }

    @OneToMany(mappedBy="subjectArea", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseOffering> getCourseOfferings() {
        return this.iCourseOfferings;
    }

    public void setCourseOfferings(Set<CourseOffering> courseOfferings) {
        this.iCourseOfferings = courseOfferings;
    }

    public void addToCourseOfferings(CourseOffering courseOffering) {
        if (this.iCourseOfferings == null) {
            this.iCourseOfferings = new HashSet<CourseOffering>();
        }
        this.iCourseOfferings.add(courseOffering);
    }

    @Deprecated
    public void addTocourseOfferings(CourseOffering courseOffering) {
        this.addToCourseOfferings(courseOffering);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SubjectArea)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SubjectArea)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SubjectArea)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SubjectArea[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "SubjectArea[\n\tDepartment: " + this.getDepartment() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFundingDept: " + this.getFundingDept() + "\n\tSession: " + this.getSession() + "\n\tSubjectAreaAbbreviation: " + this.getSubjectAreaAbbreviation() + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

