/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectHistory;

@MappedSuperclass
public abstract class BaseStudentSectHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private byte[] iData;
    private Integer iType;
    private Date iTimestamp;
    private Student iStudent;

    public BaseStudentSectHistory() {
    }

    public BaseStudentSectHistory(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="data", nullable=false)
    public byte[] getData() {
        return this.iData;
    }

    public void setData(byte[] data) {
        this.iData = data;
    }

    @Column(name="type", nullable=false, length=10)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @Column(name="timestamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentSectHistory)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentSectHistory)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentSectHistory)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentSectHistory[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentSectHistory[\n\tData: " + this.getData() + "\n\tStudent: " + this.getStudent() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

