/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.StudentEnrollment;

@MappedSuperclass
public abstract class BaseStudentEnrollment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iStudentId;
    private Solution iSolution;
    private Class_ iClazz;

    public BaseStudentEnrollment() {
    }

    public BaseStudentEnrollment(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="student_enrl_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="student_id", nullable=false, length=20)
    public Long getStudentId() {
        return this.iStudentId;
    }

    public void setStudentId(Long studentId) {
        this.iStudentId = studentId;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="solution_id", nullable=false)
    public Solution getSolution() {
        return this.iSolution;
    }

    public void setSolution(Solution solution) {
        this.iSolution = solution;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="class_id", nullable=false)
    public Class_ getClazz() {
        return this.iClazz;
    }

    public void setClazz(Class_ clazz) {
        this.iClazz = clazz;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentEnrollment)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentEnrollment)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentEnrollment)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentEnrollment[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentEnrollment[\n\tClazz: " + this.getClazz() + "\n\tSolution: " + this.getSolution() + "\n\tStudentId: " + this.getStudentId() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

