/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;

@MappedSuperclass
public abstract class BaseStudentClassEnrollment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimestamp;
    private Date iApprovedDate;
    private String iApprovedBy;
    private String iChangedBy;
    private Student iStudent;
    private CourseRequest iCourseRequest;
    private CourseOffering iCourseOffering;
    private Class_ iClazz;

    public BaseStudentClassEnrollment() {
    }

    public BaseStudentClassEnrollment(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="timestamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @Column(name="approved_date", nullable=true)
    public Date getApprovedDate() {
        return this.iApprovedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.iApprovedDate = approvedDate;
    }

    @Column(name="approved_by", nullable=true, length=40)
    public String getApprovedBy() {
        return this.iApprovedBy;
    }

    public void setApprovedBy(String approvedBy) {
        this.iApprovedBy = approvedBy;
    }

    @Column(name="changed_by", nullable=true, length=40)
    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_request_id", nullable=true)
    public CourseRequest getCourseRequest() {
        return this.iCourseRequest;
    }

    public void setCourseRequest(CourseRequest courseRequest) {
        this.iCourseRequest = courseRequest;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_offering_id", nullable=true)
    public CourseOffering getCourseOffering() {
        return this.iCourseOffering;
    }

    public void setCourseOffering(CourseOffering courseOffering) {
        this.iCourseOffering = courseOffering;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="class_id", nullable=false)
    public Class_ getClazz() {
        return this.iClazz;
    }

    public void setClazz(Class_ clazz) {
        this.iClazz = clazz;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentClassEnrollment)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentClassEnrollment)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentClassEnrollment)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentClassEnrollment[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentClassEnrollment[\n\tApprovedBy: " + this.getApprovedBy() + "\n\tApprovedDate: " + this.getApprovedDate() + "\n\tChangedBy: " + this.getChangedBy() + "\n\tClazz: " + this.getClazz() + "\n\tCourseOffering: " + this.getCourseOffering() + "\n\tCourseRequest: " + this.getCourseRequest() + "\n\tStudent: " + this.getStudent() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

