/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;

@MappedSuperclass
public abstract class BaseStudentAccomodation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iAbbreviation;
    private String iExternalUniqueId;
    private Session iSession;
    private Set<Student> iStudents;

    public BaseStudentAccomodation() {
    }

    public BaseStudentAccomodation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=50)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="abbreviation", nullable=false, length=20)
    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="student_to_acomodation", joinColumns={@JoinColumn(name="accomodation_id")}, inverseJoinColumns={@JoinColumn(name="student_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addToStudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    @Deprecated
    public void addTostudents(Student student) {
        this.addToStudents(student);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentAccomodation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentAccomodation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentAccomodation)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentAccomodation[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "StudentAccomodation[\n\tAbbreviation: " + this.getAbbreviation() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tName: " + this.getName() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

