/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;

@MappedSuperclass
public abstract class BaseStudent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iEmail;
    private Integer iFreeTimeCategory;
    private Integer iSchedulePreference;
    private Float iMaxCredit;
    private Float iMinCredit;
    private Float iOverrideMaxCredit;
    private Integer iOverrideStatus;
    private String iOverrideExternalId;
    private Date iOverrideTimeStamp;
    private Integer iOverrideIntent;
    private String iPin;
    private Boolean iPinReleased;
    private Date iClassStartDate;
    private Date iClassEndDate;
    private Date iScheduleEmailedDate;
    private Session iSession;
    private StudentSectioningStatus iSectioningStatus;
    private Set<StudentAreaClassificationMajor> iAreaClasfMajors;
    private Set<StudentAreaClassificationMinor> iAreaClasfMinors;
    private Set<StudentAccomodation> iAccomodations;
    private Set<StudentGroup> iGroups;
    private Set<WaitList> iWaitlists;
    private Set<CourseDemand> iCourseDemands;
    private Set<StudentClassEnrollment> iClassEnrollments;
    private Set<LastLikeCourseDemand> iLastLikeCourseDemands;
    private Set<StudentNote> iNotes;
    private Set<Advisor> iAdvisors;
    private Set<AdvisorCourseRequest> iAdvisorCourseRequests;

    public BaseStudent() {
    }

    public BaseStudent(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="first_name", nullable=false, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="middle_name", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="last_name", nullable=false, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="free_time_cat", nullable=false, length=10)
    public Integer getFreeTimeCategory() {
        return this.iFreeTimeCategory;
    }

    public void setFreeTimeCategory(Integer freeTimeCategory) {
        this.iFreeTimeCategory = freeTimeCategory;
    }

    @Column(name="schedule_preference", nullable=false, length=10)
    public Integer getSchedulePreference() {
        return this.iSchedulePreference;
    }

    public void setSchedulePreference(Integer schedulePreference) {
        this.iSchedulePreference = schedulePreference;
    }

    @Column(name="max_credit", nullable=true)
    public Float getMaxCredit() {
        return this.iMaxCredit;
    }

    public void setMaxCredit(Float maxCredit) {
        this.iMaxCredit = maxCredit;
    }

    @Column(name="min_credit", nullable=true)
    public Float getMinCredit() {
        return this.iMinCredit;
    }

    public void setMinCredit(Float minCredit) {
        this.iMinCredit = minCredit;
    }

    @Column(name="req_credit", nullable=true)
    public Float getOverrideMaxCredit() {
        return this.iOverrideMaxCredit;
    }

    public void setOverrideMaxCredit(Float overrideMaxCredit) {
        this.iOverrideMaxCredit = overrideMaxCredit;
    }

    @Column(name="req_status", nullable=true, length=10)
    public Integer getOverrideStatus() {
        return this.iOverrideStatus;
    }

    public void setOverrideStatus(Integer overrideStatus) {
        this.iOverrideStatus = overrideStatus;
    }

    @Column(name="req_extid", nullable=true, length=40)
    public String getOverrideExternalId() {
        return this.iOverrideExternalId;
    }

    public void setOverrideExternalId(String overrideExternalId) {
        this.iOverrideExternalId = overrideExternalId;
    }

    @Column(name="req_ts", nullable=true)
    public Date getOverrideTimeStamp() {
        return this.iOverrideTimeStamp;
    }

    public void setOverrideTimeStamp(Date overrideTimeStamp) {
        this.iOverrideTimeStamp = overrideTimeStamp;
    }

    @Column(name="req_intent", nullable=true, length=10)
    public Integer getOverrideIntent() {
        return this.iOverrideIntent;
    }

    public void setOverrideIntent(Integer overrideIntent) {
        this.iOverrideIntent = overrideIntent;
    }

    @Column(name="pin", nullable=true, length=40)
    public String getPin() {
        return this.iPin;
    }

    public void setPin(String pin) {
        this.iPin = pin;
    }

    @Column(name="pin_released", nullable=true)
    public Boolean isPinReleased() {
        return this.iPinReleased;
    }

    @Transient
    public Boolean getPinReleased() {
        return this.iPinReleased;
    }

    public void setPinReleased(Boolean pinReleased) {
        this.iPinReleased = pinReleased;
    }

    @Column(name="class_start", nullable=true)
    public Date getClassStartDate() {
        return this.iClassStartDate;
    }

    public void setClassStartDate(Date classStartDate) {
        this.iClassStartDate = classStartDate;
    }

    @Column(name="class_end", nullable=true)
    public Date getClassEndDate() {
        return this.iClassEndDate;
    }

    public void setClassEndDate(Date classEndDate) {
        this.iClassEndDate = classEndDate;
    }

    @Column(name="schedule_emailed", nullable=true)
    public Date getScheduleEmailedDate() {
        return this.iScheduleEmailedDate;
    }

    public void setScheduleEmailedDate(Date scheduleEmailedDate) {
        this.iScheduleEmailedDate = scheduleEmailedDate;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="sect_status", nullable=true)
    public StudentSectioningStatus getSectioningStatus() {
        return this.iSectioningStatus;
    }

    public void setSectioningStatus(StudentSectioningStatus sectioningStatus) {
        this.iSectioningStatus = sectioningStatus;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentAreaClassificationMajor> getAreaClasfMajors() {
        return this.iAreaClasfMajors;
    }

    public void setAreaClasfMajors(Set<StudentAreaClassificationMajor> areaClasfMajors) {
        this.iAreaClasfMajors = areaClasfMajors;
    }

    public void addToAreaClasfMajors(StudentAreaClassificationMajor studentAreaClassificationMajor) {
        if (this.iAreaClasfMajors == null) {
            this.iAreaClasfMajors = new HashSet<StudentAreaClassificationMajor>();
        }
        this.iAreaClasfMajors.add(studentAreaClassificationMajor);
    }

    @Deprecated
    public void addToareaClasfMajors(StudentAreaClassificationMajor studentAreaClassificationMajor) {
        this.addToAreaClasfMajors(studentAreaClassificationMajor);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentAreaClassificationMinor> getAreaClasfMinors() {
        return this.iAreaClasfMinors;
    }

    public void setAreaClasfMinors(Set<StudentAreaClassificationMinor> areaClasfMinors) {
        this.iAreaClasfMinors = areaClasfMinors;
    }

    public void addToAreaClasfMinors(StudentAreaClassificationMinor studentAreaClassificationMinor) {
        if (this.iAreaClasfMinors == null) {
            this.iAreaClasfMinors = new HashSet<StudentAreaClassificationMinor>();
        }
        this.iAreaClasfMinors.add(studentAreaClassificationMinor);
    }

    @Deprecated
    public void addToareaClasfMinors(StudentAreaClassificationMinor studentAreaClassificationMinor) {
        this.addToAreaClasfMinors(studentAreaClassificationMinor);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="students")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentAccomodation> getAccomodations() {
        return this.iAccomodations;
    }

    public void setAccomodations(Set<StudentAccomodation> accomodations) {
        this.iAccomodations = accomodations;
    }

    public void addToAccomodations(StudentAccomodation studentAccomodation) {
        if (this.iAccomodations == null) {
            this.iAccomodations = new HashSet<StudentAccomodation>();
        }
        this.iAccomodations.add(studentAccomodation);
    }

    @Deprecated
    public void addToaccomodations(StudentAccomodation studentAccomodation) {
        this.addToAccomodations(studentAccomodation);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="students")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentGroup> getGroups() {
        return this.iGroups;
    }

    public void setGroups(Set<StudentGroup> groups) {
        this.iGroups = groups;
    }

    public void addToGroups(StudentGroup studentGroup) {
        if (this.iGroups == null) {
            this.iGroups = new HashSet<StudentGroup>();
        }
        this.iGroups.add(studentGroup);
    }

    @Deprecated
    public void addTogroups(StudentGroup studentGroup) {
        this.addToGroups(studentGroup);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<WaitList> getWaitlists() {
        return this.iWaitlists;
    }

    public void setWaitlists(Set<WaitList> waitlists) {
        this.iWaitlists = waitlists;
    }

    public void addToWaitlists(WaitList waitList) {
        if (this.iWaitlists == null) {
            this.iWaitlists = new HashSet<WaitList>();
        }
        this.iWaitlists.add(waitList);
    }

    @Deprecated
    public void addTowaitlists(WaitList waitList) {
        this.addToWaitlists(waitList);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseDemand> getCourseDemands() {
        return this.iCourseDemands;
    }

    public void setCourseDemands(Set<CourseDemand> courseDemands) {
        this.iCourseDemands = courseDemands;
    }

    public void addToCourseDemands(CourseDemand courseDemand) {
        if (this.iCourseDemands == null) {
            this.iCourseDemands = new HashSet<CourseDemand>();
        }
        this.iCourseDemands.add(courseDemand);
    }

    @Deprecated
    public void addTocourseDemands(CourseDemand courseDemand) {
        this.addToCourseDemands(courseDemand);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentClassEnrollment> getClassEnrollments() {
        return this.iClassEnrollments;
    }

    public void setClassEnrollments(Set<StudentClassEnrollment> classEnrollments) {
        this.iClassEnrollments = classEnrollments;
    }

    public void addToClassEnrollments(StudentClassEnrollment studentClassEnrollment) {
        if (this.iClassEnrollments == null) {
            this.iClassEnrollments = new HashSet<StudentClassEnrollment>();
        }
        this.iClassEnrollments.add(studentClassEnrollment);
    }

    @Deprecated
    public void addToclassEnrollments(StudentClassEnrollment studentClassEnrollment) {
        this.addToClassEnrollments(studentClassEnrollment);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<LastLikeCourseDemand> getLastLikeCourseDemands() {
        return this.iLastLikeCourseDemands;
    }

    public void setLastLikeCourseDemands(Set<LastLikeCourseDemand> lastLikeCourseDemands) {
        this.iLastLikeCourseDemands = lastLikeCourseDemands;
    }

    public void addToLastLikeCourseDemands(LastLikeCourseDemand lastLikeCourseDemand) {
        if (this.iLastLikeCourseDemands == null) {
            this.iLastLikeCourseDemands = new HashSet<LastLikeCourseDemand>();
        }
        this.iLastLikeCourseDemands.add(lastLikeCourseDemand);
    }

    @Deprecated
    public void addTolastLikeCourseDemands(LastLikeCourseDemand lastLikeCourseDemand) {
        this.addToLastLikeCourseDemands(lastLikeCourseDemand);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentNote> getNotes() {
        return this.iNotes;
    }

    public void setNotes(Set<StudentNote> notes) {
        this.iNotes = notes;
    }

    public void addToNotes(StudentNote studentNote) {
        if (this.iNotes == null) {
            this.iNotes = new HashSet<StudentNote>();
        }
        this.iNotes.add(studentNote);
    }

    @Deprecated
    public void addTonotes(StudentNote studentNote) {
        this.addToNotes(studentNote);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="students")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Advisor> getAdvisors() {
        return this.iAdvisors;
    }

    public void setAdvisors(Set<Advisor> advisors) {
        this.iAdvisors = advisors;
    }

    public void addToAdvisors(Advisor advisor) {
        if (this.iAdvisors == null) {
            this.iAdvisors = new HashSet<Advisor>();
        }
        this.iAdvisors.add(advisor);
    }

    @Deprecated
    public void addToadvisors(Advisor advisor) {
        this.addToAdvisors(advisor);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="student")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<AdvisorCourseRequest> getAdvisorCourseRequests() {
        return this.iAdvisorCourseRequests;
    }

    public void setAdvisorCourseRequests(Set<AdvisorCourseRequest> advisorCourseRequests) {
        this.iAdvisorCourseRequests = advisorCourseRequests;
    }

    public void addToAdvisorCourseRequests(AdvisorCourseRequest advisorCourseRequest) {
        if (this.iAdvisorCourseRequests == null) {
            this.iAdvisorCourseRequests = new HashSet<AdvisorCourseRequest>();
        }
        this.iAdvisorCourseRequests.add(advisorCourseRequest);
    }

    @Deprecated
    public void addToadvisorCourseRequests(AdvisorCourseRequest advisorCourseRequest) {
        this.addToAdvisorCourseRequests(advisorCourseRequest);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Student)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Student)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Student)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Student[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Student[\n\tClassEndDate: " + this.getClassEndDate() + "\n\tClassStartDate: " + this.getClassStartDate() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tFreeTimeCategory: " + this.getFreeTimeCategory() + "\n\tLastName: " + this.getLastName() + "\n\tMaxCredit: " + this.getMaxCredit() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tMinCredit: " + this.getMinCredit() + "\n\tOverrideExternalId: " + this.getOverrideExternalId() + "\n\tOverrideIntent: " + this.getOverrideIntent() + "\n\tOverrideMaxCredit: " + this.getOverrideMaxCredit() + "\n\tOverrideStatus: " + this.getOverrideStatus() + "\n\tOverrideTimeStamp: " + this.getOverrideTimeStamp() + "\n\tPin: " + this.getPin() + "\n\tPinReleased: " + this.getPinReleased() + "\n\tScheduleEmailedDate: " + this.getScheduleEmailedDate() + "\n\tSchedulePreference: " + this.getSchedulePreference() + "\n\tSectioningStatus: " + this.getSectioningStatus() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

