/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.Staff;

@MappedSuperclass
public abstract class BaseStaff
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iDept;
    private String iEmail;
    private String iAcademicTitle;
    private String iCampus;
    private PositionType iPositionType;

    public BaseStaff() {
    }

    public BaseStaff(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="staff_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="fname", nullable=true, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="mname", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="lname", nullable=false, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="dept", nullable=true, length=50)
    public String getDept() {
        return this.iDept;
    }

    public void setDept(String dept) {
        this.iDept = dept;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="acad_title", nullable=true, length=50)
    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    @Column(name="campus", nullable=true, length=20)
    public String getCampus() {
        return this.iCampus;
    }

    public void setCampus(String campus) {
        this.iCampus = campus;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="pos_type", nullable=true)
    public PositionType getPositionType() {
        return this.iPositionType;
    }

    public void setPositionType(PositionType positionType) {
        this.iPositionType = positionType;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Staff)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Staff)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Staff)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Staff[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Staff[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tCampus: " + this.getCampus() + "\n\tDept: " + this.getDept() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tPositionType: " + this.getPositionType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

