/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;

@MappedSuperclass
public abstract class BaseSolverParameterDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iDefault;
    private String iDescription;
    private String iType;
    private Integer iOrder;
    private Boolean iVisible;
    private SolverParameterGroup iGroup;

    public BaseSolverParameterDef() {
    }

    public BaseSolverParameterDef(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solver_parameter_def_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=true, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="default_value", nullable=true, length=2048)
    public String getDefault() {
        return this.iDefault;
    }

    public void setDefault(String defaultValue) {
        this.iDefault = defaultValue;
    }

    @Column(name="description", nullable=true, length=1000)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @Column(name="type", nullable=true, length=1000)
    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    @Column(name="ord", nullable=true, length=4)
    public Integer getOrder() {
        return this.iOrder;
    }

    public void setOrder(Integer order) {
        this.iOrder = order;
    }

    @Column(name="visible", nullable=true)
    public Boolean isVisible() {
        return this.iVisible;
    }

    @Transient
    public Boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(Boolean visible) {
        this.iVisible = visible;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="solver_param_group_id", nullable=false)
    public SolverParameterGroup getGroup() {
        return this.iGroup;
    }

    public void setGroup(SolverParameterGroup group) {
        this.iGroup = group;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverParameterDef)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverParameterDef)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverParameterDef)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverParameterDef[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SolverParameterDef[\n\tDefault: " + this.getDefault() + "\n\tDescription: " + this.getDescription() + "\n\tGroup: " + this.getGroup() + "\n\tName: " + this.getName() + "\n\tOrder: " + this.getOrder() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tVisible: " + this.getVisible() + "]";
    }
}

