/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;

@MappedSuperclass
public abstract class BaseSolverParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iValue;
    private SolverParameterDef iDefinition;

    public BaseSolverParameter() {
    }

    public BaseSolverParameter(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solver_parameter_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="value", nullable=true, length=2048)
    public String getValue() {
        return this.iValue;
    }

    public void setValue(String value) {
        this.iValue = value;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="solver_param_def_id", nullable=false)
    public SolverParameterDef getDefinition() {
        return this.iDefinition;
    }

    public void setDefinition(SolverParameterDef definition) {
        this.iDefinition = definition;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverParameter)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverParameter)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverParameter)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverParameter[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "SolverParameter[\n\tDefinition: " + this.getDefinition() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tValue: " + this.getValue() + "]";
    }
}

