/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.SolverInfoDef;

@MappedSuperclass
public abstract class BaseSolverInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private byte[] iData;
    private String iOpt;
    private SolverInfoDef iDefinition;

    public BaseSolverInfo() {
    }

    public BaseSolverInfo(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solver_info_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="value", nullable=false)
    public byte[] getData() {
        return this.iData;
    }

    public void setData(byte[] data) {
        this.iData = data;
    }

    @Column(name="opt", nullable=true, length=250)
    public String getOpt() {
        return this.iOpt;
    }

    public void setOpt(String opt) {
        this.iOpt = opt;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="solver_info_def_id", nullable=true)
    public SolverInfoDef getDefinition() {
        return this.iDefinition;
    }

    public void setDefinition(SolverInfoDef definition) {
        this.iDefinition = definition;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverInfo)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverInfo)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverInfo)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverInfo[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "SolverInfo[\n\tData: " + this.getData() + "\n\tDefinition: " + this.getDefinition() + "\n\tOpt: " + this.getOpt() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

