/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BaseSolverGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iAbbv;
    private Session iSession;
    private Set<TimetableManager> iTimetableManagers;
    private Set<Department> iDepartments;
    private Set<Solution> iSolutions;

    public BaseSolverGroup() {
    }

    public BaseSolverGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solver_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=50)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="abbv", nullable=false, length=50)
    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany
    @JoinTable(name="solver_gr_to_tt_mgr", joinColumns={@JoinColumn(name="solver_group_id")}, inverseJoinColumns={@JoinColumn(name="timetable_mgr_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TimetableManager> getTimetableManagers() {
        return this.iTimetableManagers;
    }

    public void setTimetableManagers(Set<TimetableManager> timetableManagers) {
        this.iTimetableManagers = timetableManagers;
    }

    public void addToTimetableManagers(TimetableManager timetableManager) {
        if (this.iTimetableManagers == null) {
            this.iTimetableManagers = new HashSet<TimetableManager>();
        }
        this.iTimetableManagers.add(timetableManager);
    }

    @Deprecated
    public void addTotimetableManagers(TimetableManager timetableManager) {
        this.addToTimetableManagers(timetableManager);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="solverGroup")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addToDepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    @Deprecated
    public void addTodepartments(Department department) {
        this.addToDepartments(department);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="owner", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Solution> getSolutions() {
        return this.iSolutions;
    }

    public void setSolutions(Set<Solution> solutions) {
        this.iSolutions = solutions;
    }

    public void addToSolutions(Solution solution) {
        if (this.iSolutions == null) {
            this.iSolutions = new HashSet<Solution>();
        }
        this.iSolutions.add(solution);
    }

    @Deprecated
    public void addTosolutions(Solution solution) {
        this.addToSolutions(solution);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverGroup[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SolverGroup[\n\tAbbv: " + this.getAbbv() + "\n\tName: " + this.getName() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

