/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;

@MappedSuperclass
public abstract class BaseSession
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iAcademicInitiative;
    private String iAcademicYear;
    private String iAcademicTerm;
    private Date iSessionBeginDateTime;
    private Date iClassesEndDateTime;
    private Date iSessionEndDateTime;
    private Date iExamBeginDate;
    private Date iEventBeginDate;
    private Date iEventEndDate;
    private String iHolidays;
    private Date iNotificationsBeginDate;
    private Date iNotificationsEndDate;
    private Integer iLastWeekToEnroll;
    private Integer iLastWeekToChange;
    private Integer iLastWeekToDrop;
    private DepartmentStatusType iStatusType;
    private DatePattern iDefaultDatePattern;
    private StudentSectioningStatus iDefaultSectioningStatus;
    private ClassDurationType iDefaultClassDurationType;
    private InstructionalMethod iDefaultInstructionalMethod;
    private Set<SubjectArea> iSubjectAreas;
    private Set<Building> iBuildings;
    private Set<Department> iDepartments;
    private Set<Location> iRooms;
    private Set<InstructionalOffering> iInstructionalOfferings;

    public BaseSession() {
    }

    public BaseSession(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="academic_initiative", nullable=false, length=20)
    public String getAcademicInitiative() {
        return this.iAcademicInitiative;
    }

    public void setAcademicInitiative(String academicInitiative) {
        this.iAcademicInitiative = academicInitiative;
    }

    @Column(name="academic_year", nullable=false, length=4)
    public String getAcademicYear() {
        return this.iAcademicYear;
    }

    public void setAcademicYear(String academicYear) {
        this.iAcademicYear = academicYear;
    }

    @Column(name="academic_term", nullable=false, length=20)
    public String getAcademicTerm() {
        return this.iAcademicTerm;
    }

    public void setAcademicTerm(String academicTerm) {
        this.iAcademicTerm = academicTerm;
    }

    @Column(name="session_begin_date_time", nullable=false)
    public Date getSessionBeginDateTime() {
        return this.iSessionBeginDateTime;
    }

    public void setSessionBeginDateTime(Date sessionBeginDateTime) {
        this.iSessionBeginDateTime = sessionBeginDateTime;
    }

    @Column(name="classes_end_date_time", nullable=false)
    public Date getClassesEndDateTime() {
        return this.iClassesEndDateTime;
    }

    public void setClassesEndDateTime(Date classesEndDateTime) {
        this.iClassesEndDateTime = classesEndDateTime;
    }

    @Column(name="session_end_date_time", nullable=false)
    public Date getSessionEndDateTime() {
        return this.iSessionEndDateTime;
    }

    public void setSessionEndDateTime(Date sessionEndDateTime) {
        this.iSessionEndDateTime = sessionEndDateTime;
    }

    @Column(name="exam_begin_date", nullable=false)
    public Date getExamBeginDate() {
        return this.iExamBeginDate;
    }

    public void setExamBeginDate(Date examBeginDate) {
        this.iExamBeginDate = examBeginDate;
    }

    @Column(name="event_begin_date", nullable=false)
    public Date getEventBeginDate() {
        return this.iEventBeginDate;
    }

    public void setEventBeginDate(Date eventBeginDate) {
        this.iEventBeginDate = eventBeginDate;
    }

    @Column(name="event_end_date", nullable=false)
    public Date getEventEndDate() {
        return this.iEventEndDate;
    }

    public void setEventEndDate(Date eventEndDate) {
        this.iEventEndDate = eventEndDate;
    }

    @Column(name="holidays", nullable=true, length=366)
    public String getHolidays() {
        return this.iHolidays;
    }

    public void setHolidays(String holidays) {
        this.iHolidays = holidays;
    }

    @Column(name="notifications_begin", nullable=true)
    public Date getNotificationsBeginDate() {
        return this.iNotificationsBeginDate;
    }

    public void setNotificationsBeginDate(Date notificationsBeginDate) {
        this.iNotificationsBeginDate = notificationsBeginDate;
    }

    @Column(name="notifications_end", nullable=true)
    public Date getNotificationsEndDate() {
        return this.iNotificationsEndDate;
    }

    public void setNotificationsEndDate(Date notificationsEndDate) {
        this.iNotificationsEndDate = notificationsEndDate;
    }

    @Column(name="wk_enroll", nullable=false)
    public Integer getLastWeekToEnroll() {
        return this.iLastWeekToEnroll;
    }

    public void setLastWeekToEnroll(Integer lastWeekToEnroll) {
        this.iLastWeekToEnroll = lastWeekToEnroll;
    }

    @Column(name="wk_change", nullable=false)
    public Integer getLastWeekToChange() {
        return this.iLastWeekToChange;
    }

    public void setLastWeekToChange(Integer lastWeekToChange) {
        this.iLastWeekToChange = lastWeekToChange;
    }

    @Column(name="wk_drop", nullable=false)
    public Integer getLastWeekToDrop() {
        return this.iLastWeekToDrop;
    }

    public void setLastWeekToDrop(Integer lastWeekToDrop) {
        this.iLastWeekToDrop = lastWeekToDrop;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="status_type", nullable=false)
    public DepartmentStatusType getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(DepartmentStatusType statusType) {
        this.iStatusType = statusType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="def_datepatt_id", nullable=true)
    public DatePattern getDefaultDatePattern() {
        return this.iDefaultDatePattern;
    }

    public void setDefaultDatePattern(DatePattern defaultDatePattern) {
        this.iDefaultDatePattern = defaultDatePattern;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="sect_status", nullable=true)
    public StudentSectioningStatus getDefaultSectioningStatus() {
        return this.iDefaultSectioningStatus;
    }

    public void setDefaultSectioningStatus(StudentSectioningStatus defaultSectioningStatus) {
        this.iDefaultSectioningStatus = defaultSectioningStatus;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="duration_type_id", nullable=true)
    public ClassDurationType getDefaultClassDurationType() {
        return this.iDefaultClassDurationType;
    }

    public void setDefaultClassDurationType(ClassDurationType defaultClassDurationType) {
        this.iDefaultClassDurationType = defaultClassDurationType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="instr_method_id", nullable=true)
    public InstructionalMethod getDefaultInstructionalMethod() {
        return this.iDefaultInstructionalMethod;
    }

    public void setDefaultInstructionalMethod(InstructionalMethod defaultInstructionalMethod) {
        this.iDefaultInstructionalMethod = defaultInstructionalMethod;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="session", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SubjectArea> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Set<SubjectArea> subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public void addToSubjectAreas(SubjectArea subjectArea) {
        if (this.iSubjectAreas == null) {
            this.iSubjectAreas = new HashSet<SubjectArea>();
        }
        this.iSubjectAreas.add(subjectArea);
    }

    @Deprecated
    public void addTosubjectAreas(SubjectArea subjectArea) {
        this.addToSubjectAreas(subjectArea);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="session", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Building> getBuildings() {
        return this.iBuildings;
    }

    public void setBuildings(Set<Building> buildings) {
        this.iBuildings = buildings;
    }

    public void addToBuildings(Building building) {
        if (this.iBuildings == null) {
            this.iBuildings = new HashSet<Building>();
        }
        this.iBuildings.add(building);
    }

    @Deprecated
    public void addTobuildings(Building building) {
        this.addToBuildings(building);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="session", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addToDepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    @Deprecated
    public void addTodepartments(Department department) {
        this.addToDepartments(department);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="session", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addToRooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    @Deprecated
    public void addTorooms(Location location) {
        this.addToRooms(location);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="session", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstructionalOffering> getInstructionalOfferings() {
        return this.iInstructionalOfferings;
    }

    public void setInstructionalOfferings(Set<InstructionalOffering> instructionalOfferings) {
        this.iInstructionalOfferings = instructionalOfferings;
    }

    public void addToInstructionalOfferings(InstructionalOffering instructionalOffering) {
        if (this.iInstructionalOfferings == null) {
            this.iInstructionalOfferings = new HashSet<InstructionalOffering>();
        }
        this.iInstructionalOfferings.add(instructionalOffering);
    }

    @Deprecated
    public void addToinstructionalOfferings(InstructionalOffering instructionalOffering) {
        this.addToInstructionalOfferings(instructionalOffering);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Session)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Session)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Session)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Session[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "Session[\n\tAcademicInitiative: " + this.getAcademicInitiative() + "\n\tAcademicTerm: " + this.getAcademicTerm() + "\n\tAcademicYear: " + this.getAcademicYear() + "\n\tClassesEndDateTime: " + this.getClassesEndDateTime() + "\n\tDefaultClassDurationType: " + this.getDefaultClassDurationType() + "\n\tDefaultDatePattern: " + this.getDefaultDatePattern() + "\n\tDefaultInstructionalMethod: " + this.getDefaultInstructionalMethod() + "\n\tDefaultSectioningStatus: " + this.getDefaultSectioningStatus() + "\n\tEventBeginDate: " + this.getEventBeginDate() + "\n\tEventEndDate: " + this.getEventEndDate() + "\n\tExamBeginDate: " + this.getExamBeginDate() + "\n\tHolidays: " + this.getHolidays() + "\n\tLastWeekToChange: " + this.getLastWeekToChange() + "\n\tLastWeekToDrop: " + this.getLastWeekToDrop() + "\n\tLastWeekToEnroll: " + this.getLastWeekToEnroll() + "\n\tNotificationsBeginDate: " + this.getNotificationsBeginDate() + "\n\tNotificationsEndDate: " + this.getNotificationsEndDate() + "\n\tSessionBeginDateTime: " + this.getSessionBeginDateTime() + "\n\tSessionEndDateTime: " + this.getSessionEndDateTime() + "\n\tStatusType: " + this.getStatusType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

