/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BaseSectioningSolutionLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimeStamp;
    private String iInfo;
    private byte[] iData;
    private String iNote;
    private String iConfig;
    private Session iSession;
    private TimetableManager iOwner;

    public BaseSectioningSolutionLog() {
    }

    public BaseSectioningSolutionLog(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="info", nullable=false, length=10000)
    public String getInfo() {
        return this.iInfo;
    }

    public void setInfo(String info) {
        this.iInfo = info;
    }

    @Column(name="data", nullable=false)
    public byte[] getData() {
        return this.iData;
    }

    public void setData(byte[] data) {
        this.iData = data;
    }

    @Column(name="note", nullable=true, length=2000)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="config", nullable=true, length=100)
    public String getConfig() {
        return this.iConfig;
    }

    public void setConfig(String config) {
        this.iConfig = config;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="owner_id", nullable=false)
    public TimetableManager getOwner() {
        return this.iOwner;
    }

    public void setOwner(TimetableManager owner) {
        this.iOwner = owner;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SectioningSolutionLog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SectioningSolutionLog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SectioningSolutionLog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SectioningSolutionLog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "SectioningSolutionLog[\n\tConfig: " + this.getConfig() + "\n\tData: " + this.getData() + "\n\tInfo: " + this.getInfo() + "\n\tNote: " + this.getNote() + "\n\tOwner: " + this.getOwner() + "\n\tSession: " + this.getSession() + "\n\tTimeStamp: " + this.getTimeStamp() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

