/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;

@MappedSuperclass
public abstract class BaseSavedHQL
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iDescription;
    private String iQuery;
    private Integer iType;
    private Set<SavedHQLParameter> iParameters;

    public BaseSavedHQL() {
    }

    public BaseSavedHQL(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="description", nullable=true, length=1000)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @Column(name="query", nullable=false)
    public String getQuery() {
        return this.iQuery;
    }

    public void setQuery(String query) {
        this.iQuery = query;
    }

    @Column(name="type", nullable=false, length=10)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @OneToMany(mappedBy="savedHQL", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SavedHQLParameter> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<SavedHQLParameter> parameters) {
        this.iParameters = parameters;
    }

    public void addToParameters(SavedHQLParameter savedHQLParameter) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<SavedHQLParameter>();
        }
        this.iParameters.add(savedHQLParameter);
    }

    @Deprecated
    public void addToparameters(SavedHQLParameter savedHQLParameter) {
        this.addToParameters(savedHQLParameter);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SavedHQL)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SavedHQL)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SavedHQL)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SavedHQL[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SavedHQL[\n\tDescription: " + this.getDescription() + "\n\tName: " + this.getName() + "\n\tQuery: " + this.getQuery() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

