/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.base.RoomTypeOptionId;

@MappedSuperclass
@IdClass(value=RoomTypeOptionId.class)
public abstract class BaseRoomTypeOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RoomType iRoomType;
    private Department iDepartment;
    private Integer iStatus;
    private String iMessage;
    private Integer iBreakTime;
    private String iEventEmail;

    @Id
    @ManyToOne(optional=false)
    @JoinColumn(name="room_type")
    public RoomType getRoomType() {
        return this.iRoomType;
    }

    public void setRoomType(RoomType roomType) {
        this.iRoomType = roomType;
    }

    @Id
    @ManyToOne(optional=false)
    @JoinColumn(name="department_id")
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @Column(name="status", nullable=false, length=10)
    public Integer getStatus() {
        return this.iStatus;
    }

    public void setStatus(Integer status) {
        this.iStatus = status;
    }

    @Column(name="message", nullable=true, length=2048)
    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    @Column(name="break_time", nullable=false)
    public Integer getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(Integer breakTime) {
        this.iBreakTime = breakTime;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEventEmail() {
        return this.iEventEmail;
    }

    public void setEventEmail(String eventEmail) {
        this.iEventEmail = eventEmail;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomTypeOption)) {
            return false;
        }
        RoomTypeOption roomTypeOption = (RoomTypeOption)o;
        if (this.getRoomType() == null || roomTypeOption.getRoomType() == null || !this.getRoomType().equals(roomTypeOption.getRoomType())) {
            return false;
        }
        return this.getDepartment() != null && roomTypeOption.getDepartment() != null && this.getDepartment().equals(roomTypeOption.getDepartment());
    }

    public int hashCode() {
        if (this.getRoomType() == null || this.getDepartment() == null) {
            return super.hashCode();
        }
        return this.getRoomType().hashCode() ^ this.getDepartment().hashCode();
    }

    public String toString() {
        return "RoomTypeOption[" + this.getRoomType() + ", " + this.getDepartment() + "]";
    }

    public String toDebugString() {
        return "RoomTypeOption[\n\tBreakTime: " + this.getBreakTime() + "\n\tDepartment: " + this.getDepartment() + "\n\tEventEmail: " + this.getEventEmail() + "\n\tMessage: " + this.getMessage() + "\n\tRoomType: " + this.getRoomType() + "\n\tStatus: " + this.getStatus() + "]";
    }
}

