/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPicture;

@MappedSuperclass
public abstract class BaseRoomPicture
extends LocationPicture
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Room iLocation;

    public BaseRoomPicture() {
    }

    public BaseRoomPicture(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Override
    @ManyToOne(optional=false)
    @JoinColumn(name="location_id", nullable=false)
    public Room getLocation() {
        return this.iLocation;
    }

    public void setLocation(Room location) {
        this.iLocation = location;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomPicture)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomPicture)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomPicture)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "RoomPicture[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "RoomPicture[\n\tContentType: " + this.getContentType() + "\n\tDataFile: " + this.getDataFile() + "\n\tFileName: " + this.getFileName() + "\n\tLocation: " + this.getLocation() + "\n\tTimeStamp: " + this.getTimeStamp() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

