/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPicture;

@MappedSuperclass
public abstract class BaseRoom
extends Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iBuildingAbbv;
    private String iRoomNumber;
    private String iClassification;
    private Building iBuilding;
    private Room iParentRoom;
    private Set<RoomPicture> iPictures;
    private Set<EventServiceProvider> iAllowedServices;
    private Set<Room> iPartitions;

    public BaseRoom() {
    }

    public BaseRoom(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Formula(value=" (select b.abbreviation from %SCHEMA%.building b where b.uniqueid = building_id) ")
    public String getBuildingAbbv() {
        return this.iBuildingAbbv;
    }

    public void setBuildingAbbv(String buildingAbbv) {
        this.iBuildingAbbv = buildingAbbv;
    }

    @Column(name="room_number", nullable=false, length=40)
    public String getRoomNumber() {
        return this.iRoomNumber;
    }

    public void setRoomNumber(String roomNumber) {
        this.iRoomNumber = roomNumber;
    }

    @Column(name="classification", nullable=true, length=20)
    public String getClassification() {
        return this.iClassification;
    }

    public void setClassification(String classification) {
        this.iClassification = classification;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="building_id", nullable=false)
    public Building getBuilding() {
        return this.iBuilding;
    }

    public void setBuilding(Building building) {
        this.iBuilding = building;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="parent_room_id", nullable=true)
    public Room getParentRoom() {
        return this.iParentRoom;
    }

    public void setParentRoom(Room parentRoom) {
        this.iParentRoom = parentRoom;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="location", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<RoomPicture> getPictures() {
        return this.iPictures;
    }

    public void setPictures(Set<RoomPicture> pictures) {
        this.iPictures = pictures;
    }

    public void addToPictures(RoomPicture roomPicture) {
        if (this.iPictures == null) {
            this.iPictures = new HashSet<RoomPicture>();
        }
        this.iPictures.add(roomPicture);
    }

    @Deprecated
    public void addTopictures(RoomPicture roomPicture) {
        this.addToPictures(roomPicture);
    }

    @Override
    @ManyToMany
    @JoinTable(name="room_service_provider", joinColumns={@JoinColumn(name="location_id")}, inverseJoinColumns={@JoinColumn(name="provider_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<EventServiceProvider> getAllowedServices() {
        return this.iAllowedServices;
    }

    @Override
    public void setAllowedServices(Set<EventServiceProvider> allowedServices) {
        this.iAllowedServices = allowedServices;
    }

    public void addToAllowedServices(EventServiceProvider eventServiceProvider) {
        if (this.iAllowedServices == null) {
            this.iAllowedServices = new HashSet<EventServiceProvider>();
        }
        this.iAllowedServices.add(eventServiceProvider);
    }

    @Deprecated
    public void addToallowedServices(EventServiceProvider eventServiceProvider) {
        this.addToAllowedServices(eventServiceProvider);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentRoom")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Room> getPartitions() {
        return this.iPartitions;
    }

    public void setPartitions(Set<Room> partitions) {
        this.iPartitions = partitions;
    }

    public void addToPartitions(Room room) {
        if (this.iPartitions == null) {
            this.iPartitions = new HashSet<Room>();
        }
        this.iPartitions.add(room);
    }

    @Deprecated
    public void addTopartitions(Room room) {
        this.addToPartitions(room);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Room)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Room)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Room)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Room[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "Room[\n\tArea: " + this.getArea() + "\n\tBreakTime: " + this.getBreakTime() + "\n\tBuilding: " + this.getBuilding() + "\n\tCapacity: " + this.getCapacity() + "\n\tClassification: " + this.getClassification() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tEventAvailability: " + this.getEventAvailability() + "\n\tEventDepartment: " + this.getEventDepartment() + "\n\tEventEmail: " + this.getEventEmail() + "\n\tEventStatus: " + this.getEventStatus() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIgnoreRoomCheck: " + this.getIgnoreRoomCheck() + "\n\tIgnoreTooFar: " + this.getIgnoreTooFar() + "\n\tManagerIds: " + this.getManagerIds() + "\n\tNote: " + this.getNote() + "\n\tParentRoom: " + this.getParentRoom() + "\n\tPattern: " + this.getPattern() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tRoomNumber: " + this.getRoomNumber() + "\n\tRoomType: " + this.getRoomType() + "\n\tSession: " + this.getSession() + "\n\tShareNote: " + this.getShareNote() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

