/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Reservation;

@MappedSuperclass
public abstract class BaseReservation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iExpirationDate;
    private Integer iLimit;
    private Date iStartDate;
    private Boolean iInclusive;
    private InstructionalOffering iInstructionalOffering;
    private Set<InstrOfferingConfig> iConfigurations;
    private Set<Class_> iClasses;

    public BaseReservation() {
    }

    public BaseReservation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="reservation_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="expiration_date", nullable=true)
    public Date getExpirationDate() {
        return this.iExpirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.iExpirationDate = expirationDate;
    }

    @Column(name="reservation_limit", nullable=true)
    public Integer getLimit() {
        return this.iLimit;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    @Column(name="start_date", nullable=true)
    public Date getStartDate() {
        return this.iStartDate;
    }

    public void setStartDate(Date startDate) {
        this.iStartDate = startDate;
    }

    @Column(name="inclusive", nullable=true)
    public Boolean isInclusive() {
        return this.iInclusive;
    }

    @Transient
    public Boolean getInclusive() {
        return this.iInclusive;
    }

    public void setInclusive(Boolean inclusive) {
        this.iInclusive = inclusive;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="offering_id", nullable=false)
    public InstructionalOffering getInstructionalOffering() {
        return this.iInstructionalOffering;
    }

    public void setInstructionalOffering(InstructionalOffering instructionalOffering) {
        this.iInstructionalOffering = instructionalOffering;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_config", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="config_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstrOfferingConfig> getConfigurations() {
        return this.iConfigurations;
    }

    public void setConfigurations(Set<InstrOfferingConfig> configurations) {
        this.iConfigurations = configurations;
    }

    public void addToConfigurations(InstrOfferingConfig instrOfferingConfig) {
        if (this.iConfigurations == null) {
            this.iConfigurations = new HashSet<InstrOfferingConfig>();
        }
        this.iConfigurations.add(instrOfferingConfig);
    }

    @Deprecated
    public void addToconfigurations(InstrOfferingConfig instrOfferingConfig) {
        this.addToConfigurations(instrOfferingConfig);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_class", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="class_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Class_> getClasses() {
        return this.iClasses;
    }

    public void setClasses(Set<Class_> classes) {
        this.iClasses = classes;
    }

    public void addToClasses(Class_ class_) {
        if (this.iClasses == null) {
            this.iClasses = new HashSet<Class_>();
        }
        this.iClasses.add(class_);
    }

    @Deprecated
    public void addToclasses(Class_ class_) {
        this.addToClasses(class_);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Reservation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Reservation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Reservation)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Reservation[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Reservation[\n\tExpirationDate: " + this.getExpirationDate() + "\n\tInclusive: " + this.getInclusive() + "\n\tInstructionalOffering: " + this.getInstructionalOffering() + "\n\tLimit: " + this.getLimit() + "\n\tStartDate: " + this.getStartDate() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

