/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.QueryLog;

@MappedSuperclass
public abstract class BaseQueryLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimeStamp;
    private Long iTimeSpent;
    private String iUri;
    private Integer iType;
    private String iSessionId;
    private String iUid;
    private String iQuery;
    private String iException;

    public BaseQueryLog() {
    }

    public BaseQueryLog(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="time_spent", nullable=false)
    public Long getTimeSpent() {
        return this.iTimeSpent;
    }

    public void setTimeSpent(Long timeSpent) {
        this.iTimeSpent = timeSpent;
    }

    @Column(name="uri", nullable=false, length=255)
    public String getUri() {
        return this.iUri;
    }

    public void setUri(String uri) {
        this.iUri = uri;
    }

    @Column(name="type", nullable=false)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @Column(name="session_id", nullable=true, length=32)
    public String getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(String sessionId) {
        this.iSessionId = sessionId;
    }

    @Column(name="userid", nullable=true, length=40)
    public String getUid() {
        return this.iUid;
    }

    public void setUid(String uid) {
        this.iUid = uid;
    }

    @Column(name="query", nullable=true)
    public String getQuery() {
        return this.iQuery;
    }

    public void setQuery(String query) {
        this.iQuery = query;
    }

    @Column(name="exception", nullable=true)
    public String getException() {
        return this.iException;
    }

    public void setException(String exception) {
        this.iException = exception;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof QueryLog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((QueryLog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((QueryLog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "QueryLog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "QueryLog[\n\tException: " + this.getException() + "\n\tQuery: " + this.getQuery() + "\n\tSessionId: " + this.getSessionId() + "\n\tTimeSpent: " + this.getTimeSpent() + "\n\tTimeStamp: " + this.getTimeStamp() + "\n\tType: " + this.getType() + "\n\tUid: " + this.getUid() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUri: " + this.getUri() + "]";
    }
}

