/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;

@MappedSuperclass
public abstract class BasePreference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iNote;
    private PreferenceGroup iOwner;
    private PreferenceLevel iPrefLevel;

    public BasePreference() {
    }

    public BasePreference(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="note", nullable=true, length=2048)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="owner_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public PreferenceGroup getOwner() {
        if (this.iOwner != null && this.iOwner instanceof HibernateProxy) {
            this.iOwner = (PreferenceGroup)Hibernate.unproxy((Object)this.iOwner);
        }
        return this.iOwner;
    }

    public void setOwner(PreferenceGroup owner) {
        this.iOwner = owner;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pref_level_id", nullable=false)
    public PreferenceLevel getPrefLevel() {
        return this.iPrefLevel;
    }

    public void setPrefLevel(PreferenceLevel prefLevel) {
        this.iPrefLevel = prefLevel;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Preference)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Preference)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Preference)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Preference[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Preference[\n\tNote: " + this.getNote() + "\n\tOwner: " + this.getOwner() + "\n\tPrefLevel: " + this.getPrefLevel() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

