/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;

@MappedSuperclass
public abstract class BasePosMajorConcentration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iCode;
    private String iName;
    private PosMajor iMajor;

    public BasePosMajorConcentration() {
    }

    public BasePosMajorConcentration(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pos_major_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="code", nullable=false, length=40)
    public String getCode() {
        return this.iCode;
    }

    public void setCode(String code) {
        this.iCode = code;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="major_id", nullable=false)
    public PosMajor getMajor() {
        return this.iMajor;
    }

    public void setMajor(PosMajor major) {
        this.iMajor = major;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PosMajorConcentration)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PosMajorConcentration)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PosMajorConcentration)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PosMajorConcentration[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "PosMajorConcentration[\n\tCode: " + this.getCode() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tMajor: " + this.getMajor() + "\n\tName: " + this.getName() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

