/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BasePosMajor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iCode;
    private String iName;
    private Session iSession;
    private Set<AcademicArea> iAcademicAreas;
    private Set<PosMajorConcentration> iConcentrations;

    public BasePosMajor() {
    }

    public BasePosMajor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pos_major_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="code", nullable=false, length=40)
    public String getCode() {
        return this.iCode;
    }

    public void setCode(String code) {
        this.iCode = code;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="pos_acad_area_major", joinColumns={@JoinColumn(name="major_id")}, inverseJoinColumns={@JoinColumn(name="academic_area_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<AcademicArea> getAcademicAreas() {
        return this.iAcademicAreas;
    }

    public void setAcademicAreas(Set<AcademicArea> academicAreas) {
        this.iAcademicAreas = academicAreas;
    }

    public void addToAcademicAreas(AcademicArea academicArea) {
        if (this.iAcademicAreas == null) {
            this.iAcademicAreas = new HashSet<AcademicArea>();
        }
        this.iAcademicAreas.add(academicArea);
    }

    @Deprecated
    public void addToacademicAreas(AcademicArea academicArea) {
        this.addToAcademicAreas(academicArea);
    }

    @OneToMany(mappedBy="major")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMajorConcentration> getConcentrations() {
        return this.iConcentrations;
    }

    public void setConcentrations(Set<PosMajorConcentration> concentrations) {
        this.iConcentrations = concentrations;
    }

    public void addToConcentrations(PosMajorConcentration posMajorConcentration) {
        if (this.iConcentrations == null) {
            this.iConcentrations = new HashSet<PosMajorConcentration>();
        }
        this.iConcentrations.add(posMajorConcentration);
    }

    @Deprecated
    public void addToconcentrations(PosMajorConcentration posMajorConcentration) {
        this.addToConcentrations(posMajorConcentration);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PosMajor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PosMajor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PosMajor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PosMajor[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "PosMajor[\n\tCode: " + this.getCode() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tName: " + this.getName() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

