/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BasePointInTimeData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimestamp;
    private String iName;
    private String iNote;
    private Boolean iSavedSuccessfully;
    private Session iSession;

    public BasePointInTimeData() {
    }

    public BasePointInTimeData(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="timestamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="note", nullable=true, length=1000)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="saved_successfully", nullable=false)
    public Boolean isSavedSuccessfully() {
        return this.iSavedSuccessfully;
    }

    @Transient
    public Boolean getSavedSuccessfully() {
        return this.iSavedSuccessfully;
    }

    public void setSavedSuccessfully(Boolean savedSuccessfully) {
        this.iSavedSuccessfully = savedSuccessfully;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PointInTimeData)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PointInTimeData)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PointInTimeData)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PointInTimeData[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "PointInTimeData[\n\tName: " + this.getName() + "\n\tNote: " + this.getNote() + "\n\tSavedSuccessfully: " + this.getSavedSuccessfully() + "\n\tSession: " + this.getSession() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

