/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitCourseOffering;
import org.unitime.timetable.model.PitStudent;
import org.unitime.timetable.model.PitStudentClassEnrollment;

@MappedSuperclass
public abstract class BasePitStudentClassEnrollment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimestamp;
    private String iChangedBy;
    private PitStudent iPitStudent;
    private PitCourseOffering iPitCourseOffering;
    private PitClass iPitClass;

    public BasePitStudentClassEnrollment() {
    }

    public BasePitStudentClassEnrollment(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="timestamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @Column(name="changed_by", nullable=true, length=40)
    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_student_id", nullable=false)
    public PitStudent getPitStudent() {
        return this.iPitStudent;
    }

    public void setPitStudent(PitStudent pitStudent) {
        this.iPitStudent = pitStudent;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_course_offering_id", nullable=false)
    public PitCourseOffering getPitCourseOffering() {
        return this.iPitCourseOffering;
    }

    public void setPitCourseOffering(PitCourseOffering pitCourseOffering) {
        this.iPitCourseOffering = pitCourseOffering;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_class_id", nullable=false)
    public PitClass getPitClass() {
        return this.iPitClass;
    }

    public void setPitClass(PitClass pitClass) {
        this.iPitClass = pitClass;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitStudentClassEnrollment)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitStudentClassEnrollment)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitStudentClassEnrollment)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitStudentClassEnrollment[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitStudentClassEnrollment[\n\tChangedBy: " + this.getChangedBy() + "\n\tPitClass: " + this.getPitClass() + "\n\tPitCourseOffering: " + this.getPitCourseOffering() + "\n\tPitStudent: " + this.getPitStudent() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

